/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.tools.rngom.parse.IllegalSchemaException;
import com.sun.tools.txw2.BadCommandLineException;
import com.sun.tools.txw2.ConsoleErrorReporter;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.model.NodeSet;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Main {
    private final TxwOptions opts;

    public Main(TxwOptions opts) {
        this.opts = opts;
    }

    public static void main(String[] args) {
        System.exit(Main.run(args));
    }

    public static int run(String[] args) {
        TxwOptions topts = new TxwOptions();
        if (args.length == 0) {
            topts.printUsage();
            return 0;
        }
        topts.errorListener = new ConsoleErrorReporter(System.out);
        try {
            topts.parseArguments(args);
        }
        catch (BadCommandLineException e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
                System.out.println();
            }
            topts.printUsage();
            return -1;
        }
        return Main.run(topts);
    }

    public static int run(TxwOptions opts) {
        return new Main(opts).run();
    }

    private int run() {
        try {
            NodeSet ns = this.opts.source.build(this.opts);
            ns.write(this.opts);
            this.opts.codeModel.build(this.opts.codeWriter);
            return 0;
        }
        catch (SAXParseException e) {
            this.opts.errorListener.error(e);
            return 1;
        }
        catch (IllegalSchemaException | IOException | SAXException e) {
            this.opts.errorListener.error(new SAXParseException(e.getMessage(), null, (Exception)e));
            return 1;
        }
    }
}

