/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.FaulthandlerModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.FaulthandlerModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="faulthandler")
public final class FaulthandlerModuleBuiltins
extends PythonBuiltins {
    private boolean enabled = true;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FaulthandlerModuleBuiltinsFactory.getFactories();
    }

    private static void dumpTraceback(Object callable, Object file) {
        if (!(callable instanceof PNone)) {
            Object f = file;
            if (file == PNone.NO_VALUE) {
                f = PNone.NONE;
            }
            try {
                CallNode.executeUncached(callable, PNone.NONE, PNone.NONE, f);
            }
            catch (RuntimeException e) {
                ExceptionUtils.printPythonLikeStackTrace(e);
            }
        }
    }

    @Builtin(name="cancel_dump_traceback_later")
    @GenerateNodeFactory
    static abstract class CancelDumpTracebackLaterNode
    extends PythonBuiltinNode {
        CancelDumpTracebackLaterNode() {
        }

        @Specialization
        PNone doit() {
            return PNone.NONE;
        }
    }

    @Builtin(name="is_enabled", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class IsEnabledNode
    extends PythonUnaryBuiltinNode {
        IsEnabledNode() {
        }

        @Specialization
        static boolean doit(PythonModule self) {
            return ((FaulthandlerModuleBuiltins)self.getBuiltins()).enabled;
        }
    }

    @Builtin(name="disable", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class DisableNode
    extends PythonUnaryBuiltinNode {
        DisableNode() {
        }

        @Specialization
        static PNone doit(PythonModule self) {
            ((FaulthandlerModuleBuiltins)self.getBuiltins()).enabled = false;
            return PNone.NONE;
        }
    }

    @Builtin(name="enable", minNumOfPositionalArgs=1, declaresExplicitSelf=true, parameterNames={"$self", "file", "all_threads"})
    @GenerateNodeFactory
    static abstract class EnableNode
    extends PythonTernaryBuiltinNode {
        EnableNode() {
        }

        @Specialization
        static PNone doit(PythonModule self, Object file, Object allThreads) {
            ((FaulthandlerModuleBuiltins)self.getBuiltins()).enabled = true;
            return PNone.NONE;
        }
    }

    @Builtin(name="dump_traceback", minNumOfPositionalArgs=0, parameterNames={"file", "all_threads"})
    @ArgumentsClinic(value={@ArgumentClinic(name="file", defaultValue="PNone.NO_VALUE"), @ArgumentClinic(name="all_threads", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class DumpTracebackNode
    extends PythonClinicBuiltinNode {
        public static final TruffleString T_PRINT_STACK = PythonUtils.tsLiteral("print_stack");

        DumpTracebackNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PNone doit(VirtualFrame frame, Object file, boolean allThreads, @Cached(value="createFor(this)") IndirectCallData indirectCallData) {
            PythonLanguage language = PythonLanguage.get(this);
            PythonContext context = this.getContext();
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                DumpTracebackNode.dump(language, context, file, allThreads);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void dump(PythonLanguage language, PythonContext context, final Object file, boolean allThreads) {
            Object printStackFunc;
            try {
                PythonModule tracebackModule = AbstractImportNode.importModule(PythonUtils.toTruffleStringUncached("traceback"));
                printStackFunc = PyObjectLookupAttr.executeUncached(tracebackModule, T_PRINT_STACK);
            }
            catch (PException e) {
                return;
            }
            if (allThreads) {
                if (PythonOptions.isPExceptionWithJavaStacktrace(language)) {
                    err = new PrintWriter(context.getStandardErr());
                    Thread[] ths = context.getThreads();
                    for (Map.Entry<Thread, StackTraceElement[]> e : Thread.getAllStackTraces().entrySet()) {
                        boolean found = false;
                        for (Thread pyTh : ths) {
                            if (pyTh != e.getKey()) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        err.println();
                        err.println(e.getKey());
                        for (StackTraceElement el : e.getValue()) {
                            err.println(el.toString());
                        }
                    }
                }
                context.getEnv().submitThreadLocal(null, new ThreadLocalAction(true, false){

                    protected void perform(ThreadLocalAction.Access access) {
                        FaulthandlerModuleBuiltins.dumpTraceback(printStackFunc, file);
                    }
                });
            } else {
                if (PythonOptions.isPExceptionWithJavaStacktrace(language)) {
                    err = new PrintWriter(context.getStandardErr());
                    err.println();
                    err.println(Thread.currentThread());
                    for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
                        err.println(el.toString());
                    }
                }
                FaulthandlerModuleBuiltins.dumpTraceback(printStackFunc, file);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FaulthandlerModuleBuiltinsClinicProviders.DumpTracebackNodeClinicProviderGen.INSTANCE;
        }
    }
}

