/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.StructUnionTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StructureBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodesFactory;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Structure, PythonBuiltinClassType.Union})
public final class StructureBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructureBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.getContext().registerCApiHook(() -> {
            CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_CDATA_INIT_BUFFER_PROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.Structure));
            CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_CDATA_INIT_BUFFER_PROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.Union));
        });
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonBuiltinNode {
        private static final int RECURSION_LIMIT = 5;

        protected InitNode() {
        }

        @Specialization
        static Object Struct_init(VirtualFrame frame, CDataObject self, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PyObjectSetAttr setAttr, @Cached GetClassNode getClassNode, @Cached PyObjectGetItem getItemNode, @Cached CastToTruffleStringNode toString, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached TruffleString.EqualNode equalNode, @Cached PRaiseNode.Lazy raiseNode) {
            int res;
            if (args.length > 0 && (res = InitNode._init_pos_args(frame, inliningTarget, self, getClassNode.execute(inliningTarget, self), args, kwds, 0, indirectCallData, setAttr, getItemNode, toString, getItem, pyTypeStgDictNode, getBaseClassNode, equalNode, raiseNode, 5)) < args.length) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TOO_MANY_INITIALIZERS);
            }
            if (kwds.length > 0) {
                for (PKeyword kw : kwds) {
                    setAttr.execute((Frame)frame, inliningTarget, self, kw.getName(), kw.getValue());
                }
            }
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int _init_pos_args(VirtualFrame frame, Node inliningTarget, Object self, Object type, Object[] args, PKeyword[] kwds, int idx, IndirectCallData indirectCallData, PyObjectSetAttr setAttr, PyObjectGetItem getItemNode, CastToTruffleStringNode toString, HashingStorageNodes.HashingStorageGetItem getItem, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, TypeNodes.GetBaseClassNode getBaseClassNode, TruffleString.EqualNode equalNode, PRaiseNode.Lazy raiseNode, int recursionLimit) {
            StgDictObject dict;
            Object fields;
            int index = idx;
            Object base = getBaseClassNode.execute(inliningTarget, type);
            if (pyTypeStgDictNode.execute(inliningTarget, base) != null) {
                if (recursionLimit > 0) {
                    index = InitNode._init_pos_args(frame, inliningTarget, self, base, args, kwds, index, indirectCallData, setAttr, getItemNode, toString, getItem, pyTypeStgDictNode, getBaseClassNode, equalNode, raiseNode, recursionLimit - 1);
                } else {
                    Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallData);
                    try {
                        index = InitNode._init_pos_args_boundary(self, base, args, kwds, index, indirectCallData, setAttr, getItemNode);
                    }
                    finally {
                        ExecutionContext.IndirectCallContext.exit(frame, indirectCallData, savedState);
                    }
                }
            }
            if ((fields = getItem.execute(inliningTarget, (dict = pyTypeStgDictNode.execute(inliningTarget, type)).getDictStorage(), StructUnionTypeBuiltins.T__FIELDS_)) == null) {
                return index;
            }
            for (int i = 0; i < dict.length && i + index < args.length; ++i) {
                Object pair = getItemNode.execute((Frame)frame, inliningTarget, fields, i);
                TruffleString name = toString.execute(inliningTarget, getItemNode.execute((Frame)frame, inliningTarget, pair, 0));
                Object val = args[i + index];
                if (kwds.length > 0 && KeywordsStorage.findStringKey(kwds, name, equalNode) != -1) {
                    throw raiseNode.get(inliningTarget).execute(inliningTarget, PythonErrorType.TypeError, null, PNone.NO_VALUE, ErrorMessages.DUPLICATE_VALUES_FOR_FIELD_S, new Object[]{name});
                }
                setAttr.execute((Frame)frame, inliningTarget, self, name, val);
            }
            return index + dict.length;
        }

        @CompilerDirectives.TruffleBoundary
        static int _init_pos_args_boundary(Object self, Object type, Object[] args, PKeyword[] kwds, int idx, IndirectCallData indirectCallData, PyObjectSetAttr setAttr, PyObjectGetItem getItemNode) {
            return InitNode._init_pos_args(null, null, self, type, args, kwds, idx, indirectCallData, setAttr, getItemNode, CastToTruffleStringNode.getUncached(), HashingStorageNodesFactory.HashingStorageGetItemNodeGen.getUncached(), StgDictBuiltinsFactory.PyTypeStgDictNodeGen.getUncached(), TypeNodes.GetBaseClassNode.getUncached(), TruffleString.EqualNode.getUncached(), PRaiseNode.Lazy.getUncached(), 0);
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object GenericPyCDataNew(Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            return pyCDataNewNode.execute(inliningTarget, type, dict);
        }
    }
}

