/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.ForeignHashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.dict.DictNodesFactory;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class DictNodes {

    @ImportStatic(value={HashingStorageNodes.HashingStorageGuards.class})
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class UpdateInnerNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, Node var2, Object var3, HashingStorage var4, Object var5, Object var6);

        @Specialization(guards={"!mayHaveSideEffectingEq(selfStorage)"})
        public static void updateDictNoSideEffects(Node inliningTarget, Object self, HashingStorage selfStorage, Object other, HashingStorage otherStorage, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Exclusive @Cached UpdateDictStorageNode updateStorageNode) {
            HashingStorage newStorage = addAllToOther.execute(null, inliningTarget, otherStorage, selfStorage);
            updateStorageNode.execute(inliningTarget, self, selfStorage, newStorage);
        }

        @Specialization(guards={"mayHaveSideEffectingEq(selfStorage)"})
        public static void updateDictGeneric(VirtualFrame frame, Node inliningTarget, Object self, HashingStorage selfStorage, Object other, HashingStorage otherStorage, @Cached.Exclusive @Cached UpdateDictStorageNode updateStorageNode, @Cached HashingStorageNodes.HashingStorageTransferItem transferItem, @Cached HashingStorageNodes.HashingStorageGetIterator getOtherIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageLen otherLenNode, @Cached PRaiseNode.Lazy raiseNode) {
            int initialSize = otherLenNode.execute(inliningTarget, otherStorage);
            HashingStorageNodes.HashingStorageIterator itOther = getOtherIter.execute(inliningTarget, otherStorage);
            HashingStorage newStorage = selfStorage;
            while (iterNext.execute(inliningTarget, otherStorage, itOther)) {
                newStorage = transferItem.execute((Frame)frame, inliningTarget, otherStorage, itOther, newStorage);
                if (initialSize == otherLenNode.execute(inliningTarget, otherStorage)) continue;
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.MUTATED_DURING_UPDATE, "dict");
            }
            updateStorageNode.execute(inliningTarget, self, selfStorage, newStorage);
        }

        @Specialization(guards={"otherStorage == null"})
        public static void updateArg(VirtualFrame frame, Node inliningTarget, Object self, HashingStorage selfStorage, Object other, Object otherStorage, @Cached.Exclusive @Cached UpdateDictStorageNode updateStorageNode, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached PyObjectLookupAttr lookupKeys, @Cached(inline=false) HashingStorage.ObjectToArrayPairNode toArrayPair) {
            Object keyAttr = lookupKeys.execute((Frame)frame, inliningTarget, other, SpecialMethodNames.T_KEYS);
            HashingStorage newStorage = HashingStorage.addKeyValuesToStorage(frame, selfStorage, other, keyAttr, inliningTarget, toArrayPair, setItem);
            updateStorageNode.execute(inliningTarget, self, selfStorage, newStorage);
        }
    }

    public static abstract class UpdateNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, Object var2, Object var3);

        @Specialization
        static void updateDictGeneric(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isDictNode, @Cached GetDictStorageNode getStorageNode, @Cached UpdateInnerNode updateInnerNode) {
            if (self != other) {
                HashingStorage selfStorage = getStorageNode.execute(inliningTarget, self);
                boolean isDict = isDictNode.profileObject(inliningTarget, other, PythonBuiltinClassType.PDict);
                HashingStorage otherStorage = isDict ? getStorageNode.execute(inliningTarget, other) : null;
                updateInnerNode.execute((Frame)frame, inliningTarget, self, selfStorage, other, otherStorage);
            }
        }

        @NeverDefault
        public static UpdateNode create() {
            return DictNodesFactory.UpdateNodeGen.create();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UpdateDictStorageNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, Object var2, HashingStorage var3, HashingStorage var4);

        @Specialization
        static void doPHashingCollection(Node inliningTarget, PHashingCollection dict, HashingStorage oldStorage, HashingStorage newStorage, @Cached.Exclusive @Cached InlinedConditionProfile generalizedProfile) {
            if (generalizedProfile.profile(inliningTarget, oldStorage != newStorage)) {
                dict.setDictStorage(newStorage);
            }
        }

        @Fallback
        static void doForeign(Object dict, HashingStorage oldStorage, HashingStorage newStorage) {
            if (oldStorage != newStorage) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("foreign dict storage should never need to be replaced: " + String.valueOf(dict)));
            }
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetDictStorageNode
    extends PNodeWithContext {
        public abstract HashingStorage execute(Node var1, Object var2);

        @Specialization
        static HashingStorage doPHashingCollection(PHashingCollection dict) {
            return dict.getDictStorage();
        }

        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, dict)", "interop.hasHashEntries(dict)"}, limit="1")
        static HashingStorage doForeign(Node inliningTarget, Object dict, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop) {
            return new ForeignHashingStorage(dict);
        }

        @Fallback
        static HashingStorage doFallback(Node inliningTarget, Object object, @Cached PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_REQUIRES_S_OBJ_RECEIVED_P, "dict", object);
        }
    }
}

