/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.itertools.GrouperBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PGroupBy;
import com.oracle.graal.python.builtins.objects.itertools.PGrouper;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGrouper})
public final class GrouperBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GrouperBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"currValueIsSelf(self)"})
        static Object reduce(PGrouper self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = factory.createTuple(new Object[]{self.getParent(), self.getTgtKey()});
            return factory.createTuple(new Object[]{type, tuple});
        }

        @Specialization(guards={"!currValueIsSelf(self)"})
        Object reduceCurrNotSelf(VirtualFrame frame, PGrouper self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PythonModule builtins = this.getContext().getCore().lookupBuiltinModule(BuiltinNames.T_BUILTINS);
            Object iterCallable = getAttrNode.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_ITER);
            return factory.createTuple(new Object[]{iterCallable, factory.createTuple(new Object[]{factory.createEmptyTuple()})});
        }

        protected boolean currValueIsSelf(PGrouper self) {
            return self.getParent().getCurrGrouper() == self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PGrouper self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached CallNode callNode, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached InlinedBranchProfile currGrouperProfile, @Cached InlinedBranchProfile currValueMarkerProfile, @Cached InlinedBranchProfile currValueTgtProfile, @Cached InlinedConditionProfile hasFuncProfile, @Cached PRaiseNode.Lazy raiseNode) {
            PGroupBy gbo = self.getParent();
            if (gbo.getCurrGrouper() != self) {
                currGrouperProfile.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            if (gbo.getCurrValue() == null) {
                currValueMarkerProfile.enter(inliningTarget);
                gbo.groupByStep(frame, inliningTarget, nextNode, callNode, hasFuncProfile);
            }
            if (!eqNode.compare((Frame)frame, inliningTarget, self.getTgtKey(), gbo.getCurrKey())) {
                currValueTgtProfile.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            Object r = gbo.getCurrValue();
            gbo.setCurrValue(null);
            return r;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PGrouper self) {
            return self;
        }
    }
}

