/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectGetIter
extends Node {
    public static Object executeUncached(Object obj) {
        return PyObjectGetIterNodeGen.getUncached().execute(null, null, obj);
    }

    public final Object executeCached(Frame frame, Object receiver) {
        return this.execute(frame, this, receiver);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3);

    @Specialization
    static Object getIterRange(PIntRange object, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
        return factory.createIntRangeIterator(object);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static Object getIter(Frame frame, Node inliningTarget, Object receiver, @Cached GetClassNode getReceiverClass, @Cached(parameters={"Iter"}, inline=false) LookupSpecialMethodSlotNode lookupIter, @Cached PySequenceCheckNode sequenceCheckNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raise, @Cached(inline=false) CallUnaryMethodNode callIter, @Cached PyIterCheckNode checkNode) {
        Object type = getReceiverClass.execute(inliningTarget, receiver);
        Object iterMethod = PNone.NO_VALUE;
        try {
            iterMethod = lookupIter.execute(frame, type, receiver);
        }
        catch (PException pException) {
            // empty catch block
        }
        if (iterMethod instanceof PNone) {
            if (sequenceCheckNode.execute(inliningTarget, receiver)) {
                return factory.createSequenceIterator(receiver);
            }
        } else {
            Object result = callIter.executeObject(frame, iterMethod, receiver);
            if (!checkNode.execute(inliningTarget, result)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NONITER, result);
            }
            return result;
        }
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, receiver);
    }

    @NeverDefault
    public static PyObjectGetIter create() {
        return PyObjectGetIterNodeGen.create();
    }

    public static PyObjectGetIter getUncached() {
        return PyObjectGetIterNodeGen.getUncached();
    }
}

