/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;

final class StackTraceElementMarshaller
implements BinaryMarshaller<StackTraceElement> {
    static final StackTraceElementMarshaller INSTANCE = new StackTraceElementMarshaller();
    private static final int STACK_TRACE_ELEMENT_SIZE_ESTIMATE = 100;

    private StackTraceElementMarshaller() {
    }

    @Override
    public StackTraceElement read(BinaryInput in) {
        String className = in.readUTF();
        String methodName = in.readUTF();
        String fileName = in.readUTF();
        fileName = fileName.isEmpty() ? null : fileName;
        int lineNumber = in.readInt();
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }

    @Override
    public void write(BinaryOutput out, StackTraceElement stackTraceElement) {
        out.writeUTF(stackTraceElement.getClassName());
        out.writeUTF(stackTraceElement.getMethodName());
        String fileName = stackTraceElement.getFileName();
        out.writeUTF(fileName == null ? "" : fileName);
        out.writeInt(stackTraceElement.getLineNumber());
    }

    @Override
    public int inferSize(StackTraceElement object) {
        return 100;
    }
}

