/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParametersInObjectChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTypeParametersInObjectChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirTypeParametersInObjectChecker INSTANCE = new FirTypeParametersInObjectChecker();

    private FirTypeParametersInObjectChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2.getClassKind() != ClassKind.OBJECT) {
            return;
        }
        FirClass firClass = declaration2;
        if (firClass instanceof FirRegularClass) {
            if (!((Collection)declaration2.getTypeParameters()).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_OBJECT(), (DiagnosticContext)context2, null, 8, null);
            }
        } else if (firClass instanceof FirAnonymousObject) {
            KtSourceElement ktSourceElement;
            KtSourceElement ktSourceElement2 = declaration2.getSource();
            if (ktSourceElement2 != null) {
                IElementType iElementType = KtNodeTypes.TYPE_PARAMETER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TYPE_PARAMETER_LIST");
                ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement2, iElementType, 0, 1, false, 10, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement != null) {
                KtDiagnosticFactory0 diagnosticFactory = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitTypeParametersInAnonymousObjects) ? FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_OBJECT() : FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ANONYMOUS_OBJECT();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), diagnosticFactory, (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

