/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUselessTypeOperationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirUselessTypeOperationCallChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirUselessTypeOperationCallChecker INSTANCE = new FirUselessTypeOperationCallChecker();

    private FirUselessTypeOperationCallChecker() {
    }

    @Override
    public void check(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType refinedTargetType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirOperation.Companion.getTYPES().contains((Object)expression2.getOperation())) {
            return;
        }
        FirCall $this$argument$iv = expression2;
        boolean $i$f$getArgument = false;
        FirExpression arg = (FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments());
        ConeSimpleKotlinType candidateType = TypeExpansionUtilsKt.fullyExpandedType(ConeTypesKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(arg.getTypeRef())), context2.getSession());
        if (candidateType instanceof ConeClassErrorType) {
            return;
        }
        ConeKotlinType targetType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(expression2.getConversionTypeRef()), context2.getSession());
        if (targetType instanceof ConeClassErrorType) {
            return;
        }
        ConeKotlinType coneKotlinType = refinedTargetType = expression2.getOperation() == FirOperation.SAFE_AS ? TypeUtilsKt.withNullability$default(targetType, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(context2.getSession()), null, 4, null) : targetType;
        if (FirCastDiagnosticsHelpersKt.isRefinementUseless(context2, candidateType, refinedTargetType, FirCastDiagnosticsHelpersKt.shouldCheckForExactType(expression2, context2), arg)) {
            switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
                case 1: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)true, (DiagnosticContext)context2, null, 16, null);
                    break;
                }
                case 2: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)false, (DiagnosticContext)context2, null, 16, null);
                    break;
                }
                case 3: 
                case 4: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CAST(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Should not be here: " + (Object)((Object)expression2.getOperation())));
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            nArray[FirOperation.IS.ordinal()] = 1;
            nArray[FirOperation.NOT_IS.ordinal()] = 2;
            nArray[FirOperation.AS.ordinal()] = 3;
            nArray[FirOperation.SAFE_AS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

