/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirUnitExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aH\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"extractLambdaInfoFromFunctionalType", "Lorg/jetbrains/kotlin/fir/resolve/inference/ResolvedLambdaAtom;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "argument", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "returnTypeVariable", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConeTypeVariableForLambdaReturnType;", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "duringCompletion", "", "resolve"})
@SourceDebugExtension(value={"SMAP\nInferenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferenceUtils.kt\norg/jetbrains/kotlin/fir/resolve/inference/InferenceUtilsKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n21#2,4:114\n21#2,4:122\n1559#3:118\n1590#3,3:119\n1593#3:126\n1549#3:127\n1620#3,3:128\n*S KotlinDebug\n*F\n+ 1 InferenceUtils.kt\norg/jetbrains/kotlin/fir/resolve/inference/InferenceUtilsKt\n*L\n79#1:114,4\n85#1:122,4\n84#1:118\n84#1:119,3\n84#1:126\n97#1:127\n97#1:128,3\n*E\n"})
public final class InferenceUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ResolvedLambdaAtom extractLambdaInfoFromFunctionalType(@Nullable ConeKotlinType expectedType, @Nullable FirTypeRef expectedTypeRef, @NotNull FirAnonymousFunction argument2, @Nullable ConeTypeVariableForLambdaReturnType returnTypeVariable, @NotNull BodyResolveComponents components2, @Nullable Candidate candidate2, boolean duringCompletion) {
        List list2;
        Iterable<ConeKotlinType> iterable;
        Iterable<ConeKotlinType> destination$iv$iv;
        List list3;
        ConeKotlinType coneKotlinType;
        FirReturnExpression singleStatement;
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        FirSession session2 = components2.getSession();
        if (expectedType == null) {
            return null;
        }
        if (expectedType instanceof ConeFlexibleType) {
            return InferenceUtilsKt.extractLambdaInfoFromFunctionalType(((ConeFlexibleType)expectedType).getLowerBound(), expectedTypeRef, argument2, returnTypeVariable, components2, candidate2, duringCompletion);
        }
        if (!org.jetbrains.kotlin.fir.types.InferenceUtilsKt.isBuiltinFunctionalType(expectedType, session2)) {
            return null;
        }
        Object object = argument2.getBody();
        FirStatement firStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.singleOrNull((List)object) : null;
        FirReturnExpression firReturnExpression = singleStatement = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
        if (org.jetbrains.kotlin.fir.types.InferenceUtilsKt.getReturnType(argument2) == null && singleStatement != null && Intrinsics.areEqual((Object)singleStatement.getTarget().getLabeledElement(), (Object)argument2) && singleStatement.getResult() instanceof FirUnitExpression) {
            argument2.replaceReturnTypeRef(session2.getBuiltinTypes().getUnitType());
        }
        if ((coneKotlinType = org.jetbrains.kotlin.fir.types.InferenceUtilsKt.getReturnType(argument2)) == null) {
            coneKotlinType = org.jetbrains.kotlin.fir.types.InferenceUtilsKt.returnType(expectedType, session2);
        }
        ConeKotlinType returnType2 = coneKotlinType;
        ConeKotlinType receiverType = argument2.isLambda() ? org.jetbrains.kotlin.fir.types.InferenceUtilsKt.receiverType(expectedType, session2) : org.jetbrains.kotlin.fir.types.InferenceUtilsKt.getReceiverType(argument2);
        int contextReceiversNumber = argument2.isLambda() ? CompilerConeAttributesKt.getContextReceiversNumberForFunctionType(expectedType) : argument2.getContextReceivers().size();
        List valueParametersTypesIncludingReceiver = org.jetbrains.kotlin.fir.types.InferenceUtilsKt.valueParameterTypesIncludingReceiver(expectedType, session2);
        boolean isExtensionFunctionType = TypeUtilsKt.isExtensionFunctionType(expectedType, session2);
        List it = valueParametersTypesIncludingReceiver;
        boolean bl = false;
        int forExtension = receiverType != null && isExtensionFunctionType ? 1 : 0;
        int toDrop = forExtension + contextReceiversNumber;
        List expectedParameters = toDrop > 0 ? CollectionsKt.drop((Iterable)it, (int)toDrop) : it;
        boolean coerceFirstParameterToExtensionReceiver = false;
        List<FirValueParameter> argumentValueParameters = argument2.getValueParameters();
        if (argument2.isLambda() && !argument2.getHasExplicitParameterList() && expectedParameters.size() < 2) {
            list3 = expectedParameters;
        } else {
            void $this$mapIndexedTo$iv$iv;
            if (duringCompletion && argument2.isLambda() && isExtensionFunctionType && valueParametersTypesIncludingReceiver.size() == argumentValueParameters.size()) {
                ConeKotlinType coneKotlinType2;
                FirValueParameter firstValueParameter = (FirValueParameter)CollectionsKt.firstOrNull(argumentValueParameters);
                ConeKotlinType extensionParameter = (ConeKotlinType)CollectionsKt.firstOrNull((List)valueParametersTypesIncludingReceiver);
                FirPureAbstractElement firPureAbstractElement = firstValueParameter;
                if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null) {
                    FirPureAbstractElement $this$coneTypeSafe$iv = firPureAbstractElement;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                        coneKotlinType2 = null;
                    }
                } else {
                    coneKotlinType2 = null;
                }
                ConeKotlinType coneKotlinType3 = extensionParameter;
                if (Intrinsics.areEqual(coneKotlinType2, (Object)(coneKotlinType3 != null ? coneKotlinType3.getType() : null))) {
                    coerceFirstParameterToExtensionReceiver = true;
                }
            }
            Iterable $this$mapIndexed$iv = argumentValueParameters;
            boolean $i$f$mapIndexed = false;
            Iterable iterable2 = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index2;
                ConeKotlinType coneKotlinType4;
                void parameter;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FirValueParameter firValueParameter2 = (FirValueParameter)item$iv$iv;
                int n2 = n;
                iterable = destination$iv$iv;
                boolean bl2 = false;
                FirTypeRef $this$coneTypeSafe$iv = parameter.getReturnTypeRef();
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType5 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType5 instanceof ConeKotlinType)) {
                    coneKotlinType5 = coneKotlinType4 = null;
                }
                if (coneKotlinType5 == null && (coneKotlinType4 = (ConeKotlinType)CollectionsKt.getOrNull((List)expectedParameters, (int)index2)) == null) {
                    coneKotlinType4 = new ConeErrorType(new ConeSimpleDiagnostic("Cannot infer type for parameter " + parameter.getName(), DiagnosticKind.CannotInferParameterType), false, null, null, 14, null);
                }
                iterable.add((ConeKotlinType)coneKotlinType4);
            }
            list3 = (List)destination$iv$iv;
        }
        List parameters2 = list3;
        if (contextReceiversNumber == 0) {
            list2 = CollectionsKt.emptyList();
        } else if (argument2.isLambda()) {
            list2 = valueParametersTypesIncludingReceiver.subList(0, contextReceiversNumber);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = argument2.getContextReceivers();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirContextReceiver firContextReceiver = (FirContextReceiver)item$iv$iv;
                iterable = destination$iv$iv2;
                boolean bl3 = false;
                iterable.add(FirTypeUtilsKt.getConeType(it2.getTypeRef()));
            }
            list2 = (List)destination$iv$iv2;
        }
        List contextReceivers = list2;
        return new ResolvedLambdaAtom(argument2, expectedType, org.jetbrains.kotlin.fir.types.InferenceUtilsKt.isSuspendOrKSuspendFunctionType(expectedType, session2), receiverType, contextReceivers, parameters2, returnType2, returnTypeVariable, candidate2, coerceFirstParameterToExtensionReceiver);
    }
}

