/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.AbiSnapshotImpl;
import org.jetbrains.kotlin.incremental.util.ExceptionLocation;
import org.jetbrains.kotlin.incremental.util.MessageCollectorUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0006H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildInfo;", "Ljava/io/Serializable;", "startTS", "", "dependencyToAbiSnapshot", "", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "(JLjava/util/Map;)V", "getDependencyToAbiSnapshot", "()Ljava/util/Map;", "getStartTS", "()J", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "incremental-compilation-impl"})
public final class BuildInfo
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long startTS;
    @NotNull
    private final Map<String, AbiSnapshot> dependencyToAbiSnapshot;

    public BuildInfo(long startTS, @NotNull Map<String, ? extends AbiSnapshot> dependencyToAbiSnapshot) {
        Intrinsics.checkNotNullParameter(dependencyToAbiSnapshot, (String)"dependencyToAbiSnapshot");
        this.startTS = startTS;
        this.dependencyToAbiSnapshot = dependencyToAbiSnapshot;
    }

    public /* synthetic */ BuildInfo(long l, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(l, map);
    }

    public final long getStartTS() {
        return this.startTS;
    }

    @NotNull
    public final Map<String, AbiSnapshot> getDependencyToAbiSnapshot() {
        return this.dependencyToAbiSnapshot;
    }

    public final long component1() {
        return this.startTS;
    }

    @NotNull
    public final Map<String, AbiSnapshot> component2() {
        return this.dependencyToAbiSnapshot;
    }

    @NotNull
    public final BuildInfo copy(long startTS, @NotNull Map<String, ? extends AbiSnapshot> dependencyToAbiSnapshot) {
        Intrinsics.checkNotNullParameter(dependencyToAbiSnapshot, (String)"dependencyToAbiSnapshot");
        return new BuildInfo(startTS, dependencyToAbiSnapshot);
    }

    public static /* synthetic */ BuildInfo copy$default(BuildInfo buildInfo, long l, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            l = buildInfo.startTS;
        }
        if ((n & 2) != 0) {
            map = buildInfo.dependencyToAbiSnapshot;
        }
        return buildInfo.copy(l, map);
    }

    @NotNull
    public String toString() {
        return "BuildInfo(startTS=" + this.startTS + ", dependencyToAbiSnapshot=" + this.dependencyToAbiSnapshot + ')';
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.startTS);
        result2 = result2 * 31 + ((Object)this.dependencyToAbiSnapshot).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildInfo)) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)other;
        if (this.startTS != buildInfo.startTS) {
            return false;
        }
        return Intrinsics.areEqual(this.dependencyToAbiSnapshot, buildInfo.dependencyToAbiSnapshot);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\f\u001a\u00020\u0004*\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\n*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildInfo$Companion;", "", "()V", "read", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "file", "Ljava/io/File;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "write", "", "buildInfo", "readBuildInfo", "Ljava/io/ObjectInputStream;", "writeBuildInfo", "Ljava/io/ObjectOutputStream;", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        private final BuildInfo readBuildInfo(ObjectInputStream $this$readBuildInfo) {
            long ts = $this$readBuildInfo.readLong();
            int size = $this$readBuildInfo.readInt();
            HashMap<String, AbiSnapshotImpl> abiSnapshots = new HashMap<String, AbiSnapshotImpl>(size);
            int n = 0;
            while (n < size) {
                int it = n++;
                boolean bl = false;
                String identifier = $this$readBuildInfo.readUTF();
                AbiSnapshotImpl snapshot2 = AbiSnapshotImpl.Companion.readAbiSnapshot($this$readBuildInfo);
                abiSnapshots.put(identifier, snapshot2);
            }
            return new BuildInfo(ts, (Map<String, ? extends AbiSnapshot>)abiSnapshots);
        }

        private final void writeBuildInfo(ObjectOutputStream $this$writeBuildInfo, BuildInfo buildInfo) {
            $this$writeBuildInfo.writeLong(buildInfo.getStartTS());
            $this$writeBuildInfo.writeInt(buildInfo.getDependencyToAbiSnapshot().size());
            for (Map.Entry<String, AbiSnapshot> entry : buildInfo.getDependencyToAbiSnapshot().entrySet()) {
                String identifier = entry.getKey();
                AbiSnapshot abiSnapshot2 = entry.getValue();
                $this$writeBuildInfo.writeUTF(identifier);
                AbiSnapshotImpl.Companion.writeAbiSnapshot($this$writeBuildInfo, abiSnapshot2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final BuildInfo read(@NotNull File file2, @NotNull MessageCollector messageCollector) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            try {
                BuildInfo buildInfo;
                object = new ObjectInputStream(new FileInputStream(file2));
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl = false;
                    buildInfo = Companion.readBuildInfo(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = buildInfo;
            }
            catch (Exception e) {
                MessageCollectorUtilKt.reportException(messageCollector, e, ExceptionLocation.INCREMENTAL_COMPILATION);
                object = null;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(@NotNull BuildInfo buildInfo, @NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Closeable closeable = new ObjectOutputStream(new FileOutputStream(file2));
            Throwable throwable = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)closeable;
                boolean bl = false;
                Companion.writeBuildInfo(it, buildInfo);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

