/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J3\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0006\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00150\u0014H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "convertToRegularConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "removeConstructorForExport", "", "withoutFirst", "T", "", "predicate", "Lkotlin/Function1;", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6PrimaryConstructorOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 4 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n136#1,11:263\n223#2,4:259\n24#3,13:274\n26#4:287\n1#5:288\n*S KotlinDebug\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6PrimaryConstructorOptimizationLowering\n*L\n61#1:263,11\n50#1:259,4\n65#1:274,13\n65#1:287\n*E\n"})
public final class ES6PrimaryConstructorOptimizationLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6PrimaryConstructorOptimizationLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(this.context.getEs6mode() && declaration instanceof IrFunction && ES6PrimaryConstructorOptimizationLoweringKt.access$shouldBeConvertedToPlainConstructor((IrFunction)declaration, this.context))) {
            return null;
        }
        IrClass irClass2 = IrUtilsKt.getParentAsClass(declaration);
        if (ExportModelGeneratorKt.isExported(irClass2, this.context)) {
            this.removeConstructorForExport(irClass2);
        }
        return CollectionsKt.listOf((Object)this.convertToRegularConstructor((IrFunction)declaration, irClass2));
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor convertToRegularConstructor(IrFunction $this$convertToRegularConstructor, IrClass irClass2) {
        IrBody irBody;
        IrConstructor constructor2;
        IrConstructor irConstructor2;
        IrValueParameterSymbol classThisSymbol;
        IrClass superClass;
        IrFunction original;
        block7: {
            List list2;
            void $this$withoutFirst$iv;
            original = $this$convertToRegularConstructor;
            superClass = IrUtilsKt.getSuperClass(irClass2);
            IrValueParameter irValueParameter = irClass2.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            classThisSymbol = irValueParameter.getSymbol();
            IrFactory $this$buildConstructor$iv = $this$convertToRegularConstructor.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = false;
            Object $this$convertToRegularConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u2422$iv;
            boolean bl = false;
            ((IrFunctionBuilder)$this$convertToRegularConstructor_u24lambda_u240).updateFrom(original);
            ((IrFunctionBuilder)$this$convertToRegularConstructor_u24lambda_u240).setPrimary(true);
            ((IrFunctionBuilder)$this$convertToRegularConstructor_u24lambda_u240).setReturnType(original.getReturnType());
            ((IrDeclarationBuilder)$this$convertToRegularConstructor_u24lambda_u240).setOrigin(IrDeclarationOrigin.DEFINED.INSTANCE);
            constructor2 = irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2422$iv);
            boolean bl2 = false;
            IrUtilsKt.copyAnnotationsFrom(constructor2, original);
            IrUtilsKt.copyParameterDeclarationsFrom(constructor2, original);
            constructor2.setParent(irClass2);
            if (!ExportModelGeneratorKt.isExported(irClass2, this.context)) break block7;
            ES6PrimaryConstructorOptimizationLowering $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this;
            $this$convertToRegularConstructor_u24lambda_u240 = original.getAnnotations();
            IrConstructor irConstructor3 = constructor2;
            boolean $i$f$withoutFirst = false;
            void original$iv = $this$withoutFirst$iv;
            List $this$withoutFirst_u24lambda_u245$iv = list2 = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            boolean isFirstMatch$iv = true;
            for (Object element$iv : original$iv) {
                block9: {
                    block8: {
                        if (!isFirstMatch$iv) break block8;
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl4 = false;
                        if (IrUtilsKt.isAnnotation(it, JsAnnotations.INSTANCE.getJsExportIgnoreFqn())) break block9;
                    }
                    $this$withoutFirst_u24lambda_u245$iv.add(element$iv);
                    continue;
                }
                isFirstMatch$iv = false;
            }
            irConstructor3.setAnnotations(CollectionsKt.build((List)list2));
        }
        IrValueParameter boxParameter = ES6AddBoxParameterLoweringKt.getBoxParameter(constructor2);
        IrBody irBody2 = original.getBody();
        if (irBody2 != null) {
            void p1;
            DeepCopyTypeRemapper typeRemapper$iv$iv;
            void $this$deepCopyWithSymbols$iv$iv;
            IrElement $this$deepCopyWithSymbols_u24default$iv = irBody2;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement isFirstMatch$iv = $this$deepCopyWithSymbols_u24default$iv;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            boolean $i$f$deepCopyWithSymbols2 = false;
            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
            TypeRemapper bl4 = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
            void var11_17 = $this$deepCopyWithSymbols$iv$iv;
            boolean bl = false;
            bl4 = bl4;
            SymbolRemapper p0 = deepCopySymbolRemapper;
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents(var11_17.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), constructor2);
            if (irElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
            }
            irBody = (IrBody)((IrElement)((IrBody)irElement));
        } else {
            irBody = null;
        }
        Intrinsics.checkNotNull(irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        Object object = (IrBlockBody)irBody;
        IrBlockBody it = object;
        boolean bl = false;
        constructor2.setBody(it);
        IrBlockBody body2 = object;
        object = MapsKt.emptyMap();
        IrElementTransformerVoidKt.transformChildrenVoid(body2, new ValueRemapper(original, constructor2, this, classThisSymbol, boxParameter, superClass, irClass2, (Map<IrValueSymbol, ? extends IrValueSymbol>)object){
            @NotNull
            private final Map<IrValueSymbol, IrValueSymbol> map;
            final /* synthetic */ IrFunction $original;
            final /* synthetic */ ES6PrimaryConstructorOptimizationLowering this$0;
            final /* synthetic */ IrValueParameterSymbol $classThisSymbol;
            final /* synthetic */ IrValueParameter $boxParameter;
            final /* synthetic */ IrClass $superClass;
            final /* synthetic */ IrClass $irClass;
            {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                this.$original = $original;
                this.this$0 = $receiver;
                this.$classThisSymbol = $classThisSymbol;
                this.$boxParameter = $boxParameter;
                this.$superClass = $superClass;
                this.$irClass = $irClass;
                super($super_call_param$1);
                Iterable iterable = CollectionsKt.zip((Iterable)$original.getValueParameters(), (Iterable)$constructor.getValueParameters());
                convertToRegularConstructor.2.2 var20_10 = this;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                void var12_13 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    Pair it = (Pair)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)((IrValueParameter)it.getFirst()).getSymbol(), (Object)((IrValueParameter)it.getSecond()).getSymbol());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                var20_10.map = MapsKt.toMutableMap((Map)destination$iv$iv);
            }

            @NotNull
            protected Map<IrValueSymbol, IrValueSymbol> getMap() {
                return this.map;
            }

            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$original.getSymbol())) {
                    return IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0));
                }
                return super.visitReturn(expression2);
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsBoxApplySymbol()) ? IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0)) : super.visitCall(expression2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrExpression initializer2 = declaration.getInitializer();
                if (initializer2 instanceof IrCall) {
                    if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)initializer2)) {
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        return super.visitCall((IrCall)initializer2);
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)initializer2).getSymbol(), (Object)ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateThisSymbol())) {
                        IrStatement irStatement;
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        if (this.$boxParameter != null && this.$superClass == null) {
                            void $this$visitVariable_u24lambda_u241;
                            IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsBoxApplySymbol(), null, null, null, null, 30, null);
                            IrClass irClass2 = this.$irClass;
                            IrValueParameter irValueParameter = this.$boxParameter;
                            IrCall irCall2 = irCall;
                            convertToRegularConstructor.2.2 var17_11 = this;
                            boolean bl = false;
                            IrValueParameter irValueParameter2 = irClass2.getThisReceiver();
                            Intrinsics.checkNotNull((Object)irValueParameter2);
                            $this$visitVariable_u24lambda_u241.putValueArgument(0, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, irValueParameter2.getSymbol(), null, 2, null));
                            $this$visitVariable_u24lambda_u241.putValueArgument(1, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, irValueParameter.getSymbol(), null, 2, null));
                            irStatement = super.visitCall(irCall);
                        } else {
                            irStatement = IrJsUtilsKt.irEmpty(ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0));
                        }
                        return irStatement;
                    }
                    if (Intrinsics.areEqual((Object)((IrCall)initializer2).getSymbol(), (Object)ES6PrimaryConstructorOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateExternalThisSymbol())) {
                        IrDelegatingConstructorCall irDelegatingConstructorCall2;
                        this.getMap().put(declaration.getSymbol(), this.$classThisSymbol);
                        Object object = this.$superClass;
                        if (object == null || (object = IrUtilsKt.getPrimaryConstructor((IrClass)object)) == null || (object = ((IrConstructor)object).getSymbol()) == null) {
                            throw new IllegalStateException("Expect to have external constructor here".toString());
                        }
                        Object externalConstructor = object;
                        IrExpression $this$visitVariable_u24lambda_u241 = ((IrCall)initializer2).getValueArgument(2);
                        IrVararg irVararg = $this$visitVariable_u24lambda_u241 instanceof IrVararg ? (IrVararg)$this$visitVariable_u24lambda_u241 : null;
                        if (irVararg == null) {
                            throw new IllegalStateException("Wrong type of argument was provided".toString());
                        }
                        IrVararg parameters2 = irVararg;
                        IrDelegatingConstructorCall $this$visitVariable_u24lambda_u243 = irDelegatingConstructorCall2 = JsIrBuilder.buildDelegatingConstructorCall$default(JsIrBuilder.INSTANCE, (IrConstructorSymbol)externalConstructor, null, 2, null);
                        boolean bl = false;
                        Iterable $this$forEachIndexed$iv = parameters2.getElements();
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (T item$iv : $this$forEachIndexed$iv) {
                            void it;
                            int n;
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            IrVarargElement irVarargElement = (IrVarargElement)item$iv;
                            int i = n;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                            $this$visitVariable_u24lambda_u243.putValueArgument(i, (IrExpression)it);
                        }
                        return irDelegatingConstructorCall2;
                    }
                }
                return super.visitVariable(declaration);
            }
        });
        return irConstructor2;
    }

    private final void removeConstructorForExport(IrClass $this$removeConstructorForExport) {
        $this$removeConstructorForExport.getDeclarations().removeIf(arg_0 -> ES6PrimaryConstructorOptimizationLowering.removeConstructorForExport$lambda$4(removeConstructorForExport.1.INSTANCE, arg_0));
    }

    private static final boolean removeConstructorForExport$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ JsIrBackendContext access$getContext$p(ES6PrimaryConstructorOptimizationLowering $this) {
        return $this.context;
    }
}

