/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.resolve.ShadowedExtensionChecker;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeAliasExpander;
import org.jetbrains.kotlin.types.TypeAliasExpansion;
import org.jetbrains.kotlin.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u0000 \u0081\u00012\u00020\u0001:\u0004\u0081\u0001\u0082\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u0002052\u0006\u00100\u001a\u000201H\u0002J\u0018\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u0002082\u0006\u00104\u001a\u000205H\u0002J\u001c\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030<H\u0002J\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u000208H\u0002J\u0018\u0010?\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;2\u0006\u0010+\u001a\u00020'H\u0002J\u0018\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u001c\u0010E\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030<H\u0002J\u0018\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020H2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010I\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020H2\u0006\u0010(\u001a\u00020JJ\u0018\u0010K\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010O\u001a\u00020\u001b2\u0006\u00104\u001a\u00020D2\u0006\u00100\u001a\u000201H\u0002J\u0016\u0010P\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J \u0010Q\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00104\u001a\u00020DH\u0002J\u0010\u0010R\u001a\u00020\u001b2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010S\u001a\u00020\u001b2\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010V\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020W2\u0006\u00104\u001a\u000205H\u0002J \u0010X\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020Y2\u0006\u0010+\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020\u001b2\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010^\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u00020DH\u0002J\u0018\u0010_\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020'2\u0006\u0010M\u001a\u00020`H\u0002J\u0018\u0010a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010b\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010c\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020\u001dH\u0002J\u0018\u0010d\u001a\u00020\u001b2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0002J\u0018\u0010i\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010j\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010k\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020\\H\u0002J\u0010\u0010m\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020\\H\u0002J\u0010\u0010n\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010o\u001a\u00020\u001b2\u0006\u00107\u001a\u000208H\u0002J\u0018\u0010p\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020NH\u0002J\u001e\u0010r\u001a\b\u0012\u0004\u0012\u00020Y0s2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020.H\u0002J\u0010\u0010w\u001a\u00020x2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010y\u001a\u00020\u001b2\u0006\u0010z\u001a\u00020{J%\u0010|\u001a\u00020\u001b2\f\u0010}\u001a\b\u0012\u0004\u0012\u00020h0~2\r\u0010\u007f\u001a\t\u0012\u0004\u0012\u00020h0\u0080\u0001H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0017R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001\u00b2\u0006\f\u0010\u0084\u0001\u001a\u00030\u0085\u0001X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "exposedChecker", "Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "shadowedExtensionChecker", "Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkActualFunction", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkActualTypeAlias", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkAnnotationClassMembers", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkBackingField", "checkClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "checkConstructorInInterface", "klass", "checkConstructorVisibility", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkExpectedClassConstructor", "checkExpectedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkFunction", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkLocalAnnotation", "checkLocalTypeAliasDeclaration", "checkMemberProperty", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkPrivateExpectedDeclaration", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkProperty", "checkPropertyInitializer", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "checkTypeAliasDeclaration", "checkTypeAliasExpansion", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "getUsedTypeAliasParameters", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeAlias", "noExplicitTypeOrGetterType", "", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Companion", "TypeAliasDeclarationCheckingReportStrategy", "frontend", "delegateClassScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;"})
@SourceDebugExtension(value={"SMAP\nDeclarationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1549#2:1078\n1620#2,3:1079\n800#2,11:1082\n1747#2,3:1093\n1747#2,3:1096\n1549#2:1099\n1620#2,3:1100\n1611#2:1103\n1855#2:1104\n1856#2:1107\n1612#2:1108\n1549#2:1109\n1620#2,3:1110\n3190#2,10:1113\n766#2:1123\n857#2,2:1124\n1603#2,9:1126\n1855#2:1135\n1856#2:1137\n1612#2:1138\n1549#2:1139\n1620#2,3:1140\n288#2,2:1143\n1549#2:1145\n1620#2,3:1146\n1549#2:1149\n1620#2,3:1150\n1855#2,2:1153\n1855#2,2:1155\n766#2:1157\n857#2,2:1158\n1#3:1105\n1#3:1106\n1#3:1136\n*S KotlinDebug\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker\n*L\n112#1:1078\n112#1:1079,3\n113#1:1082,11\n179#1:1093,3\n184#1:1096,3\n189#1:1099\n189#1:1100,3\n197#1:1103\n197#1:1104\n197#1:1107\n197#1:1108\n392#1:1109\n392#1:1110,3\n393#1:1113,10\n402#1:1123\n402#1:1124,2\n405#1:1126,9\n405#1:1135\n405#1:1137\n405#1:1138\n406#1:1139\n406#1:1140,3\n409#1:1143,2\n425#1:1145\n425#1:1146,3\n438#1:1149\n438#1:1150,3\n541#1:1153,2\n754#1:1155,2\n986#1:1157\n986#1:1158,2\n197#1:1106\n405#1:1136\n*E\n"})
public final class DeclarationsChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DescriptorResolver descriptorResolver;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    @NotNull
    private final ExposedVisibilityChecker exposedChecker;
    @NotNull
    private final ShadowedExtensionChecker shadowedExtensionChecker;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor, @NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkNotNullParameter((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkNotNullParameter((Object)annotationChecker, (String)"annotationChecker");
        Intrinsics.checkNotNullParameter((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkNotNullParameter((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
        Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings2;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.upperBoundChecker = upperBoundChecker;
        ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = modifiersChecker.withTrace(this.trace);
        Intrinsics.checkNotNullExpressionValue((Object)modifiersCheckingProcedure, (String)"modifiersChecker.withTrace(trace)");
        this.modifiersChecker = modifiersCheckingProcedure;
        this.exposedChecker = new ExposedVisibilityChecker(this.languageVersionSettings, this.trace);
        this.shadowedExtensionChecker = new ShadowedExtensionChecker(typeSpecificityComparator, this.trace);
    }

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        KtDeclarationStub declaration;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object propertyDescriptor;
        Intrinsics.checkNotNullParameter((Object)bodiesResolveContext, (String)"bodiesResolveContext");
        for (KtFile ktFile : bodiesResolveContext.getFiles()) {
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile);
            this.annotationChecker.check(ktFile, this.trace, null);
        }
        for (Map.Entry entry : bodiesResolveContext.getDeclaredClasses().entrySet()) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor2 = (ClassDescriptorWithResolutionScopes)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"classDescriptor");
            Intrinsics.checkNotNullExpressionValue((Object)ktClassOrObject, (String)"classOrObject");
            this.checkClass(classDescriptor2, ktClassOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(ktClassOrObject, classDescriptor2);
            this.identifierChecker.checkDeclaration(ktClassOrObject, this.trace);
            this.exposedChecker.checkClassHeader(ktClassOrObject, classDescriptor2);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            KtNamedFunction ktNamedFunction = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)ktNamedFunction, (String)"function");
            Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"functionDescriptor");
            this.checkFunction(ktNamedFunction, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktNamedFunction, functionDescriptor);
            this.identifierChecker.checkDeclaration(ktNamedFunction, this.trace);
        }
        for (Map.Entry entry : bodiesResolveContext.getProperties().entrySet()) {
            KtProperty ktProperty = (KtProperty)entry.getKey();
            propertyDescriptor = (PropertyDescriptor)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"property");
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"propertyDescriptor");
            this.checkProperty(ktProperty, (PropertyDescriptor)propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(ktProperty, (MemberDescriptor)propertyDescriptor);
            this.identifierChecker.checkDeclaration(ktProperty, this.trace);
        }
        Iterable iterable = bodiesResolveContext.getDestructuringDeclarationEntries().entrySet();
        boolean bl = false;
        propertyDescriptor = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KtDestructuringDeclarationEntry entry2 = (KtDestructuringDeclarationEntry)entry.getKey();
            collection.add(entry2.getParent());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        boolean bl3 = false;
        $this$mapTo$iv$iv = iterable2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtDestructuringDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List destructuringDeclarations = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        for (KtDestructuringDeclaration ktDestructuringDeclaration : destructuringDeclarations) {
            this.modifiersChecker.checkModifiersForDestructuringDeclaration(ktDestructuringDeclaration);
            this.identifierChecker.checkDeclaration(ktDestructuringDeclaration, this.trace);
        }
        for (Map.Entry<KtSecondaryConstructor, ClassConstructorDescriptor> entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            declaration = entry.getKey();
            ClassConstructorDescriptor constructorDescriptor = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)constructorDescriptor, (String)"constructorDescriptor");
            Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"declaration");
            this.checkConstructorDeclaration(constructorDescriptor, (KtConstructor<?>)declaration);
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, declaration, constructorDescriptor, null, 4, null);
        }
        for (Map.Entry<KtTypeAlias, TypeAliasDescriptor> entry : bodiesResolveContext.getTypeAliases().entrySet()) {
            declaration = entry.getKey();
            TypeAliasDescriptor typeAliasDescriptor = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullExpressionValue((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
            this.checkTypeAliasDeclaration((KtTypeAlias)declaration, typeAliasDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
            this.exposedChecker.checkTypeAlias((KtTypeAlias)declaration, typeAliasDescriptor);
        }
    }

    public final void checkLocalTypeAliasDeclaration(@NotNull KtTypeAlias declaration, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        this.checkTypeAliasDeclaration(declaration, typeAliasDescriptor);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
        this.exposedChecker.checkTypeAlias(declaration, typeAliasDescriptor);
    }

    private final void checkTypeAliasDeclaration(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        KtTypeReference ktTypeReference = declaration.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        this.checkTypeAliasExpansion(declaration, typeAliasDescriptor);
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        ClassifierDescriptor expandedClassifier = expandedType2.getConstructor().getDeclarationDescriptor();
        if (DynamicTypesKt.isDynamic(expandedType2) || expandedClassifier instanceof TypeParameterDescriptor) {
            this.trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), expandedType2));
        }
        if (TypeUtils.contains((KotlinType)expandedType2, (Function1<UnwrappedType, Boolean>)((Function1)checkTypeAliasDeclaration.1.INSTANCE))) {
            this.trace.report(Errors.TYPEALIAS_EXPANDED_TO_MALFORMED_TYPE.on((KtTypeReference)((PsiElement)typeReference), expandedType2, "Array<Nothing> is illegal"));
        }
        Set<TypeParameterDescriptor> usedTypeAliasParameters = this.getUsedTypeAliasParameters(expandedType2, typeAliasDescriptor);
        for (TypeParameterDescriptor typeParameter2 : typeAliasDescriptor.getDeclaredTypeParameters()) {
            KtTypeParameter source;
            if (usedTypeAliasParameters.contains(typeParameter2)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameter2);
            if ((psiElement instanceof KtTypeParameter ? (KtTypeParameter)psiElement : null) == null) {
                throw new AssertionError((Object)("No source element for type parameter " + typeParameter2 + " of " + typeAliasDescriptor));
            }
            source = source;
            this.trace.report(Errors.UNUSED_TYPEALIAS_PARAMETER.on((KtTypeParameter)((PsiElement)source), typeParameter2, expandedType2));
        }
        if (PsiUtilsKt.hasActualModifier(declaration)) {
            this.checkActualTypeAlias(declaration, typeAliasDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualTypeAlias(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        void $this$mapTo$iv$iv;
        boolean bl;
        SimpleType rhs;
        block12: {
            Object it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block11: {
                rhs = typeAliasDescriptor.getUnderlyingType();
                ClassifierDescriptor classDescriptor2 = rhs.getConstructor().getDeclarationDescriptor();
                if (!(classDescriptor2 instanceof ClassDescriptor)) {
                    this.trace.report(Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS.on((KtTypeAlias)((PsiElement)declaration)));
                    return;
                }
                List<TypeParameterDescriptor> list2 = ((ClassDescriptor)classDescriptor2).getDeclaredTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"classDescriptor.declaredTypeParameters");
                $this$any$iv = list2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TypeParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(it.getVariance() != Variance.INVARIANT)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
                return;
            }
            $this$any$iv = rhs.getArguments();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl4 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT || it.isStarProjection())) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
        Iterable $this$map$iv = rhs.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
            collection.add(classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null);
        }
        if (!Intrinsics.areEqual((Object)((List)destination$iv$iv), typeAliasDescriptor.getDeclaredTypeParameters())) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TypeParameterDescriptor> getUsedTypeAliasParameters(KotlinType type2, TypeAliasDescriptor typeAlias) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = TypeUtilsKt.constituentTypes(type2);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassifierDescriptor classifierDescriptor;
            TypeParameterDescriptor descriptor2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType it = (KotlinType)element$iv;
            boolean bl2 = false;
            ClassifierDescriptor classifierDescriptor2 = it.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptor typeParameterDescriptor = descriptor2 = classifierDescriptor2 instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor2 : null;
            if (typeParameterDescriptor != null) {
                ClassifierDescriptor it2 = classifierDescriptor2 = typeParameterDescriptor;
                boolean bl3 = false;
                classifierDescriptor = Intrinsics.areEqual((Object)it2.getContainingDeclaration(), (Object)typeAlias) ? classifierDescriptor2 : null;
            } else {
                classifierDescriptor = null;
            }
            if (classifierDescriptor == null) continue;
            ClassifierDescriptor it$iv = classifierDescriptor;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final void checkTypeAliasExpansion(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        TypeAliasDeclarationCheckingReportStrategy reportStrategy = new TypeAliasDeclarationCheckingReportStrategy(this.trace, typeAliasDescriptor, declaration, this.upperBoundChecker);
        new TypeAliasExpander(reportStrategy, true).expandWithoutAbbreviation(typeAliasExpansion, TypeAttributes.Companion.getEmpty());
    }

    private final void checkConstructorDeclaration(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration);
        this.checkExpectedClassConstructor(constructorDescriptor, declaration);
        if (constructorDescriptor.isActual()) {
            this.checkActualFunction(declaration, constructorDescriptor);
        }
    }

    private final void checkExpectedClassConstructor(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        KtConstructorDelegationCall delegationCall;
        if (!constructorDescriptor.isExpect()) {
            return;
        }
        if (declaration.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS) {
            this.trace.report(Errors.EXPECTED_ENUM_CONSTRUCTOR.on((KtConstructor<?>)((PsiElement)declaration)));
        }
        if (declaration instanceof KtPrimaryConstructor && !DescriptorUtils.isAnnotationClass(constructorDescriptor.getConstructedClass())) {
            ClassDescriptor classDescriptor2 = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"constructorDescriptor.constructedClass");
            if (!InlineClassesUtilsKt.isValueClass(classDescriptor2)) {
                for (KtParameter parameter : ((KtPrimaryConstructor)declaration).getValueParameters()) {
                    if (!parameter.hasValOrVar()) continue;
                    this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
            }
        }
        if (declaration instanceof KtSecondaryConstructor && !(delegationCall = ((KtSecondaryConstructor)declaration).getDelegationCall()).isImplicit()) {
            this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL.on((KtConstructorDelegationCall)((PsiElement)delegationCall)));
        }
    }

    private final void checkConstructorVisibility(ClassConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration);
        Object object = visibilityModifier;
        if (object == null || (object = object.getNode()) == null || (object = object.getElementType()) == null) {
            return;
        }
        Object visibilityKeyword = object;
        ClassDescriptor classDescriptor2 = constructorDescriptor.getContainingDeclaration();
        if (classDescriptor2.getKind() == ClassKind.ENUM_CLASS) {
            if (!Intrinsics.areEqual((Object)visibilityKeyword, (Object)KtTokens.PRIVATE_KEYWORD)) {
                this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
            }
        } else if (classDescriptor2.getModality() == Modality.SEALED) {
            boolean protectedIsAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage);
            if (!(Intrinsics.areEqual((Object)visibilityKeyword, (Object)KtTokens.PRIVATE_KEYWORD) || protectedIsAllowed && Intrinsics.areEqual((Object)visibilityKeyword, (Object)KtTokens.PROTECTED_KEYWORD))) {
                DiagnosticFactory0<PsiElement> factory2 = protectedIsAllowed ? Errors.NON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED : Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED;
                this.trace.report(factory2.on(visibilityModifier));
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file2) {
        KtPackageDirective ktPackageDirective = file2.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList modifierList2 = ktModifierList;
        for (KtAnnotationEntry annotationEntry : modifierList2.getAnnotationEntries()) {
            KtSimpleNameExpression it;
            KtConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            boolean bl = false;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(packageDirective, this.trace, null, this.languageVersionSettings);
    }

    private final void checkClass(ClassDescriptorWithResolutionScopes classDescriptor2, KtClassOrObject classOrObject) {
        this.checkSupertypesForConsistency(classDescriptor2, classOrObject);
        this.checkLocalAnnotation(classDescriptor2, classOrObject);
        this.checkTypesInClassHeader(classOrObject);
        KtClassOrObject ktClassOrObject = classOrObject;
        if (ktClassOrObject instanceof KtClass) {
            this.checkClassButNotObject((KtClass)classOrObject, classDescriptor2);
            this.descriptorResolver.checkNamesInConstraints(classOrObject, classDescriptor2, classDescriptor2.getScopeForClassHeaderResolution(), this.trace);
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            this.checkObject((KtObjectDeclaration)classOrObject, classDescriptor2);
        }
        this.checkPrimaryConstructor(classOrObject, classDescriptor2);
        this.checkPrivateExpectedDeclaration(classOrObject, classDescriptor2);
    }

    private final void checkLocalAnnotation(ClassDescriptor classDescriptor2, KtClassOrObject classOrObject) {
        if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS && DescriptorUtils.isLocal(classDescriptor2)) {
            this.trace.report(Errors.LOCAL_ANNOTATION_CLASS.on(this.languageVersionSettings, (KtClassOrObject)((PsiElement)classOrObject)));
        }
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KotlinType it;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) continue;
            if (DeclarationsChecker.checkTypesInClassHeader$type(typeReference2, this) == null) continue;
            boolean bl = false;
            this.upperBoundChecker.checkBoundsInSupertype(typeReference2, it, this.trace, this.languageVersionSettings);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        for (KtTypeParameter typeParameter2 : ((KtClass)classOrObject).getTypeParameters()) {
            if (typeParameter2.getExtendsBound() == null || DeclarationsChecker.checkTypesInClassHeader$type(typeReference, this) == null) continue;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter2.getNameAsName(), typeReference, type2));
        }
        for (KtTypeConstraint constraint2 : ((KtClass)classOrObject).getTypeConstraints()) {
            Object object;
            if (constraint2.getBoundTypeReference() == null || DeclarationsChecker.checkTypesInClassHeader$type(typeReference, this) == null || (object = constraint2.getSubjectTypeParameterName()) == null || (object = object.getReferencedNameAsName()) == null) continue;
            Object name = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests, false);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            KtTypeReference ktTypeReference = request.upperBound;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"request.upperBound");
            KotlinType kotlinType = request.upperBoundType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"request.upperBoundType");
            this.upperBoundChecker.checkBoundsInSupertype(ktTypeReference, kotlinType, this.trace, this.languageVersionSettings);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        TypeConstructor constructor2;
        void $this$partition$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<KotlinType> list2 = descriptor2.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.upperBounds");
        List<KotlinType> upperBounds = list2;
        Iterable iterable = upperBounds;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getConstructor());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            constructor2 = (TypeConstructor)element$iv;
            boolean bl = false;
            if (constructor2.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        boolean bl = false;
        Pair pair2 = TuplesKt.to((Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getFirst())), (Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getSecond())));
        Set boundsWhichAreTypeParameters = (Set)pair2.component1();
        Set otherBounds = (Set)pair2.component2();
        if (boundsWhichAreTypeParameters.size() > 1 || boundsWhichAreTypeParameters.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtModifierListOwnerStub ktModifierListOwnerStub;
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object;
                Object v4;
                block11: {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object constraint2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    List<KtTypeConstraint> list3 = owner.getTypeConstraints();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"owner.typeConstraints");
                    Iterable $i$f$mapTo2 = list3;
                    boolean $i$f$filter = false;
                    constructor2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        constraint2 = (KtTypeConstraint)element$iv$iv;
                        boolean bl2 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = ((KtTypeConstraint)constraint2).getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)declaration.getNameAsName())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    constraint2 = $this$forEach$iv$iv$iv.iterator();
                    while (constraint2.hasNext()) {
                        KtTypeReference it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = constraint2.next();
                        boolean bl3 = false;
                        KtTypeConstraint constraint3 = (KtTypeConstraint)element$iv$iv;
                        boolean bl4 = false;
                        if (constraint3.getBoundTypeReference() == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv2;
                    boolean $i$f$map2 = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void typeReference;
                        constraint2 = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl6 = false;
                        collection.add(TuplesKt.to((Object)typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)));
                    }
                    List allBounds = (List)destination$iv$iv2;
                    Iterable $this$firstOrNull$iv = allBounds;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair bound2 = (Pair)element$iv;
                        boolean bl7 = false;
                        KotlinType kotlinType = (KotlinType)bound2.getSecond();
                        if (!(!Intrinsics.areEqual((Object)(kotlinType != null ? kotlinType.getConstructor() : null), (Object)CollectionsKt.first((Iterable)boundsWhichAreTypeParameters)))) continue;
                        v4 = element$iv;
                        break block11;
                    }
                    v4 = null;
                }
                ktModifierListOwnerStub = (object = (problematicBound = (Pair)v4)) != null && (object = (KtTypeReference)object.getFirst()) != null ? (KtModifierListOwnerStub)object : (KtModifierListOwnerStub)declaration;
            } else {
                ktModifierListOwnerStub = declaration;
            }
            KtModifierListOwnerStub reportOn = ktModifierListOwnerStub;
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            MemberDescriptor memberDescriptor = declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null;
            boolean bl8 = memberDescriptor != null ? InlineOnlyKt.isInlineOnly(memberDescriptor) : false;
            if (bl8) {
                return;
            }
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        Iterable it;
        Collection collection;
        Annotated annotated;
        if (classifier2 instanceof TypeParameterDescriptor) {
            void $this$mapTo$iv$iv;
            List<KotlinType> list2 = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"classifier.upperBounds");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                annotated = (KotlinType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((KotlinType)((Object)it)).getConstructor());
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet((Iterable)immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        Intrinsics.checkNotNullExpressionValue(multimap, (String)"buildDeepSubstitutionMul\u2026p(classifier.defaultType)");
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = multimap;
        Map<TypeParameterDescriptor, Collection<TypeProjection>> map = multiMap.asMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"multiMap.asMap()");
        for (Map.Entry<TypeParameterDescriptor, Collection<TypeProjection>> entry : map.entrySet()) {
            ClassDescriptor containingDeclaration;
            void $this$mapTo$iv$iv;
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            Collection<TypeProjection> projections = entry.getValue();
            if (projections.size() <= 1) continue;
            Intrinsics.checkNotNullExpressionValue(projections, (String)"projections");
            Iterable $this$map$iv = projections;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getType());
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            annotated = typeParameterDescriptor.getContainingDeclaration();
            if ((annotated instanceof ClassDescriptor ? (ClassDescriptor)annotated : null) == null) {
                throw new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration()));
            }
            containingDeclaration = containingDeclaration;
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) continue;
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptorWithResolutionScopes classDescriptor2) {
        this.checkOpenMembers(classDescriptor2);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor2));
        }
    }

    private final void checkClassButNotObject(KtClass aClass, ClassDescriptorWithResolutionScopes classDescriptor2) {
        this.checkOpenMembers(classDescriptor2);
        this.checkTypeParameters(aClass);
        this.checkTypeParameterConstraints(aClass);
        FiniteBoundRestrictionChecker.check(aClass, classDescriptor2, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass, classDescriptor2, this.trace);
        if (aClass.isInterface()) {
            this.checkConstructorInInterface(aClass);
            this.checkMethodsOfAnyInInterface(classDescriptor2);
            if (aClass.isLocal() && !(classDescriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass), classDescriptor2));
            }
        } else if (classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.checkAnnotationClassMembers(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass, classDescriptor2);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor2) {
        PsiElement it;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor primaryConstructor2 = classConstructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor it2;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) == null) continue;
            boolean bl = false;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, it2);
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, parameter, it2, this.languageVersionSettings);
        }
        if (!declaration.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                it = ktModifierList;
                boolean bl = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)it));
            }
        }
        if (declaration.getValueParameterList() == null) {
            PsiElement psiElement = declaration.getConstructorKeyword();
            if (psiElement != null) {
                it = psiElement;
                boolean bl = false;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_BRACKETS.on(it));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        this.checkConstructorDeclaration(primaryConstructor2, declaration);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter ktTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor it;
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ClassTypeParameterAnnotations)) {
                AnnotationResolverImpl.reportUnsupportedAnnotationForTypeParameter(ktTypeParameter, this.trace, this.languageVersionSettings);
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, ktTypeParameter) == null) continue;
            boolean bl = false;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, ktTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> list2 = typeParameterListOwner.getTypeConstraints();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"typeParameterListOwner.typeConstraints");
        List<KtTypeConstraint> constraints = list2;
        if (constraints.isEmpty()) {
            return;
        }
        for (KtTypeParameter typeParameter2 : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            if (typeParameter2.getExtendsBound() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
                if (DeclarationsChecker.Companion.hasConstraints(typeParameter2, constraints)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter2)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter2) == null) continue;
            ClassifierDescriptor classifierDescriptor = typeParameterDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
            this.checkSupertypesForConsistency(classifierDescriptor, typeParameter2);
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor, typeParameter2, typeParameterListOwner);
        }
        for (KtTypeConstraint constraint2 : constraints) {
            List<KtAnnotationEntry> list3 = constraint2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"constraint.annotationEntries");
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                this.trace.report(Errors.ANNOTATION_IN_WHERE_CLAUSE_WARNING.on((KtAnnotationEntry)((PsiElement)it)));
            }
        }
    }

    private final void checkConstructorInInterface(KtClass klass) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
            if (ktPrimaryConstructor == null) break block0;
            KtPrimaryConstructor it = ktPrimaryConstructor;
            boolean bl = false;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor2) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor2.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassMembers(KtClassOrObject classOrObject) {
        for (KtDeclaration declaration : classOrObject.getDeclarations()) {
            if (declaration instanceof KtClassOrObject && this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInAnnotations)) continue;
            this.trace.report(Errors.ANNOTATION_CLASS_MEMBER.on(declaration));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass) {
        for (KtParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                continue;
            }
            if (!parameter.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor2) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor2)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor2.getDeclaredCallableMembers()) {
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) continue;
            Intrinsics.checkNotNullExpressionValue((Object)memberDescriptor, (String)"memberDescriptor");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor);
            KtNamedDeclaration member2 = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
            if (member2 == null || !member2.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (classDescriptor2.getKind() == ClassKind.OBJECT) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member2)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member2)));
        }
    }

    private final void checkBackingField(KtProperty property2) {
        block0: {
            KtBackingField ktBackingField = property2.getFieldDeclaration();
            if (ktBackingField == null) break block0;
            KtBackingField it = ktBackingField;
            boolean bl = false;
            this.trace.report(Errors.EXPLICIT_BACKING_FIELDS_UNSUPPORTED.on((KtElement)((PsiElement)it)));
        }
    }

    private final void checkProperty(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor declarationDescriptor = propertyDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"propertyDescriptor.containingDeclaration");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkMemberProperty(property2, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, property2, propertyDescriptor, this.languageVersionSettings);
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkTypeParameterConstraints(property2);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property2, propertyDescriptor, null, 4, null);
        this.shadowedExtensionChecker.checkDeclaration(property2, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property2, propertyDescriptor);
        this.checkPrivateExpectedDeclaration(property2, propertyDescriptor);
        this.checkBackingField(property2);
    }

    private final void checkPrivateExpectedDeclaration(KtDeclaration declaration, MemberDescriptor descriptor2) {
        if (descriptor2.isExpect() && DescriptorVisibilities.isPrivate(descriptor2.getVisibility())) {
            PsiElement psiElement = declaration.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.PRIVATE_KEYWORD)) == null) {
                psiElement = declaration;
            }
            this.trace.report(Errors.EXPECTED_PRIVATE_DECLARATION.on(psiElement));
        }
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.typeParameters");
        Set allTypeParameters = CollectionsKt.toSet((Iterable)list2);
        HashSet<TypeParameterDescriptor> allAccessibleTypeParameters = new HashSet<TypeParameterDescriptor>();
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        for (ReceiverParameterDescriptor contextReceiverParameter : descriptor2.getContextReceiverParameters()) {
            DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, contextReceiverParameter.getType());
        }
        Set typeParametersInaccessibleFromReceiver = SetsKt.minus((Set)allTypeParameters, (Iterable)allAccessibleTypeParameters);
        for (TypeParameterDescriptor typeParameter2 : typeParametersInaccessibleFromReceiver) {
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameter2);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkMemberProperty(KtProperty property2, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor2) {
        KtModifierList modifierList2 = property2.getModifierList();
        if (modifierList2 != null) {
            if (modifierList2.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor2)) {
                    PsiElement psiElement = property2;
                    String string2 = property2.getName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string2, classDescriptor2));
                    return;
                }
            } else if (classDescriptor2.getKind() == ClassKind.INTERFACE && modifierList2.hasModifier(KtTokens.OPEN_KEYWORD) && propertyDescriptor.getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property2)));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            KtPropertyAccessor setter2;
            KtElement it;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression != null) {
                it = ktExpression;
                boolean bl = false;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)it));
            }
            KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
            if (ktPropertyDelegate != null) {
                it = ktPropertyDelegate;
                boolean bl = false;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)it));
            }
            KtPropertyAccessor getter2 = property2.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
            if ((setter2 = property2.getSetter()) != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        block43: {
            block44: {
                block41: {
                    block46: {
                        block45: {
                            block42: {
                                hasAccessorImplementation = DeclarationsChecker.Companion.hasAccessorImplementation(propertyDescriptor);
                                v0 = propertyDescriptor.getContainingDeclaration();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"propertyDescriptor.containingDeclaration");
                                containingDeclaration = v0;
                                inInterface = DescriptorUtils.isInterface(containingDeclaration);
                                if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                                    if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                                        this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
                                    }
                                    if (inInterface && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                                        this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                                    }
                                    return;
                                }
                                v1 = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                                if (v1 == null) {
                                    v1 = false;
                                }
                                backingFieldRequired = v1;
                                if (inInterface && backingFieldRequired && hasAccessorImplementation) {
                                    this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
                                }
                                initializer = property.getInitializer();
                                delegate = property.getDelegate();
                                isExpect = propertyDescriptor.isExpect();
                                if (initializer == null) break block42;
                                if (inInterface) {
                                    this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer)));
                                } else if (isExpect) {
                                    this.trace.report(Errors.EXPECTED_PROPERTY_INITIALIZER.on((KtExpression)((PsiElement)initializer)));
                                } else if (!backingFieldRequired) {
                                    this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                } else if (property.getReceiverTypeReference() != null) {
                                    this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                } else {
                                    v2 = property.getContextReceivers();
                                    Intrinsics.checkNotNullExpressionValue(v2, (String)"property.contextReceivers");
                                    if (((Collection)v2).isEmpty() == false) {
                                        this.trace.report(Errors.CONTEXT_RECEIVERS_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer)));
                                    }
                                }
                                break block43;
                            }
                            if (delegate == null) break block44;
                            if (!inInterface) break block45;
                            this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate)));
                            break block43;
                        }
                        if (!isExpect) break block46;
                        this.trace.report(Errors.EXPECTED_DELEGATED_PROPERTY.on((KtPropertyDelegate)((PsiElement)delegate)));
                        break block43;
                    }
                    if (property.getReceiverTypeReference() == null) break block43;
                    delegatedPropertyResolvedCall = (ResolvedCall)this.trace.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, propertyDescriptor.getGetter());
                    provideDelegateResolvedCall = (ResolvedCall)this.trace.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
                    v3 = provideDelegateResolvedCall;
                    if (v3 == null || (v3 = (FunctionDescriptor)v3.getResultingDescriptor()) == null || (v3 = v3.getReturnType()) == null) {
                        v4 = delegate.getExpression();
                        if (v4 != null) {
                            it = v4;
                            $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateType$1 = false;
                            v5 = this.trace.getType((KtExpression)it);
                        } else {
                            v5 = v3 = null;
                        }
                        if (v5 == null) {
                            return;
                        }
                    }
                    delegateType = v3;
                    it = FlexibleTypesKt.lowerIfFlexible((KotlinType)delegateType).unwrap().getConstructor().getDeclarationDescriptor();
                    $i$a$-let-DeclarationsChecker$checkPropertyInitializer$delegateClassDescriptor$1 = false;
                    v6 = it instanceof ClassDescriptor != false ? (ClassDescriptor)it : null;
                    var15_20 = v6 != null ? (ClassifierDescriptor)v6 : ((v7 = it instanceof TypeAliasDescriptor != false ? (TypeAliasDescriptor)it : null) != null && (v7 = v7.getExpandedType()) != null && (v7 = v7.getConstructor()) != null ? v7.getDeclarationDescriptor() : null);
                    v8 = var15_20 instanceof ClassDescriptor != false ? (ClassDescriptor)var15_20 : null;
                    if (v8 == null) {
                        return;
                    }
                    delegateClassDescriptor = v8;
                    delegateClassScope$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MemberScope>(delegateClassDescriptor){
                        final /* synthetic */ ClassDescriptor $delegateClassDescriptor;
                        {
                            this.$delegateClassDescriptor = $delegateClassDescriptor;
                            super(0);
                        }

                        @NotNull
                        public final MemberScope invoke() {
                            return this.$delegateClassDescriptor.getUnsubstitutedMemberScope();
                        }
                    }));
                    v9 = delegatedPropertyResolvedCall;
                    dispatchReceiverType = v9 != null && (v9 = v9.getDispatchReceiver()) != null ? v9.getType() : null;
                    v10 = delegatedPropertyResolvedCall;
                    extensionReceiverType = v10 != null && (v10 = v10.getExtensionReceiver()) != null ? v10.getType() : null;
                    v11 = propertyDescriptor.getTypeParameters();
                    Intrinsics.checkNotNullExpressionValue(v11, (String)"propertyDescriptor.typeParameters");
                    it = v11;
                    var20_16 = it.iterator();
                    while (var20_16.hasNext()) {
                        var21_24 = var20_16.next();
                        typeParameter = (TypeParameterDescriptor)var21_24;
                        $i$a$-find-DeclarationsChecker$checkPropertyInitializer$usedParameter$1 = false;
                        v12 = dispatchReceiverType;
                        if (v12 != null ? TypeUtilsKt.contains(v12, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>((TypeParameterDescriptor)typeParameter){
                            final /* synthetic */ TypeParameterDescriptor $typeParameter;
                            {
                                this.$typeParameter = $typeParameter;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull UnwrappedType it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it.getConstructor(), (Object)this.$typeParameter.getTypeConstructor());
                            }
                        })) : false) ** GOTO lbl-1000
                        v13 = extensionReceiverType;
                        v14 = v13 != null ? TypeUtilsKt.contains(v13, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>((TypeParameterDescriptor)typeParameter){
                            final /* synthetic */ TypeParameterDescriptor $typeParameter;
                            {
                                this.$typeParameter = $typeParameter;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull UnwrappedType it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it.getConstructor(), (Object)this.$typeParameter.getTypeConstructor());
                            }
                        })) : false;
                        if (v14) lbl-1000:
                        // 2 sources

                        {
                            v15 = true;
                        } else {
                            v15 = false;
                        }
                        if (!v15) continue;
                        v16 = var21_24;
                        break block41;
                    }
                    v16 = null;
                }
                usedParameter = v16;
                if (usedParameter != null) {
                    propertyWithTypeParameterTypeFound = false;
                    names = DeclarationsChecker.checkPropertyInitializer$lambda$27((Lazy<? extends MemberScope>)delegateClassScope$delegate).getVariableNames();
                    for (Name name : names) {
                        typeParameter = DeclarationsChecker.checkPropertyInitializer$lambda$27((Lazy<? extends MemberScope>)delegateClassScope$delegate).getContributedVariables(name, new KotlinLookupLocation(delegate));
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            propertyInDelegateClass = (PropertyDescriptor)element$iv;
                            $i$a$-forEach-DeclarationsChecker$checkPropertyInitializer$1 = false;
                            v17 = propertyInDelegateClass.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"propertyInDelegateClass.type");
                            if (!TypeUtilsKt.contains(v17, (Function1<? super UnwrappedType, Boolean>)((Function1)checkPropertyInitializer.1.1.INSTANCE))) continue;
                            propertyWithTypeParameterTypeFound = true;
                        }
                    }
                    if (!propertyWithTypeParameterTypeFound) {
                        return;
                    }
                    this.trace.report(Errors.DELEGATE_USES_EXTENSION_PROPERTY_TYPE_PARAMETER.on(this.languageVersionSettings, (KtPropertyDelegate)((PsiElement)delegate), usedParameter.getName().asString()));
                }
                break block43;
            }
            v18 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            if (v18 == null) {
                v18 = false;
            }
            isUninitialized = v18;
            isExternal = DescriptorUtilsKt.isEffectivelyExternal(propertyDescriptor);
            if (backingFieldRequired && !inInterface && !propertyDescriptor.isLateInit() && !isExpect && isUninitialized && !isExternal) {
                if (propertyDescriptor.getExtensionReceiverParameter() != null && !hasAccessorImplementation) {
                    this.trace.report(Errors.EXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                } else if (this.diagnosticSuppressor.shouldReportNoBody(propertyDescriptor)) {
                    if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                        this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property)));
                    } else {
                        this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                    }
                }
            } else if (property.getTypeReference() == null && !this.languageVersionSettings.supportsFeature(LanguageFeature.ShortSyntaxForPropertyGetters)) {
                this.trace.report(Errors.UNSUPPORTED_FEATURE.on(property, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.ShortSyntaxForPropertyGetters, (Object)this.languageVersionSettings)));
            } else if (this.noExplicitTypeOrGetterType(property)) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (propertyDescriptor.isLateInit()) {
                if (propertyDescriptor.isExpect()) {
                    v19 /* !! */  = property.getModifierList();
                    if (v19 /* !! */  == null || (v19 /* !! */  = v19 /* !! */ .getModifier(KtTokens.LATEINIT_KEYWORD)) == null) {
                        v19 /* !! */  = property;
                    }
                    this.trace.report(Errors.EXPECTED_LATEINIT_PROPERTY.on(v19 /* !! */ ));
                }
                if (backingFieldRequired && !inInterface && !isUninitialized && !Intrinsics.areEqual(this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor), (Object)true)) {
                    this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property)));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean noExplicitTypeOrGetterType(KtProperty property2) {
        if (property2.getTypeReference() != null) return false;
        if (property2.getGetter() == null) return true;
        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        if (!ktPropertyAccessor.hasBlockBody()) return false;
        KtPropertyAccessor ktPropertyAccessor2 = property2.getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor2);
        if (ktPropertyAccessor2.getReturnTypeReference() != null) return false;
        return true;
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null && typeParameterList.getTextRange().getStartOffset() > nameIdentifier.getTextRange().getStartOffset()) {
            this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
        }
        this.checkTypeParameterConstraints(function2);
        this.checkImplicitCallableType(function2, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function2, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor declarationDescriptor = functionDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"functionDescriptor.containingDeclaration");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isExpectClass = ((ClassDescriptor)containingDescriptor).isExpect();
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractDeclaration((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
                }
                if (!((ClassDescriptor)containingDescriptor).isExpect() && !hasAbstractModifier && function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface || isExpectClass || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
        } else if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier || functionDescriptor.isExpect() || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        if (functionDescriptor.isExpect()) {
            this.checkExpectedFunction(function2, functionDescriptor);
        }
        if (functionDescriptor.isActual()) {
            this.checkActualFunction(function2, functionDescriptor);
        }
        this.shadowedExtensionChecker.checkDeclaration(function2, functionDescriptor);
    }

    private final void checkExpectedFunction(KtNamedFunction function2, FunctionDescriptor functionDescriptor) {
        if (function2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)function2)));
        }
        this.checkPrivateExpectedDeclaration(function2, functionDescriptor);
    }

    private final void checkActualFunction(KtDeclaration element, FunctionDescriptor functionDescriptor) {
        if (!DescriptorUtilsKt.isAnnotationConstructor(functionDescriptor)) {
            for (ValueParameterDescriptor valueParameter2 : functionDescriptor.getValueParameters()) {
                if (!valueParameter2.declaresDefaultValue()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)valueParameter2, (String)"valueParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameter2);
                if (psiElement == null) {
                    psiElement = element;
                }
                this.trace.report(Errors.ACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS.on(psiElement));
            }
        }
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        block2: {
            PsiElement target;
            KotlinType it;
            block3: {
                KotlinType kotlinType = descriptor2.getReturnType();
                if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) break block2;
                it = kotlinType;
                boolean bl = false;
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = declaration;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"declaration.nameIdentifier ?: declaration");
                target = psiElement;
                if (declaration.getTypeReference() != null) break block3;
                if (TypeUtilsKt.isNothing(it) && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (!TypeUtilsKt.contains(it, (Function1<? super UnwrappedType, Boolean>)((Function1)checkImplicitCallableType.1.1.INSTANCE))) break block2;
                this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                break block2;
            }
            if (!TypeUtilsKt.isNothing(it) || !(it instanceof AbbreviatedType)) break block2;
            this.trace.report((declaration instanceof KtProperty ? Errors.ABBREVIATED_NOTHING_PROPERTY_TYPE : Errors.ABBREVIATED_NOTHING_RETURN_TYPE).on(target));
        }
    }

    private final void checkAccessors(KtProperty property2, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property2.getGetter() : property2.getSetter();
            if (accessor != null) {
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property2, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property2.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property2.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        if (propertyDescriptor.isExpect() && accessor.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)accessor)));
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Object[] objectArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD};
        Map<KtModifierKeywordToken, PsiElement> map = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, SetsKt.setOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue(map, (String)"modifiersChecker.getToke\u2026TERNAL_KEYWORD)\n        )");
        Map<KtModifierKeywordToken, PsiElement> tokens = map;
        if (accessor.isGetter()) {
            if (!Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)propertyDescriptor.getVisibility())) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityUtilsKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && !Intrinsics.areEqual((Object)propertyDescriptor.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = DescriptorVisibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || compare > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"SETTER_VISIBILITY_INCONS\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor enumEntryClass) {
        DeclarationDescriptor declarationDescriptor = enumEntryClass.getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor enumClass2 = (ClassDescriptor)declarationDescriptor;
        if (DescriptorUtils.isEnumClass(enumClass2)) {
            if (enumClass2.isExpect() && enumEntry.getBody() != null) {
                this.trace.report(Errors.EXPECTED_ENUM_ENTRY_WITH_BODY.on((KtEnumEntry)((PsiElement)enumEntry)));
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(enumClass2);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Enum entry should be declared in enum class: " + enumEntryClass;
                throw new AssertionError((Object)string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        void $this$filterTo$iv$iv;
        List<ValueParameterDescriptor> list2 = callableDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"callableDescriptor.valueParameters");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getVarargElementType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (ValueParameterDescriptor parameter : varargParameters) {
                KtParameter parameterDeclaration;
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                PsiElement $i$f$filterTo2 = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
                if (($i$f$filterTo2 instanceof KtParameter ? (KtParameter)$i$f$filterTo2 : null) == null) continue;
                parameterDeclaration = parameterDeclaration;
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)((PsiElement)parameterDeclaration)));
            }
        }
        SimpleType simpleType2 = DescriptorUtilsKt.getBuiltIns(callableDescriptor).getNullableNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"callableDescriptor.builtIns.nullableNothingType");
        SimpleType nullableNothing = simpleType2;
        for (ValueParameterDescriptor parameter : varargParameters) {
            KtParameter parameterDeclaration;
            KotlinType kotlinType = parameter.getVarargElementType();
            Intrinsics.checkNotNull((Object)kotlinType);
            SimpleType varargElementType2 = FlexibleTypesKt.upperIfFlexible(kotlinType);
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(varargElementType2, nullableNothing) && (!InlineClassesUtilsKt.isInlineClassType(varargElementType2) || UnsignedTypes.isUnsignedType(varargElementType2) || KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(varargElementType2))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            if ((psiElement instanceof KtParameter ? (KtParameter)psiElement : null) == null) continue;
            parameterDeclaration = parameterDeclaration;
            trace.report(Errors.FORBIDDEN_VARARG_PARAMETER_TYPE.on((KtParameter)((PsiElement)parameterDeclaration), varargElementType2));
        }
    }

    private static final KotlinType checkTypesInClassHeader$type(KtTypeReference $this$checkTypesInClassHeader_u24type, DeclarationsChecker this$0) {
        return (KotlinType)this$0.trace.getBindingContext().get(BindingContext.TYPE, $this$checkTypesInClassHeader_u24type);
    }

    private static final void checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(Set<? extends TypeParameterDescriptor> allTypeParameters, HashSet<TypeParameterDescriptor> allAccessibleTypeParameters, KotlinType type2) {
        TypeUtils.contains(type2, (Function1<UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set<TypeParameterDescriptor> $allTypeParameters;
            final /* synthetic */ HashSet<TypeParameterDescriptor> $allAccessibleTypeParameters;
            {
                this.$allTypeParameters = $allTypeParameters;
                this.$allAccessibleTypeParameters = $allAccessibleTypeParameters;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(UnwrappedType it) {
                ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor && this.$allTypeParameters.contains(declarationDescriptor) && this.$allAccessibleTypeParameters.add((TypeParameterDescriptor)declarationDescriptor)) {
                    void $this$forEach$iv;
                    List<KotlinType> list2 = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"declarationDescriptor.upperBounds");
                    Iterable iterable = list2;
                    Set<TypeParameterDescriptor> set = this.$allTypeParameters;
                    HashSet<TypeParameterDescriptor> hashSet = this.$allAccessibleTypeParameters;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KotlinType p0 = (KotlinType)element$iv;
                        boolean bl = false;
                        DeclarationsChecker.access$checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(set, hashSet, p0);
                    }
                }
                return false;
            }
        }));
    }

    private static final MemberScope checkPropertyInitializer$lambda$27(Lazy<? extends MemberScope> $delegateClassScope$delegate) {
        Lazy<? extends MemberScope> lazy = $delegateClassScope$delegate;
        return (MemberScope)lazy.getValue();
    }

    public static final /* synthetic */ void access$checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(Set allTypeParameters, HashSet allAccessibleTypeParameters, KotlinType type2) {
        DeclarationsChecker.checkPropertyTypeParametersAreUsedInReceiverType$addAccessibleTypeParametersFromType(allTypeParameters, allAccessibleTypeParameters, type2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$TypeAliasDeclarationCheckingReportStrategy;", "Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "boundsViolationInSubstitution", "", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "unsubstitutedArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "argument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    private static final class TypeAliasDeclarationCheckingReportStrategy
    implements TypeAliasExpansionReportStrategy {
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final UpperBoundChecker upperBoundChecker;
        @NotNull
        private final KtTypeReference typeReference;

        public TypeAliasDeclarationCheckingReportStrategy(@NotNull BindingTrace trace, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull KtTypeAlias declaration, @NotNull UpperBoundChecker upperBoundChecker) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)upperBoundChecker, (String)"upperBoundChecker");
            this.trace = trace;
            this.upperBoundChecker = upperBoundChecker;
            KtTypeReference ktTypeReference = declaration.getTypeReference();
            if (ktTypeReference == null) {
                throw new AssertionError((Object)("Incorrect type alias declaration for " + typeAliasDescriptor));
            }
            this.typeReference = ktTypeReference;
        }

        @NotNull
        public final UpperBoundChecker getUpperBoundChecker() {
            return this.upperBoundChecker;
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter2, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)substitutedArgument, (String)"substitutedArgument");
            this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), substitutedArgument));
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), typeAlias));
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull TypeSubstitutor substitutor2, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument2, @NotNull TypeParameterDescriptor typeParameter2) {
            Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
            Intrinsics.checkNotNullParameter((Object)unsubstitutedArgument, (String)"unsubstitutedArgument");
            Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
            UpperBoundChecker.checkBounds$default(this.upperBoundChecker, null, argument2, typeParameter2, substitutor2, this.trace, this.typeReference, null, 64, null);
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            SourceElement sourceElement = annotation2.getSource();
            KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            KtAnnotationEntry ktAnnotationEntry = ktElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)ktElement : null;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0002J\n\u0010\u001a\u001a\u00020\b*\u00020\u001bR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lcom/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nDeclarationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1747#2,3:1078\n1#3:1081\n*S KotlinDebug\n*F\n+ 1 DeclarationsChecker.kt\norg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion\n*L\n1027#1:1078,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter2, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block4: {
                if (typeParameter2.getName() == null) {
                    return false;
                }
                Iterable $this$any$iv = constraints;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtTypeConstraint it = (KtTypeConstraint)element$iv;
                        boolean bl2 = false;
                        KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)typeParameter2.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member2) {
            if (!METHOD_OF_ANY_NAMES.contains(member2.getName().asString())) {
                return false;
            }
            if (member2.getModality() == Modality.ABSTRACT) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member2, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member2, Set<ClassDescriptor> visitedClasses) {
            for (CallableMemberDescriptor callableMemberDescriptor : member2.getOverriddenDescriptors()) {
                DeclarationDescriptor containingDeclaration;
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor.getContainingDeclaration(), (String)"overridden.containingDeclaration");
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual((Object)DescriptorUtils.getFqName(containingDeclaration), (Object)StandardNames.FqNames.any)) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"overridden");
                if (this.isHidingParentMemberIfPresent(callableMemberDescriptor)) continue;
                visitedClasses.add((ClassDescriptor)containingDeclaration);
                if (!this.isImplementingMethodOfAnyInternal(callableMemberDescriptor, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member2) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member2);
            KtNamedDeclaration ktNamedDeclaration = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList2 = ktModifierList;
            return !modifierList2.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        public final boolean hasAccessorImplementation(@NotNull PropertyDescriptor $this$hasAccessorImplementation) {
            PropertyAccessorDescriptor it;
            Intrinsics.checkNotNullParameter((Object)$this$hasAccessorImplementation, (String)"<this>");
            PropertyGetterDescriptor propertyGetterDescriptor = $this$hasAccessorImplementation.getGetter();
            if (propertyGetterDescriptor != null) {
                it = propertyGetterDescriptor;
                boolean bl = false;
                if (DescriptorPsiUtilsKt.hasBody(it)) {
                    return true;
                }
            }
            PropertySetterDescriptor propertySetterDescriptor = $this$hasAccessorImplementation.getSetter();
            if (propertySetterDescriptor != null) {
                it = propertySetterDescriptor;
                boolean bl = false;
                if (DescriptorPsiUtilsKt.hasBody(it)) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

