/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.nio.dimacs;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.Triple;
import org.jgrapht.nio.BaseEventDrivenImporter;
import org.jgrapht.nio.GraphImporter;
import org.jgrapht.nio.ImportException;
import org.jgrapht.nio.dimacs.DIMACSEventDrivenImporter;

public class DIMACSImporter<V, E>
extends BaseEventDrivenImporter<V, E>
implements GraphImporter<V, E> {
    private final double defaultWeight;

    public DIMACSImporter(double defaultWeight) {
        this.defaultWeight = defaultWeight;
    }

    public DIMACSImporter() {
        this(1.0);
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        DIMACSEventDrivenImporter genericImporter = new DIMACSEventDrivenImporter().renumberVertices(false);
        Consumers consumers = new Consumers(graph);
        genericImporter.addVertexCountConsumer(consumers.nodeCountConsumer);
        genericImporter.addEdgeConsumer(consumers.edgeConsumer);
        genericImporter.importInput(input);
    }

    private class Consumers {
        private Graph<V, E> graph;
        private Integer nodeCount;
        private Map<Integer, V> map;
        public final Consumer<Integer> nodeCountConsumer = n -> {
            this.nodeCount = n;
            for (int i = 0; i < this.nodeCount; ++i) {
                this.map.put(i, this.graph.addVertex());
            }
        };
        public final Consumer<Triple<Integer, Integer, Double>> edgeConsumer = t -> {
            int source = (Integer)t.getFirst();
            Object from = this.map.get(t.getFirst());
            if (from == null) {
                throw new ImportException("Node " + source + " does not exist");
            }
            int target = (Integer)t.getSecond();
            Object to = this.map.get(target);
            if (to == null) {
                throw new ImportException("Node " + target + " does not exist");
            }
            Object e = this.graph.addEdge(from, to);
            if (this.graph.getType().isWeighted()) {
                double weight = t.getThird() == null ? DIMACSImporter.this.defaultWeight : (Double)t.getThird();
                this.graph.setEdgeWeight(e, weight);
            }
        };

        public Consumers(Graph<V, E> graph) {
            this.graph = graph;
            this.nodeCount = null;
            this.map = new HashMap();
        }
    }
}

