/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.prism.ValueMappingPrism;
import org.mapstruct.ap.internal.prism.ValueMappingsPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class ValueMapping {
    private final String source;
    private final String target;
    private final AnnotationMirror mirror;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;

    public static void fromMappingsPrism(ValueMappingsPrism mappingsAnnotation, ExecutableElement method, FormattingMessager messager, List<ValueMapping> mappings) {
        boolean anyFound = false;
        for (ValueMappingPrism mappingPrism : mappingsAnnotation.value()) {
            ValueMapping mapping = ValueMapping.fromMappingPrism(mappingPrism, method, messager);
            if (mapping == null) continue;
            if (!mappings.contains(mapping)) {
                mappings.add(mapping);
            } else {
                messager.printMessage((Element)method, mappingPrism.mirror, mappingPrism.values.target(), Message.VALUEMAPPING_DUPLICATE_SOURCE, mappingPrism.source());
            }
            if (!"<ANY_REMAINING>".equals(mapping.source) && !"<ANY_UNMAPPED>".equals(mapping.source)) continue;
            if (anyFound) {
                messager.printMessage((Element)method, mappingPrism.mirror, mappingPrism.values.target(), Message.VALUEMAPPING_ANY_AREADY_DEFINED, mappingPrism.source());
            }
            anyFound = true;
        }
    }

    public static ValueMapping fromMappingPrism(ValueMappingPrism mappingPrism, ExecutableElement element, FormattingMessager messager) {
        return new ValueMapping(mappingPrism.source(), mappingPrism.target(), mappingPrism.mirror, mappingPrism.values.source(), mappingPrism.values.target());
    }

    private ValueMapping(String source, String target, AnnotationMirror mirror, AnnotationValue sourceAnnotationValue, AnnotationValue targetAnnotationValue) {
        this.source = source;
        this.target = target;
        this.mirror = mirror;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.targetAnnotationValue = targetAnnotationValue;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public ValueMapping reverse() {
        ValueMapping result = !"<ANY_REMAINING>".equals(this.source) || !"<ANY_UNMAPPED>".equals(this.source) ? new ValueMapping(this.target, this.source, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue) : null;
        return result;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.source != null ? this.source.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueMapping other = (ValueMapping)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }
}

