/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.authentication.standard;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.authentication.AuthenticationPlugin;
import org.mariadb.r2dbc.message.AuthMoreData;
import org.mariadb.r2dbc.message.AuthSwitch;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.client.ClearPasswordPacket;
import org.mariadb.r2dbc.message.client.RsaPublicKeyRequestPacket;
import org.mariadb.r2dbc.message.client.Sha256PasswordPacket;

public class Sha256PasswordPluginFlow
implements AuthenticationPlugin {
    public static final String TYPE = "sha256_password";
    private State state = State.INIT;
    private PublicKey publicKey;

    public static PublicKey readPublicKeyFromFile(String serverRsaPublicKeyFile) throws R2dbcException {
        byte[] keyBytes;
        try {
            keyBytes = Files.readAllBytes(Paths.get(serverRsaPublicKeyFile, new String[0]));
        }
        catch (IOException ex) {
            throw new R2dbcNonTransientResourceException("Could not read server RSA public key from file : serverRsaPublicKeyFile=" + serverRsaPublicKeyFile, "S1009", (Throwable)ex);
        }
        return Sha256PasswordPluginFlow.generatePublicKey(keyBytes);
    }

    public static PublicKey generatePublicKey(byte[] publicKeyBytes) throws R2dbcException {
        try {
            String publicKey = new String(publicKeyBytes).replaceAll("(-+BEGIN PUBLIC KEY-+\\r?\\n|\\n?-+END PUBLIC KEY-+\\r?\\n?)", "");
            byte[] keyBytes = Base64.getMimeDecoder().decode(publicKey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        catch (Exception ex) {
            throw new R2dbcNonTransientResourceException("Could read server RSA public key: " + ex.getMessage(), "S1009", (Throwable)ex);
        }
    }

    public static PublicKey readPublicKey(ByteBuf buf) throws R2dbcException {
        byte[] key = new byte[buf.readableBytes()];
        buf.readBytes(key);
        return Sha256PasswordPluginFlow.generatePublicKey(key);
    }

    @Override
    public Sha256PasswordPluginFlow create() {
        return new Sha256PasswordPluginFlow();
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public ClientMessage next(MariadbConnectionConfiguration configuration, AuthSwitch authSwitch, AuthMoreData authMoreData) throws R2dbcException {
        if (this.state == State.INIT) {
            CharSequence password = configuration.getPassword();
            if (password == null || configuration.getSslConfig().getSslMode() != SslMode.DISABLE) {
                return new ClearPasswordPacket(authSwitch.getSequencer(), password);
            }
            if (configuration.getRsaPublicKey() == null || configuration.getRsaPublicKey().isEmpty()) {
                if (!configuration.allowPublicKeyRetrieval()) {
                    throw new R2dbcNonTransientResourceException("RSA public key is not available client side (option serverRsaPublicKeyFile)", "S1009");
                }
                this.state = State.REQUEST_SERVER_KEY;
                return new RsaPublicKeyRequestPacket(authSwitch.getSequencer());
            }
            this.publicKey = Sha256PasswordPluginFlow.readPublicKeyFromFile(configuration.getRsaPublicKey());
            return new Sha256PasswordPacket(authSwitch.getSequencer(), configuration.getPassword(), authSwitch.getSeed(), this.publicKey);
        }
        this.publicKey = Sha256PasswordPluginFlow.readPublicKey(authMoreData.getBuf());
        return new Sha256PasswordPacket(authMoreData.getSequencer(), configuration.getPassword(), authSwitch.getSeed(), this.publicKey);
    }

    public static enum State {
        INIT,
        REQUEST_SERVER_KEY,
        SEND_AUTH;

    }
}

