/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import java.util.Queue;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.client.DecoderState;
import org.mariadb.r2dbc.client.Exchange;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.message.server.PrepareResultPacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.PrepareCache;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import reactor.util.concurrent.Queues;

public class ServerMsgDecoder {
    private final Client client;
    private final MariadbConnectionConfiguration configuration;
    private DecoderState state = null;
    private final Queue<String> prepareSql = (Queue)Queues.small().get();
    private long clientCapabilities;
    private int stateCounter = 0;
    private PrepareResultPacket prepare;
    private ColumnDefinitionPacket[] prepareColumns;
    private Context context = null;

    public ServerMsgDecoder(Client client, MariadbConnectionConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }

    public ServerMessage decode(ByteBuf packet, Exchange exchange) {
        Sequencer sequencer = new Sequencer(packet.readByte());
        if (this.state == null) {
            this.state = exchange == null ? DecoderState.QUERY_RESPONSE : exchange.getInitialState();
        }
        this.state = this.state.decoder(packet.getUnsignedByte(packet.readerIndex()), packet.readableBytes());
        ServerMessage msg = this.state.decode(packet, sequencer, this);
        this.state = msg.ending() ? null : this.state.next(this);
        return msg;
    }

    public Context getContext() {
        return this.context;
    }

    public int getStateCounter() {
        return this.stateCounter;
    }

    public void setStateCounter(int counter) {
        this.stateCounter = counter;
    }

    public PrepareResultPacket getPrepare() {
        return this.prepare;
    }

    public void setPrepare(PrepareResultPacket prepare) {
        this.prepare = prepare;
        this.prepareColumns = prepare == null ? null : new ColumnDefinitionPacket[prepare.getNumColumns()];
    }

    public ColumnDefinitionPacket[] getPrepareColumns() {
        return this.prepareColumns;
    }

    public MariadbConnectionConfiguration getConf() {
        return this.configuration;
    }

    public ServerPrepareResult endPrepare() {
        ServerPrepareResult cached;
        ServerPrepareResult prepareResult = new ServerPrepareResult(this.prepare.getStatementId(), this.prepare.getNumParams(), this.prepareColumns);
        String sql = this.prepareSql.poll();
        PrepareCache prepareCache = this.client.getPrepareCache();
        if (prepareCache != null && (cached = prepareCache.put(sql, prepareResult)) != null) {
            prepareResult.decrementUse(this.client);
            prepareResult = cached;
        }
        return prepareResult;
    }

    public void decrementStateCounter() {
        --this.stateCounter;
    }

    public long getClientCapabilities() {
        return this.clientCapabilities;
    }

    public boolean addPrepare(String sql) {
        return this.prepareSql.offer(sql);
    }

    public void setContext(Context context) {
        this.context = context;
        this.clientCapabilities = this.context.getClientCapabilities();
    }
}

