/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.function.Supplier;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BindValue;
import reactor.core.publisher.Mono;

public interface Codec<T> {
    public boolean canDecode(ColumnDefinitionPacket var1, Class<?> var2);

    public boolean canEncode(Class<?> var1);

    public T decodeText(ByteBuf var1, int var2, ColumnDefinitionPacket var3, Class<? extends T> var4, ExceptionFactory var5);

    public T decodeBinary(ByteBuf var1, int var2, ColumnDefinitionPacket var3, Class<? extends T> var4, ExceptionFactory var5);

    public BindValue encodeText(ByteBufAllocator var1, Object var2, Context var3, ExceptionFactory var4);

    public BindValue encodeBinary(ByteBufAllocator var1, Object var2, ExceptionFactory var3);

    public DataType getBinaryEncodeType();

    default public BindValue createEncodedValue(Supplier<? extends ByteBuf> bufferSupplier) {
        return new BindValue(this, (Mono<? extends ByteBuf>)Mono.fromSupplier(bufferSupplier));
    }

    default public BindValue createEncodedValue(Mono<? extends ByteBuf> value) {
        return new BindValue(this, value);
    }
}

