/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.BufferUtils;

public class BigIntegerCodec
implements Codec<BigInteger> {
    public static BigIntegerCodec INSTANCE = new BigIntegerCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.DECIMAL, DataType.YEAR, DataType.DOUBLE, DataType.DECIMAL, DataType.OLDDECIMAL, DataType.FLOAT, DataType.BIT, DataType.TEXT, DataType.VARSTRING, DataType.STRING});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(BigInteger.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return BigInteger.class.isAssignableFrom(value);
    }

    @Override
    public BigInteger decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends BigInteger> type, ExceptionFactory factory) {
        switch (column.getDataType()) {
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case OLDDECIMAL: {
                String value = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString();
                return new BigDecimal(value).toBigInteger();
            }
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return BigInteger.valueOf(result);
            }
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case YEAR: {
                return new BigInteger(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
            }
        }
        String str2 = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            return new BigDecimal(str2).toBigIntegerExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw factory.createParsingException(String.format("value '%s' cannot be decoded as BigInteger", str2));
        }
    }

    @Override
    public BigInteger decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends BigInteger> type, ExceptionFactory factory) {
        switch (column.getDataType()) {
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return BigInteger.valueOf(result);
            }
            case TINYINT: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedByte());
                }
                return BigInteger.valueOf(buf.readByte());
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedShortLE());
                }
                return BigInteger.valueOf(buf.readShortLE());
            }
            case MEDIUMINT: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedMediumLE());
                }
                return BigInteger.valueOf(buf.readMediumLE());
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return BigInteger.valueOf(buf.readUnsignedIntLE());
                }
                return BigInteger.valueOf(buf.readIntLE());
            }
            case FLOAT: {
                return BigDecimal.valueOf(buf.readFloatLE()).toBigInteger();
            }
            case DOUBLE: {
                return BigDecimal.valueOf(buf.readDoubleLE()).toBigInteger();
            }
            case DECIMAL: {
                return new BigDecimal(buf.readCharSequence(length, StandardCharsets.UTF_8).toString()).toBigInteger();
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return BigInteger.valueOf(buf.readLongLE());
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                return new BigInteger(1, bb);
            }
        }
        String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            return new BigInteger(str);
        }
        catch (NumberFormatException nfe) {
            throw factory.createParsingException(String.format("value '%s' cannot be decoded as BigInteger", str));
        }
    }

    @Override
    public BindValue encodeText(ByteBufAllocator allocator, Object value, Context context, ExceptionFactory factory) {
        return this.createEncodedValue(() -> BufferUtils.encodeAscii(allocator, value.toString()));
    }

    @Override
    public BindValue encodeBinary(ByteBufAllocator allocator, Object value, ExceptionFactory factory) {
        return this.createEncodedValue(() -> BufferUtils.encodeLengthAscii(allocator, value.toString()));
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.DECIMAL;
    }
}

