/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.mariadb.r2dbc.authentication.standard.ed25519.math.GroupElement;
import org.mariadb.r2dbc.authentication.standard.ed25519.math.ed25519.ScalarOps;
import org.mariadb.r2dbc.authentication.standard.ed25519.spec.EdDSANamedCurveSpec;
import org.mariadb.r2dbc.authentication.standard.ed25519.spec.EdDSANamedCurveTable;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;

public final class Ed25519PasswordPacket
implements ClientMessage {
    private final MessageSequence sequencer;
    private final CharSequence password;
    private final byte[] seed;

    public Ed25519PasswordPacket(MessageSequence sequencer, CharSequence password, byte[] seed) {
        this.sequencer = sequencer;
        this.password = password;
        this.seed = seed;
    }

    private static byte[] ed25519SignWithPassword(CharSequence password, byte[] seed) throws R2dbcNonTransientResourceException {
        try {
            byte[] bytePwd = password.toString().getBytes(StandardCharsets.UTF_8);
            MessageDigest hash = MessageDigest.getInstance("SHA-512");
            int mlen = seed.length;
            byte[] sm = new byte[64 + mlen];
            byte[] az = hash.digest(bytePwd);
            az[0] = (byte)(az[0] & 0xF8);
            az[31] = (byte)(az[31] & 0x3F);
            az[31] = (byte)(az[31] | 0x40);
            System.arraycopy(seed, 0, sm, 64, mlen);
            System.arraycopy(az, 32, sm, 32, 32);
            byte[] buff = Arrays.copyOfRange(sm, 32, 96);
            hash.reset();
            byte[] nonce = hash.digest(buff);
            ScalarOps scalar = new ScalarOps();
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName("Ed25519");
            GroupElement elementAvalue = spec.getB().scalarMultiply(az);
            byte[] elementAarray = elementAvalue.toByteArray();
            System.arraycopy(elementAarray, 0, sm, 32, elementAarray.length);
            nonce = scalar.reduce(nonce);
            GroupElement elementRvalue = spec.getB().scalarMultiply(nonce);
            byte[] elementRarray = elementRvalue.toByteArray();
            System.arraycopy(elementRarray, 0, sm, 0, elementRarray.length);
            hash.reset();
            byte[] hram = hash.digest(sm);
            hram = scalar.reduce(hram);
            byte[] tt = scalar.multiplyAndAdd(hram, az, nonce);
            System.arraycopy(tt, 0, sm, 32, tt.length);
            return Arrays.copyOfRange(sm, 0, 64);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-512, failing", e);
        }
    }

    @Override
    public ByteBuf encode(Context context, ByteBufAllocator allocator) {
        if (this.password == null) {
            return allocator.ioBuffer(0);
        }
        ByteBuf buf = allocator.ioBuffer(64);
        buf.writeBytes(Ed25519PasswordPacket.ed25519SignWithPassword(this.password, this.seed));
        return buf;
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }
}

