/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.BindValue;
import reactor.core.publisher.Flux;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class Binding {
    private static final Logger LOGGER = Loggers.getLogger(Binding.class);
    private final int expectedSize;
    private final Map<Integer, BindValue> binds;

    public Binding(int expectedSize) {
        this.expectedSize = expectedSize;
        this.binds = new HashMap<Integer, BindValue>();
    }

    public Binding add(int index, BindValue parameter) {
        Assert.requireNonNull(parameter, "parameter must not be null");
        if (index >= this.expectedSize) {
            throw new IndexOutOfBoundsException(String.format("Binding index %d when only %d parameters are expected", index, this.expectedSize));
        }
        this.binds.put(index, parameter);
        return this;
    }

    public void clear() {
        this.binds.entrySet().forEach(entry -> Flux.from(((BindValue)entry.getValue()).getValue()).doOnNext(ReferenceCountUtil::release).subscribe(ignore -> {}, err -> LOGGER.warn(String.format("Cannot release parameter %s", entry.getValue()), err)));
        this.binds.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding that = (Binding)o;
        return Objects.equals(this.binds, that.binds);
    }

    public int hashCode() {
        return Objects.hash(this.binds);
    }

    public boolean isEmpty() {
        return this.binds.isEmpty();
    }

    public int size() {
        return this.binds.size();
    }

    public String toString() {
        return "Binding{binds=" + this.binds + '}';
    }

    public void validate(int expectedSize) {
        for (int i = 0; i < expectedSize; ++i) {
            if (this.binds.get(i) != null) continue;
            throw new IllegalStateException(String.format("Parameter at position %d is not set", i));
        }
    }

    public List<BindValue> getBindResultParameters(int paramNumber) {
        if (this.binds.isEmpty() && paramNumber == 0) {
            return Collections.emptyList();
        }
        ArrayList<BindValue> result = new ArrayList<BindValue>(paramNumber);
        for (int i = 0; i < paramNumber; ++i) {
            BindValue parameter = this.binds.get(i);
            if (parameter == null) {
                throw new IllegalStateException(String.format("No parameter specified for index %d", i));
            }
            result.add(parameter);
        }
        return result;
    }
}

