/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoConfigurationException;
import com.mongodb.MongoSecurityException;
import com.mongodb.client.MongoClient;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoConnectionProperties;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.utils.NativeLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class MongoDriver
implements Driver,
LoggingAspect$ajcMightHaveAspect {
    protected static final Pattern MONGODB_URI_PATTERN;
    protected static final Pattern AUTH_MECH_TO_AUGMENT_PATTERN;
    protected static final List<String> MECHANISMS_TO_AUGMENT;
    static final String JDBC = "jdbc:";
    static final String MONGODB_URL_PREFIX = "jdbc:mongodb:";
    static final String MONGODB_SRV_URL_PREFIX = "jdbc:mongodb+srv:";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    static final String MONGODB_PRODUCT_NAME = "MongoDB Atlas";
    static final String MONGO_DRIVER_NAME = "MongoDB Atlas SQL interface JDBC Driver";
    static final String NAME;
    static final String VERSION;
    static final int MAJOR_VERSION;
    static final int MINOR_VERSION;
    static final String LEVELS;
    static final String RELAXED = "RELAXED";
    static final String EXTENDED = "EXTENDED";
    public static final String LOG_TO_CONSOLE = "console";
    protected static final String CONNECTION_ERROR_SQLSTATE = "08000";
    public static final String AUTHENTICATION_ERROR_SQLSTATE = "28000";
    private static ConcurrentHashMap<Integer, WeakReference<MongoClient>> mongoClientCache;
    private static final ReadWriteLock mongoClientCacheLock;
    private static boolean mongoSqlTranslateLibraryLoaded;
    private static Exception mongoSqlTranslateLibraryLoadingError;
    private static String mongoSqlTranslateLibraryPath;
    private static final String MONGOSQL_TRANSLATE_NAME = "mongosqltranslate";
    public static final String MONGOSQL_TRANSLATE_PATH = "MONGOSQL_TRANSLATE_PATH";
    protected static final CodecRegistry REGISTRY;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoDriver.ajc$preClinit();
        MONGODB_URI_PATTERN = Pattern.compile("(mongodb(?:\\+srv)?://)(?<uidpwd>(?:\\S+:)?\\S+@)?([^\\r\\n\\t\\f\\v ?]+(\\?(?<options>.*))?)");
        AUTH_MECH_TO_AUGMENT_PATTERN = Pattern.compile("authMechanism=(?<authMech>(" + AuthenticationMechanism.PLAIN.getMechanismName() + "|" + AuthenticationMechanism.SCRAM_SHA_1.getMechanismName() + "|" + AuthenticationMechanism.SCRAM_SHA_256.getMechanismName() + "|" + AuthenticationMechanism.GSSAPI.getMechanismName() + "))");
        MECHANISMS_TO_AUGMENT = Arrays.asList(AuthenticationMechanism.PLAIN.getMechanismName(), AuthenticationMechanism.SCRAM_SHA_1.getMechanismName(), AuthenticationMechanism.SCRAM_SHA_256.getMechanismName(), AuthenticationMechanism.GSSAPI.getMechanismName());
        LEVELS = Arrays.toString(new String[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.FINER.getName(), Level.INFO.getName(), Level.FINE.getName(), Level.WARNING.getName()});
        mongoClientCache = new ConcurrentHashMap();
        mongoClientCacheLock = new ReentrantReadWriteLock();
        mongoSqlTranslateLibraryLoaded = false;
        mongoSqlTranslateLibraryLoadingError = null;
        mongoSqlTranslateLibraryPath = null;
        REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider(), new ValueCodecProvider(), MongoClientSettings.getDefaultCodecRegistry(), PojoCodecProvider.builder().automatic(true).build()});
        MongoDriver unit = new MongoDriver();
        try {
            DriverManager.registerDriver(unit);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String version = unit.getClass().getPackage().getImplementationVersion();
        VERSION = version == null ? MongoDriver.getAbbreviatedGitVersion() : version;
        String[] verSp = VERSION.split("[.]");
        if (verSp.length < 2) {
            throw new RuntimeException(new SQLException("version was not specified correctly, must contain at least major and minor parts"));
        }
        MAJOR_VERSION = Integer.parseInt(verSp[0]);
        MINOR_VERSION = Integer.parseInt(verSp[1]);
        String name = unit.getClass().getPackage().getImplementationTitle();
        NAME = name != null ? name : "mongodb-jdbc";
        Runtime.getRuntime().addShutdownHook(new Thread(MongoDriver::closeAllClients));
        try {
            MongoDriver.loadMongoSqlTranslateLibrary();
        }
        catch (Exception e) {
            mongoSqlTranslateLibraryLoadingError = e;
        }
        catch (Error e) {
            mongoSqlTranslateLibraryLoadingError = new Exception(e);
        }
    }

    public MongoDriver() {
        LoggingAspect.ajc$perObjectBind(this);
    }

    public static String getVersion() {
        return VERSION != null ? VERSION : String.valueOf(MAJOR_VERSION) + "." + MINOR_VERSION;
    }

    static String getAbbreviatedGitVersion() {
        Process p = null;
        try {
            String string;
            block17: {
                String command = "git describe --abbrev=0";
                p = Runtime.getRuntime().exec(command);
                Throwable throwable = null;
                Object var3_4 = null;
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    StringBuilder version_sb = new StringBuilder();
                    while ((line = input.readLine()) != null) {
                        version_sb.append(line);
                    }
                    string = version_sb.append("-SNAPSHOT").substring(1).trim();
                    if (input == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (input != null) {
                                input.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(new SQLException("Internal error retrieving driver version"));
                    }
                }
                input.close();
            }
            return string;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    static int getClientCacheSizeForTest() {
        mongoClientCacheLock.readLock().lock();
        try {
            int n = mongoClientCache.size();
            return n;
        }
        finally {
            mongoClientCacheLock.readLock().unlock();
        }
    }

    static void clearClientCacheForTest() {
        mongoClientCacheLock.readLock().lock();
        try {
            mongoClientCache.clear();
        }
        finally {
            mongoClientCacheLock.readLock().unlock();
        }
    }

    private static void loadMongoSqlTranslateLibrary() throws IOException {
        String envPath = System.getenv(MONGOSQL_TRANSLATE_PATH);
        if (envPath != null && !envPath.isEmpty()) {
            String absolutePath = Paths.get(envPath, new String[0]).toAbsolutePath().normalize().toString();
            try {
                System.load(absolutePath);
                mongoSqlTranslateLibraryPath = absolutePath;
                mongoSqlTranslateLibraryLoaded = true;
                return;
            }
            catch (Error e) {
                mongoSqlTranslateLibraryLoadingError = new Exception(e);
            }
        }
        mongoSqlTranslateLibraryPath = NativeLoader.loadLibraryFromJar(MONGOSQL_TRANSLATE_NAME);
        mongoSqlTranslateLibraryLoaded = true;
    }

    public static CodecRegistry getCodecRegistry() {
        return REGISTRY;
    }

    private Properties canonicalizeProperties(Properties info) throws SQLException {
        try {
            Properties lowerCaseprops = new Properties();
            if (info != null) {
                try {
                    Enumeration<?> keys = info.propertyNames();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = info.getProperty(key);
                        if (value == null) {
                            throw new SQLException("Properties Object must contain String values only.");
                        }
                        key = key.toLowerCase();
                        value = value.trim();
                        lowerCaseprops.setProperty(key, value);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new SQLException("Properties Object must contain String keys only.");
                }
            }
            return lowerCaseprops;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            if (!this.acceptsURL(url)) {
                return null;
            }
            lowerCaseprops = this.canonicalizeProperties(info);
            try {
                conn = this.getUnvalidatedConnection(url, lowerCaseprops);
                if (conn != null) {
                    conn.testConnection(conn.getDefaultConnectionValidationTimeoutSeconds());
                    return conn;
                }
                throw new SQLException("Connection setup failed but no errors where reported.");
            }
            catch (TimeoutException v0) {
                throw new SQLTimeoutException("Couldn't connect due to a timeout. Please check your hostname and port. If necessary, set a longer connection timeout in the MongoDB URI.");
            }
            catch (Exception e) {
                cause /* !! */  = e;
                ** while (cause /* !! */  != null)
            }
lbl-1000:
            // 1 sources

            {
                if (cause /* !! */  instanceof MongoSecurityException) {
                    throw new SQLException("Authentication failed. Verify that the credentials are correct.", "28000", e);
                }
                cause /* !! */  = cause /* !! */ .getCause();
                continue;
            }
lbl20:
            // 1 sources

            throw new SQLException("Connection failed.", e);
        }
        catch (Exception var6_7) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(var6_7, MongoDriver.ajc$tjp_1);
            }
            throw var6_7;
        }
    }

    protected MongoConnection getUnvalidatedConnection(String url, Properties info) throws SQLException {
        try {
            if (!this.acceptsURL(url)) {
                return null;
            }
            if (info == null) {
                info = new Properties();
            }
            MongoConnectionConfig connectionConfig = MongoDriver.getConnectionSettings(url, info);
            if (connectionConfig.driverInfo.length != 0) {
                throw new SQLException(this.reportMissingProperties(connectionConfig.driverInfo), CONNECTION_ERROR_SQLSTATE);
            }
            try {
                return this.createConnection(connectionConfig.connectionString, info, connectionConfig.tlsCaFile, connectionConfig.x509Passphrase);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    private String reportMissingProperties(DriverPropertyInfo[] missingRequiredProperties) {
        try {
            ArrayList<String> propertyNames = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("There are issues with your connection settings : ");
            DriverPropertyInfo[] driverPropertyInfoArray = missingRequiredProperties;
            int n = missingRequiredProperties.length;
            int n2 = 0;
            while (n2 < n) {
                DriverPropertyInfo info = driverPropertyInfoArray[n2];
                if (info.name.equals(USER)) {
                    sb.append("Password specified without user. Please provide '");
                    sb.append(USER);
                    sb.append("' property value.\n");
                } else if (info.name.equals(PASSWORD)) {
                    sb.append("User specified without password. Please provide '");
                    sb.append(PASSWORD);
                    sb.append("' property value.\n");
                } else if (info.name.equals(MongoJDBCProperty.DATABASE.getPropertyName())) {
                    sb.append("Mandatory property '");
                    sb.append(MongoJDBCProperty.DATABASE.getPropertyName());
                    sb.append("' is missing.\n");
                } else {
                    propertyNames.add(info.name);
                }
                ++n2;
            }
            if (!propertyNames.isEmpty()) {
                sb.append("Unexpected driver property info : ");
                sb.append(String.join((CharSequence)", ", propertyNames));
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    private MongoConnection createConnection(ConnectionString cs, Properties info, String tlsCaFile, char[] x509Passphrase) throws Exception {
        try {
            MongoClient client;
            WeakReference<MongoClient> clientRef;
            File logDir;
            Level logLevel;
            String database = info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName());
            String logLevelVal = info.getProperty(MongoJDBCProperty.LOG_LEVEL.getPropertyName(), Level.OFF.getName());
            try {
                logLevel = Level.parse(logLevelVal.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SQLException("Invalid " + MongoJDBCProperty.LOG_LEVEL.getPropertyName() + " property value : " + logLevelVal + ". Valid values are : " + LEVELS + ".");
            }
            String logDirVal = info.getProperty(MongoJDBCProperty.LOG_DIR.getPropertyName());
            if (logDirVal != null && LOG_TO_CONSOLE.equalsIgnoreCase(logDirVal.trim())) {
                logDirVal = null;
            }
            File file = logDir = logDirVal == null ? null : new File(logDirVal);
            if (logDir != null && !logDir.isDirectory()) {
                throw new SQLException("Invalid " + MongoJDBCProperty.LOG_DIR.getPropertyName() + " property value : " + logDirVal + ". It must be a directory.");
            }
            String clientInfo = info.getProperty(MongoJDBCProperty.CLIENT_INFO.getPropertyName());
            if (clientInfo != null && clientInfo.split("\\+").length != 2) {
                throw new SQLException("Invalid " + MongoJDBCProperty.CLIENT_INFO.getPropertyName() + " property value : " + clientInfo + ". Expected format <name>+<version>.");
            }
            String extJsonModeVal = info.getProperty(MongoJDBCProperty.EXT_JSON_MODE.getPropertyName());
            boolean extJsonMode = false;
            if (extJsonModeVal != null) {
                if ((extJsonModeVal = extJsonModeVal.toUpperCase().trim()) == EXTENDED) {
                    extJsonMode = true;
                } else if (extJsonModeVal != RELAXED) {
                    throw new SQLException("Invalid JSON mode: " + extJsonModeVal);
                }
            }
            MongoConnectionProperties mongoConnectionProperties = new MongoConnectionProperties(cs, database, logLevel, logDir, clientInfo, extJsonMode, tlsCaFile, info.getProperty(MongoJDBCProperty.X509_PEM_PATH.getPropertyName()));
            String disableCacheVal = info.getProperty(MongoJDBCProperty.DISABLE_CLIENT_CACHE.getPropertyName(), "false").toLowerCase();
            if (disableCacheVal.equals("true") || disableCacheVal.equals("yes") || disableCacheVal.equals("1")) {
                return new MongoConnection(mongoConnectionProperties, x509Passphrase);
            }
            Integer key = mongoConnectionProperties.generateKey();
            mongoClientCacheLock.readLock().lock();
            try {
                clientRef = mongoClientCache.get(key);
                MongoClient mongoClient = client = clientRef != null ? (MongoClient)clientRef.get() : null;
                if (client != null) {
                    MongoConnection mongoConnection = new MongoConnection(client, mongoConnectionProperties, x509Passphrase);
                    return mongoConnection;
                }
            }
            finally {
                mongoClientCacheLock.readLock().unlock();
            }
            mongoClientCacheLock.writeLock().lock();
            try {
                clientRef = mongoClientCache.get(key);
                MongoClient mongoClient = client = clientRef != null ? (MongoClient)clientRef.get() : null;
                if (client != null) {
                    MongoConnection mongoConnection = new MongoConnection(client, mongoConnectionProperties, x509Passphrase);
                    return mongoConnection;
                }
                MongoConnection newConnection = new MongoConnection(mongoConnectionProperties, x509Passphrase);
                mongoClientCache.put(key, new WeakReference<MongoClient>(newConnection.getMongoClient()));
                MongoConnection mongoConnection = newConnection;
                return mongoConnection;
            }
            finally {
                mongoClientCacheLock.writeLock().unlock();
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public static void closeAllClients() {
        mongoClientCacheLock.writeLock().lock();
        try {
            for (WeakReference<MongoClient> clientRef : mongoClientCache.values()) {
                MongoClient client = (MongoClient)clientRef.get();
                if (client == null) continue;
                client.close();
            }
            mongoClientCache.clear();
        }
        finally {
            mongoClientCacheLock.writeLock().unlock();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        try {
            return url.startsWith(MONGODB_URL_PREFIX) || url.startsWith(MONGODB_SRV_URL_PREFIX);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        try {
            MongoConnectionConfig connectionConfig = MongoDriver.getConnectionSettings(url, info);
            return connectionConfig.driverInfo;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public int getMajorVersion() {
        try {
            return 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            throw new SQLFeatureNotSupportedException();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    public static boolean isMongoSqlTranslateLibraryLoaded() {
        return mongoSqlTranslateLibraryLoaded;
    }

    public static String getMongoSqlTranslateLibraryPath() {
        return mongoSqlTranslateLibraryPath;
    }

    public static Exception getMongoSqlTranslateLibraryLoadError() {
        return mongoSqlTranslateLibraryLoadingError;
    }

    private static String removePrefix(String prefix, String s) {
        if (s != null && prefix != null && s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static MongoConnectionConfig getConnectionSettings(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        try {
            ConnectionString originalConnectionString;
            String actualURL = MongoDriver.removePrefix(JDBC, url);
            try {
                originalConnectionString = new ConnectionString(actualURL);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            ParseResult result = MongoDriver.normalizeConnectionOptions(originalConnectionString, info);
            String user = null;
            char[] password = null;
            char[] x509Passphrase = null;
            if (result.authMechanism != null && result.authMechanism.equals((Object)AuthenticationMechanism.MONGODB_X509)) {
                x509Passphrase = result.password;
            } else {
                user = result.user;
                password = result.password;
            }
            ArrayList<DriverPropertyInfo> mandatoryConnectionProperties = new ArrayList<DriverPropertyInfo>();
            if ((!info.containsKey(MongoJDBCProperty.DATABASE.getPropertyName()) || info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName()).isEmpty()) && originalConnectionString.getDatabase() != null) {
                info.setProperty(MongoJDBCProperty.DATABASE.getPropertyName(), originalConnectionString.getDatabase());
            }
            if (!info.containsKey(MongoJDBCProperty.DATABASE.getPropertyName()) || info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName()).isEmpty()) {
                mandatoryConnectionProperties.add(new DriverPropertyInfo(MongoJDBCProperty.DATABASE.getPropertyName(), null));
            }
            String authDatabase = info.getProperty(MongoJDBCProperty.DATABASE.getPropertyName());
            if (user == null && password != null) {
                mandatoryConnectionProperties.add(new DriverPropertyInfo(USER, null));
            }
            if (password == null && user != null && (result.authMechanism == null || !result.authMechanism.equals((Object)AuthenticationMechanism.MONGODB_X509) && !result.authMechanism.equals((Object)AuthenticationMechanism.MONGODB_OIDC))) {
                mandatoryConnectionProperties.add(new DriverPropertyInfo(PASSWORD, null));
            }
            if (mandatoryConnectionProperties.size() > 0) {
                return new MongoConnectionConfig(null, mandatoryConnectionProperties.toArray(new DriverPropertyInfo[mandatoryConnectionProperties.size()]), null, null);
            }
            ConnectionString c = new ConnectionString(MongoDriver.buildNewURI(originalConnectionString.isSrvProtocol(), originalConnectionString.getHosts(), user, password, authDatabase, result.normalizedOptions));
            return new MongoConnectionConfig(c, new DriverPropertyInfo[0], result.normalizedOptions.getProperty(MongoJDBCProperty.TLS_CA_FILE.getPropertyName()), x509Passphrase);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw e;
            }
            throw new SQLException(e);
        }
    }

    protected static ConnectionString buildConnectionString(String url, Properties info) throws IllegalArgumentException, MongoConfigurationException {
        String actualURL = MongoDriver.removePrefix(JDBC, url);
        try {
            return new ConnectionString(actualURL);
        }
        catch (IllegalArgumentException ea) {
            Matcher uri_matcher = MONGODB_URI_PATTERN.matcher(actualURL);
            if (uri_matcher.find()) {
                String authMech;
                Matcher authMec_matcher;
                String username = info.getProperty(USER) != null ? URLEncoder.encode(info.getProperty(USER)) : null;
                String password = info.getProperty(PASSWORD) != null ? URLEncoder.encode(info.getProperty(PASSWORD)) : null;
                String options = uri_matcher.group("options");
                if (uri_matcher.group("uidpwd") == null && username != null && options != null && (authMec_matcher = AUTH_MECH_TO_AUGMENT_PATTERN.matcher(options)).find() && MECHANISMS_TO_AUGMENT.contains((authMech = authMec_matcher.group("authMech")).toUpperCase())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(uri_matcher.group(1));
                    sb.append(username);
                    if (password != null) {
                        sb.append(":");
                        sb.append(password);
                    }
                    sb.append("@");
                    sb.append(uri_matcher.group(3));
                    return new ConnectionString(sb.toString());
                }
                throw ea;
            }
            throw ea;
        }
    }

    private static ParseResult normalizeConnectionOptions(ConnectionString clientURI, Properties info) throws SQLException {
        char[] propertyPWD;
        String user = null;
        char[] password = null;
        if (info == null) {
            info = new Properties();
        }
        NullCoalesce<String> s = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        NullCoalesce<char[]> c = (left, right) -> {
            if (left == null) {
                return right;
            }
            return left;
        };
        AuthenticationMechanism authMechanism = clientURI.getCredential() != null ? clientURI.getCredential().getAuthenticationMechanism() : null;
        String uriUser = clientURI.getUsername();
        char[] uriPWD = clientURI.getPassword();
        String propertyUser = info.getProperty(USER);
        String propertyPWDStr = info.getProperty(PASSWORD);
        char[] cArray = propertyPWD = propertyPWDStr != null ? propertyPWDStr.toCharArray() : null;
        if (authMechanism != null && authMechanism.equals((Object)AuthenticationMechanism.MONGODB_OIDC)) {
            if (uriPWD != null || propertyPWD != null) {
                throw new SQLException("Password should not be specified when using MONGODB-OIDC authentication");
            }
            user = s.coalesce(uriUser, propertyUser);
        } else {
            if (uriUser != null && propertyUser != null && !uriUser.equals(propertyUser)) {
                throw new SQLException("uri and properties disagree on user: '" + uriUser + ", and " + propertyUser + " respectively");
            }
            user = s.coalesce(uriUser, propertyUser);
            if (user != null) {
                info.setProperty(USER, user);
            }
            if (uriPWD != null && propertyPWD != null && !Arrays.equals(uriPWD, propertyPWD)) {
                throw new SQLException("uri and properties disagree on password");
            }
            password = c.coalesce(uriPWD, propertyPWD);
        }
        String optionString = null;
        String[] optionSplit = clientURI.getConnectionString().split("[?]");
        if (optionSplit.length > 1) {
            optionString = optionSplit[1];
        }
        Properties options = new Properties();
        if (optionString != null) {
            String[] optionStrs;
            String[] stringArray = optionStrs = optionString.split("&");
            int n = optionStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String optionStr = stringArray[n2];
                String[] kv = optionStr.split("=");
                if (kv.length != 2) {
                    throw new SQLException("Option String is not valid");
                }
                String normalizedKey = kv[0].toLowerCase();
                if (!normalizedKey.equals(USER) && !normalizedKey.equals(PASSWORD)) {
                    options.put(normalizedKey, kv[1]);
                }
                ++n2;
            }
        }
        for (String key : info.stringPropertyNames()) {
            String normalizedKey = key.toLowerCase();
            if (normalizedKey.equals(USER) || normalizedKey.equals(PASSWORD)) continue;
            String val = info.getProperty(key);
            if (options.containsKey(normalizedKey)) {
                if (options.getProperty(normalizedKey).equals(val)) continue;
                throw new SQLException("uri and properties disagree on " + key);
            }
            options.setProperty(normalizedKey, val);
        }
        return new ParseResult(user, password, authMechanism, options);
    }

    private static String sqlURLEncode(String item) throws SQLException {
        try {
            return URLEncoder.encode(item, "utf-8");
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static boolean isMongoJDBCProperty(String key) {
        return Stream.of(MongoJDBCProperty.values()).anyMatch(v -> v.getPropertyName().equalsIgnoreCase(key));
    }

    private static String buildNewURI(boolean isSrvProtocol, List<String> hosts, String user, char[] password, String authDatabase, Properties options) throws SQLException {
        String ret;
        String string = ret = isSrvProtocol ? "mongodb+srv://" : "mongodb://";
        if (user != null) {
            ret = String.valueOf(ret) + MongoDriver.sqlURLEncode(user);
            if (password != null) {
                ret = String.valueOf(ret) + ":" + MongoDriver.sqlURLEncode(String.valueOf(password));
            }
            ret = String.valueOf(ret) + "@";
        }
        ret = String.valueOf(ret) + String.join((CharSequence)",", hosts);
        ret = authDatabase != null ? String.valueOf(ret) + "/" + MongoDriver.sqlURLEncode(authDatabase) : String.valueOf(ret) + "/";
        StringBuilder buff = new StringBuilder();
        if (options != null) {
            for (String key : options.stringPropertyNames()) {
                if (key.equals(USER) || key.equals(PASSWORD) || MongoDriver.isMongoJDBCProperty(key)) continue;
                if (buff.length() > 0) {
                    buff.append("&");
                }
                try {
                    buff.append(key).append("=").append(URLEncoder.encode(options.getProperty(key), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(e);
                }
            }
        }
        if (buff.length() > 0) {
            ret = String.valueOf(ret) + "?" + buff;
        }
        return ret;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoDriver.java", MongoDriver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "canonicalizeProperties", "com.mongodb.jdbc.MongoDriver", "java.util.Properties", "info", "java.sql.SQLException", "java.util.Properties"), 282);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "java.sql.Connection"), 309);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentLogger", "com.mongodb.jdbc.MongoDriver", "", "", "java.sql.SQLFeatureNotSupportedException", "java.util.logging.Logger"), 582);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getUnvalidatedConnection", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "com.mongodb.jdbc.MongoConnection"), 361);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "reportMissingProperties", "com.mongodb.jdbc.MongoDriver", "[Ljava.sql.DriverPropertyInfo;", "missingRequiredProperties", "", "java.lang.String"), 399);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createConnection", "com.mongodb.jdbc.MongoDriver", "com.mongodb.ConnectionString:java.util.Properties:java.lang.String:[C", "cs:info:tlsCaFile:x509Passphrase", "java.lang.Exception", "com.mongodb.jdbc.MongoConnection"), 429);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "acceptsURL", "com.mongodb.jdbc.MongoDriver", "java.lang.String", "url", "java.sql.SQLException", "boolean"), 554);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyInfo", "com.mongodb.jdbc.MongoDriver", "java.lang.String:java.util.Properties", "url:info", "java.sql.SQLException", "[Ljava.sql.DriverPropertyInfo;"), 559);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMajorVersion", "com.mongodb.jdbc.MongoDriver", "", "", "", "int"), 565);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinorVersion", "com.mongodb.jdbc.MongoDriver", "", "", "", "int"), 570);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "jdbcCompliant", "com.mongodb.jdbc.MongoDriver", "", "", "", "boolean"), 575);
    }

    public static class MongoConnectionConfig {
        public final ConnectionString connectionString;
        public final DriverPropertyInfo[] driverInfo;
        public final String tlsCaFile;
        public final char[] x509Passphrase;

        MongoConnectionConfig(ConnectionString cs, DriverPropertyInfo[] di, String tcf, char[] x509pass) {
            this.connectionString = cs;
            this.driverInfo = di;
            this.tlsCaFile = tcf;
            this.x509Passphrase = x509pass;
        }
    }

    public static final class MongoJDBCProperty
    extends Enum<MongoJDBCProperty> {
        public static final /* enum */ MongoJDBCProperty CLIENT_INFO;
        public static final /* enum */ MongoJDBCProperty DATABASE;
        public static final /* enum */ MongoJDBCProperty DISABLE_CLIENT_CACHE;
        public static final /* enum */ MongoJDBCProperty EXT_JSON_MODE;
        public static final /* enum */ MongoJDBCProperty LOG_DIR;
        public static final /* enum */ MongoJDBCProperty LOG_LEVEL;
        public static final /* enum */ MongoJDBCProperty TLS_CA_FILE;
        public static final /* enum */ MongoJDBCProperty X509_PEM_PATH;
        private final String propertyName;
        private static final /* synthetic */ MongoJDBCProperty[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        static {
            MongoJDBCProperty.ajc$preClinit();
            CLIENT_INFO = new MongoJDBCProperty("clientinfo");
            DATABASE = new MongoJDBCProperty("database");
            DISABLE_CLIENT_CACHE = new MongoJDBCProperty("disableclientcache");
            EXT_JSON_MODE = new MongoJDBCProperty("extjsonmode");
            LOG_DIR = new MongoJDBCProperty("logdir");
            LOG_LEVEL = new MongoJDBCProperty("loglevel");
            TLS_CA_FILE = new MongoJDBCProperty("tlscafile");
            X509_PEM_PATH = new MongoJDBCProperty("x509pempath");
            ENUM$VALUES = new MongoJDBCProperty[]{CLIENT_INFO, DATABASE, DISABLE_CLIENT_CACHE, EXT_JSON_MODE, LOG_DIR, LOG_LEVEL, TLS_CA_FILE, X509_PEM_PATH};
        }

        private MongoJDBCProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            try {
                return this.propertyName;
            }
            catch (Exception exception) {
                if (LoggingAspect.hasAspect((Object)this)) {
                    LoggingAspect.aspectOf((Object)this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
                }
                throw exception;
            }
        }

        public static MongoJDBCProperty[] values() {
            MongoJDBCProperty[] mongoJDBCPropertyArray = ENUM$VALUES;
            int n = mongoJDBCPropertyArray.length;
            MongoJDBCProperty[] mongoJDBCPropertyArray2 = new MongoJDBCProperty[n];
            System.arraycopy(ENUM$VALUES, 0, mongoJDBCPropertyArray2, 0, n);
            return mongoJDBCPropertyArray2;
        }

        public static MongoJDBCProperty valueOf(String arg0) {
            return Enum.valueOf(MongoJDBCProperty.class, arg0);
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("MongoDriver.java", MongoJDBCProperty.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPropertyName", "com.mongodb.jdbc.MongoDriver$MongoJDBCProperty", "", "", "", "java.lang.String"), 112);
        }
    }

    private static interface NullCoalesce<T> {
        public T coalesce(T var1, T var2);
    }

    private static class ParseResult {
        String user;
        char[] password;
        AuthenticationMechanism authMechanism;
        Properties normalizedOptions;

        ParseResult(String u, char[] p, AuthenticationMechanism a, Properties options) {
            this.user = u;
            this.password = p;
            this.authMechanism = a;
            this.normalizedOptions = options;
        }
    }
}

