/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.JsonSchema;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.utils.BsonUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.codecs.pojo.annotations.BsonIgnore;

public class MongoJsonSchema
implements LoggingAspect$ajcMightHaveAspect {
    private static final Codec<MongoJsonSchema> CODEC;
    public String bsonType;
    public Map<String, MongoJsonSchema> properties;
    public Set<MongoJsonSchema> anyOf;
    public Set<String> required;
    public MongoJsonSchema items;
    public boolean additionalProperties;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoJsonSchema.ajc$preClinit();
        CODEC = MongoDriver.getCodecRegistry().get(MongoJsonSchema.class);
    }

    public MongoJsonSchema() {
        LoggingAspect.ajc$perObjectBind(this);
    }

    public static MongoJsonSchema toSimplifiedMongoJsonSchema(JsonSchema baseSchema) {
        MongoJsonSchema unsimplifiedSchema = MongoJsonSchema.toMongoJsonSchema(baseSchema);
        return MongoJsonSchema.flattenNestedAnyOfs(unsimplifiedSchema);
    }

    private static MongoJsonSchema toMongoJsonSchema(JsonSchema baseSchema) {
        if (baseSchema == null) {
            return null;
        }
        MongoJsonSchema result = new MongoJsonSchema();
        result.properties = MongoJsonSchema.toMongoJsonSchemaProperties(baseSchema.properties);
        if (baseSchema.anyOf != null) {
            result.anyOf = new HashSet<MongoJsonSchema>();
            for (JsonSchema baseAnyOf : baseSchema.anyOf) {
                result.anyOf.add(MongoJsonSchema.toSimplifiedMongoJsonSchema(baseAnyOf));
            }
        }
        result.required = baseSchema.required;
        if (baseSchema.items != null) {
            result.items = MongoJsonSchema.toMongoJsonSchemaItems(baseSchema.items);
        }
        result.additionalProperties = MongoJsonSchema.toMongoJsonSchemaAdditionalProperties(baseSchema.additionalProperties);
        if (baseSchema.bsonType != null) {
            List trimmedList;
            Set<String> bsonTypes = MongoJsonSchema.polymorphicBsonTypeToStringSet(baseSchema.bsonType);
            if (bsonTypes.size() > 0 && bsonTypes.size() <= 2 && (trimmedList = bsonTypes.stream().filter(t -> !t.equalsIgnoreCase(BsonTypeInfo.BSON_NULL.getBsonName())).collect(Collectors.toList())).size() == 1) {
                String type = (String)trimmedList.get(0);
                if (BsonTypeInfo.BSON_ARRAY.getBsonName().equalsIgnoreCase(type) && baseSchema.items == null) {
                    return new MongoJsonSchema();
                }
                result.bsonType = type;
                return result;
            }
            if (result.anyOf == null) {
                result.anyOf = new HashSet<MongoJsonSchema>();
            }
            for (String currType : bsonTypes) {
                MongoJsonSchema anyOfSchema = new MongoJsonSchema();
                anyOfSchema.bsonType = currType;
                if (BsonTypeInfo.BSON_ARRAY.getBsonName().equalsIgnoreCase(currType)) {
                    anyOfSchema.items = MongoJsonSchema.toMongoJsonSchemaItems(baseSchema.items);
                } else if (BsonTypeInfo.BSON_OBJECT.getBsonName().equalsIgnoreCase(currType)) {
                    anyOfSchema.properties = MongoJsonSchema.toMongoJsonSchemaProperties(baseSchema.properties);
                    anyOfSchema.required = baseSchema.required;
                    anyOfSchema.additionalProperties = MongoJsonSchema.toMongoJsonSchemaAdditionalProperties(baseSchema.additionalProperties);
                    result.properties = null;
                    result.required = null;
                    result.additionalProperties = false;
                }
                if (result.anyOf.contains(anyOfSchema)) continue;
                result.anyOf.add(anyOfSchema);
            }
        }
        return result;
    }

    private static MongoJsonSchema toMongoJsonSchemaItems(BsonValue polymorphicItems) throws BsonInvalidOperationException {
        if (polymorphicItems == null) {
            return null;
        }
        if (!polymorphicItems.isArray() && !polymorphicItems.isDocument()) {
            throw new BsonInvalidOperationException("Value expected to be of type " + BsonType.ARRAY + " or " + BsonType.DOCUMENT + " but  is of unexpected type " + polymorphicItems.getBsonType());
        }
        return new MongoJsonSchema();
    }

    private static boolean toMongoJsonSchemaAdditionalProperties(BsonValue polymorphicAdditionalProperties) throws BsonInvalidOperationException {
        if (polymorphicAdditionalProperties == null) {
            return false;
        }
        if (!polymorphicAdditionalProperties.isBoolean() && !polymorphicAdditionalProperties.isDocument()) {
            throw new BsonInvalidOperationException("Value expected to be of type " + BsonType.BOOLEAN + " or " + BsonType.DOCUMENT + " but is of unexpected type " + polymorphicAdditionalProperties.getBsonType());
        }
        return polymorphicAdditionalProperties.isDocument() ? true : polymorphicAdditionalProperties.asBoolean().getValue();
    }

    private static Set<String> polymorphicBsonTypeToStringSet(BsonValue polymorphicBsonType) throws BsonInvalidOperationException {
        HashSet<String> result;
        if (polymorphicBsonType.isArray()) {
            result = polymorphicBsonType.asArray().stream().map(val -> val.asString().getValue()).collect(Collectors.toSet());
        } else if (polymorphicBsonType.isString()) {
            result = new HashSet<String>();
            result.add(polymorphicBsonType.asString().getValue());
        } else {
            throw new BsonInvalidOperationException("Value expected to be of type " + BsonType.ARRAY + " or " + BsonType.STRING + " but  is of unexpected type " + polymorphicBsonType.getBsonType());
        }
        return result;
    }

    private static MongoJsonSchema flattenNestedAnyOfs(MongoJsonSchema ioSchema) {
        if (ioSchema == null) {
            return null;
        }
        MongoJsonSchema result = ioSchema;
        if (result.anyOf != null && !result.anyOf.isEmpty()) {
            result.anyOf = result.anyOf.stream().flatMap(anyOf -> {
                if (anyOf == null) {
                    return Stream.empty();
                }
                if (anyOf.anyOf != null && !anyOf.anyOf.isEmpty()) {
                    return anyOf.anyOf.stream();
                }
                return Stream.of(anyOf);
            }).collect(Collectors.toSet());
        }
        if (result.anyOf != null && result.anyOf.size() == 1 && result.bsonType == null) {
            MongoJsonSchema singleAnyOf = result.anyOf.toArray(new MongoJsonSchema[0])[0];
            result.bsonType = singleAnyOf.bsonType;
            result.properties = singleAnyOf.properties;
            result.items = singleAnyOf.items;
            result.required = singleAnyOf.required;
            result.additionalProperties = singleAnyOf.additionalProperties;
            result.anyOf = null;
        }
        return result;
    }

    public static MongoJsonSchema createEmptyObjectSchema() {
        MongoJsonSchema ret = new MongoJsonSchema();
        ret.bsonType = "object";
        ret.properties = new LinkedHashMap<String, MongoJsonSchema>();
        ret.required = new HashSet<String>();
        return ret;
    }

    public static MongoJsonSchema createScalarSchema(String type) {
        MongoJsonSchema ret = new MongoJsonSchema();
        ret.bsonType = type;
        return ret;
    }

    private static Map<String, MongoJsonSchema> toMongoJsonSchemaProperties(Map<String, JsonSchema> from) {
        if (from == null) {
            return null;
        }
        HashMap<String, MongoJsonSchema> to = new HashMap<String, MongoJsonSchema>();
        for (Map.Entry<String, JsonSchema> entry : from.entrySet()) {
            to.put(entry.getKey(), MongoJsonSchema.toSimplifiedMongoJsonSchema(entry.getValue()));
        }
        return to;
    }

    @SafeVarargs
    public final void addScalarKeys(ScalarProperties ... scalarProperties) {
        try {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, MongoJsonSchema>();
            }
            if (this.required == null) {
                this.required = new HashSet<String>();
            }
            ScalarProperties[] scalarPropertiesArray = scalarProperties;
            int n = scalarProperties.length;
            int n2 = 0;
            while (n2 < n) {
                ScalarProperties prop = scalarPropertiesArray[n2];
                if (prop.isRequired) {
                    this.required.add(prop.name);
                }
                this.properties.put(prop.name, MongoJsonSchema.createScalarSchema(prop.type.getBsonName()));
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    public boolean equals(Object obj) {
        try {
            if (!(obj instanceof MongoJsonSchema)) {
                return false;
            }
            MongoJsonSchema other = (MongoJsonSchema)obj;
            return Objects.equals(this.bsonType, other.bsonType) && Objects.equals(this.properties, other.properties) && Objects.equals(this.anyOf, other.anyOf) && Objects.equals(this.required, other.required) && Objects.equals(this.items, other.items) && this.additionalProperties == other.additionalProperties;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    public int hashCode() {
        try {
            return Objects.hash(this.bsonType, this.properties, this.anyOf, this.required, this.items, this.additionalProperties);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public String toString() {
        try {
            return BsonUtils.toString(CODEC, this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public boolean isAny() {
        try {
            return this.bsonType == null && this.properties == null && this.anyOf == null && this.required == null && this.items == null && !this.additionalProperties;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public boolean isObject() {
        try {
            return this.bsonType != null && this.bsonType.equals("object");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    public int getColumnNullability(String columnName) throws SQLException {
        try {
            int nullable;
            boolean required = this.required != null && this.required.contains(columnName);
            MongoJsonSchema columnSchema = this.properties.get(columnName);
            if (columnSchema == null) {
                if (required || this.additionalProperties) {
                    return 2;
                }
                throw new SQLException("nullability info requested for invalid column '" + columnName + "'");
            }
            if (columnSchema.isAny()) {
                return 1;
            }
            int n = nullable = required ? 0 : 1;
            if (columnSchema.bsonType != null) {
                return columnSchema.bsonType.equals(BsonTypeInfo.BSON_NULL.getBsonName()) ? 1 : nullable;
            }
            if (columnSchema.anyOf == null) {
                throw new SQLException("invalid schema: both bsonType and anyOf are null and this is not ANY");
            }
            for (MongoJsonSchema anyOfSchema : columnSchema.anyOf) {
                if (anyOfSchema.bsonType == null) {
                    throw new SQLException("invalid schema: anyOf subschema must have bsonType field; nested anyOf must be simplified");
                }
                if (!anyOfSchema.bsonType.equals(BsonTypeInfo.BSON_NULL.getBsonName())) continue;
                return 1;
            }
            return nullable;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @BsonIgnore
    public BsonTypeInfo getBsonTypeInfo() throws SQLException {
        try {
            if (this.bsonType != null) {
                return BsonTypeInfo.getBsonTypeInfoByName(this.bsonType);
            }
            if (this.isAny()) {
                return BsonTypeInfo.BSON_BSON;
            }
            if (this.anyOf == null) {
                throw new SQLException("invalid schema: both bsonType and anyOf are null and this is not ANY");
            }
            BsonTypeInfo info = null;
            for (MongoJsonSchema anyOfSchema : this.anyOf) {
                if (anyOfSchema.bsonType == null) {
                    throw new SQLException("invalid schema: anyOf subschema must have bsonType field; nested anyOf must be simplified");
                }
                if (anyOfSchema.bsonType.equals(BsonTypeInfo.BSON_NULL.getBsonName())) continue;
                info = info != null ? BsonTypeInfo.BSON_BSON : BsonTypeInfo.getBsonTypeInfoByName(anyOfSchema.bsonType);
            }
            return info;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoJsonSchema.java", MongoJsonSchema.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("91", "addScalarKeys", "com.mongodb.jdbc.MongoJsonSchema", "[Lcom.mongodb.jdbc.MongoJsonSchema$ScalarProperties;", "scalarProperties", "", "void"), 388);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "com.mongodb.jdbc.MongoJsonSchema", "java.lang.Object", "obj", "", "boolean"), 404);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "com.mongodb.jdbc.MongoJsonSchema", "", "", "", "int"), 418);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.mongodb.jdbc.MongoJsonSchema", "", "", "", "java.lang.String"), 423);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAny", "com.mongodb.jdbc.MongoJsonSchema", "", "", "", "boolean"), 429);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isObject", "com.mongodb.jdbc.MongoJsonSchema", "", "", "", "boolean"), 438);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnNullability", "com.mongodb.jdbc.MongoJsonSchema", "java.lang.String", "columnName", "java.sql.SQLException", "int"), 474);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBsonTypeInfo", "com.mongodb.jdbc.MongoJsonSchema", "", "", "java.sql.SQLException", "com.mongodb.jdbc.BsonTypeInfo"), 528);
    }

    public static class ScalarProperties {
        protected String name;
        protected boolean isRequired = true;
        protected BsonTypeInfo type;

        public ScalarProperties(String name, BsonTypeInfo type, boolean isRequired) {
            this.name = name;
            this.isRequired = isRequired;
            this.type = type;
        }

        public ScalarProperties(String name, BsonTypeInfo type) {
            this.name = name;
            this.type = type;
        }
    }
}

