/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.logging;

import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.QueryDiagnostics;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonArray;
import org.bson.BsonDocument;

public class MongoLogger {
    private static final String ENTRY_PREFIX = ">> ";
    private Logger logger;
    private Integer connectionId;
    private Integer statementId;
    private QueryDiagnostics queryDiagnostics = new QueryDiagnostics();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public MongoLogger(Logger logger, int connectionId) {
        this.logger = logger;
        this.connectionId = connectionId;
    }

    public MongoLogger(String className, MongoLogger parentLogger, int statementId) {
        this.createLogger(className, parentLogger);
        this.statementId = statementId;
    }

    public MongoLogger(String className, MongoLogger parentLogger) {
        this.createLogger(className, parentLogger);
    }

    private void createLogger(String className, MongoLogger parentLogger) {
        try {
            Handler handler;
            String loggername = parentLogger.connectionId == null ? className : parentLogger.connectionId + "_" + className;
            this.logger = Logger.getLogger(loggername);
            this.logger.setLevel(parentLogger.logger.getLevel());
            Handler[] handlerArray = this.logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                handler = handlerArray[n2];
                this.logger.removeHandler(handler);
                ++n2;
            }
            handlerArray = parentLogger.logger.getHandlers();
            n = handlerArray.length;
            n2 = 0;
            while (n2 < n) {
                handler = handlerArray[n2];
                this.logger.addHandler(handler);
                ++n2;
            }
            this.connectionId = parentLogger.connectionId;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    protected void logMethodEntry(String sourceName, String callSignature) {
        try {
            if (this.logger != null && this.logger.isLoggable(Level.FINER)) {
                this.logger.logp(Level.FINER, this.addConnectionStatementIdsToSourceName(sourceName), null, ENTRY_PREFIX + callSignature);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    protected void logError(String sourceName, String msg, Throwable thrown) {
        try {
            if (this.logger != null && this.logger.isLoggable(Level.SEVERE)) {
                if (thrown instanceof SQLException) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(msg);
                    sb.append("\n");
                    sb.append("SQL diagnostics: ");
                    sb.append(this.getQueryDiagnostics());
                    msg = sb.toString();
                }
                this.logger.logp(Level.SEVERE, this.addConnectionStatementIdsToSourceName(sourceName), null, msg, thrown);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public void log(Level level, String msg) {
        try {
            if (this.logger != null && this.logger.isLoggable(level)) {
                StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
                StackTraceElement ste = stacktrace[2];
                String sourceClassName = ste.getClassName();
                String methodName = ste.getMethodName();
                this.logger.logp(level, this.addConnectionStatementIdsToSourceName(sourceClassName), methodName, msg);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public void log(Level level, String msg, Object[] params) {
        try {
            if (this.logger != null && this.logger.isLoggable(level)) {
                StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
                StackTraceElement ste = stacktrace[2];
                String sourceClassName = ste.getClassName();
                String methodName = ste.getMethodName();
                this.logger.logp(level, this.addConnectionStatementIdsToSourceName(sourceClassName), methodName, msg, params);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        try {
            if (this.logger != null && this.logger.isLoggable(level)) {
                StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
                StackTraceElement ste = stacktrace[2];
                String sourceClassName = ste.getClassName();
                String methodName = ste.getMethodName();
                this.logger.logp(level, this.addConnectionStatementIdsToSourceName(sourceClassName), methodName, msg, thrown);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    protected String addConnectionStatementIdsToSourceName(String sourceName) {
        try {
            if (this.statementId != null) {
                sourceName = "[stmt-" + this.statementId + "] " + sourceName;
            }
            if (this.connectionId != null) {
                sourceName = "[c-" + this.connectionId + "] " + sourceName;
            }
            return sourceName;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    public QueryDiagnostics getQueryDiagnostics() {
        try {
            return this.queryDiagnostics;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    public void setQueryDiagnostics(QueryDiagnostics queryDiagnostics) {
        try {
            this.queryDiagnostics = queryDiagnostics;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    public void setResultSetSchema(MongoJsonSchema resultSetSchema) {
        try {
            this.getQueryDiagnostics().setResultSetSchema(resultSetSchema);
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    public void setNamespacesSchema(BsonDocument namespacesSchema) {
        try {
            this.getQueryDiagnostics().setQueryCatalog(namespacesSchema);
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    public void setSqlQuery(String sql) {
        try {
            this.getQueryDiagnostics().setSqlQuery(sql);
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    public void setPipeline(List<BsonDocument> pipeline) {
        try {
            this.getQueryDiagnostics().setPipeline(new BsonArray(pipeline));
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    static {
        MongoLogger.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoLogger.java", MongoLogger.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createLogger", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String:com.mongodb.jdbc.logging.MongoLogger", "className:parentLogger", "", "void"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "logMethodEntry", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String:java.lang.String", "sourceName:callSignature", "", "void"), 107);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNamespacesSchema", "com.mongodb.jdbc.logging.MongoLogger", "org.bson.BsonDocument", "namespacesSchema", "", "void"), 248);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSqlQuery", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String", "sql", "", "void"), 252);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPipeline", "com.mongodb.jdbc.logging.MongoLogger", "java.util.List", "pipeline", "", "void"), 256);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "logError", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String:java.lang.String:java.lang.Throwable", "sourceName:msg:thrown", "", "void"), 117);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "log", "com.mongodb.jdbc.logging.MongoLogger", "java.util.logging.Level:java.lang.String", "level:msg", "", "void"), 146);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "log", "com.mongodb.jdbc.logging.MongoLogger", "java.util.logging.Level:java.lang.String:[Ljava.lang.Object;", "level:msg:params", "", "void"), 169);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "log", "com.mongodb.jdbc.logging.MongoLogger", "java.util.logging.Level:java.lang.String:java.lang.Throwable", "level:msg:thrown", "", "void"), 200);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addConnectionStatementIdsToSourceName", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String", "sourceName", "", "java.lang.String"), 223);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryDiagnostics", "com.mongodb.jdbc.logging.MongoLogger", "", "", "", "com.mongodb.jdbc.logging.QueryDiagnostics"), 236);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setQueryDiagnostics", "com.mongodb.jdbc.logging.MongoLogger", "com.mongodb.jdbc.logging.QueryDiagnostics", "queryDiagnostics", "", "void"), 240);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setResultSetSchema", "com.mongodb.jdbc.logging.MongoLogger", "com.mongodb.jdbc.MongoJsonSchema", "resultSetSchema", "", "void"), 244);
    }
}

