/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.logging;

import com.mongodb.jdbc.logging.LoggingAspect;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MongoSimpleFormatter
extends Formatter {
    private final String format = "[%1$tF %1$tT.%1$tL] [%4$s] %2$s: %5$s %6$s %n";
    private final Date date = new Date();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public String format(LogRecord record) {
        try {
            String source;
            this.date.setTime(record.getMillis());
            if (record.getSourceClassName() != null) {
                source = record.getSourceClassName();
                if (record.getSourceMethodName() != null) {
                    source = String.valueOf(source) + " " + record.getSourceMethodName();
                }
            } else {
                source = record.getLoggerName();
            }
            String message = this.formatMessage(record);
            String throwable = "";
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format("[%1$tF %1$tT.%1$tL] [%4$s] %2$s: %5$s %6$s %n", this.date, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    static {
        MongoSimpleFormatter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSimpleFormatter.java", MongoSimpleFormatter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "format", "com.mongodb.jdbc.logging.MongoSimpleFormatter", "java.util.logging.LogRecord", "record", "", "java.lang.String"), 30);
    }
}

