/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.mongosql;

import com.mongodb.jdbc.JsonSchema;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.utils.BsonUtils;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public class TranslateResult {
    private static final Codec<TranslateResult> CODEC;
    public final String targetDb;
    public final String targetCollection;
    public final List<BsonDocument> pipeline;
    public final MongoJsonSchema resultSetSchema;
    public final List<List<String>> selectOrder;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        TranslateResult.ajc$preClinit();
        CODEC = MongoDriver.getCodecRegistry().get(TranslateResult.class);
    }

    @BsonCreator
    public TranslateResult(@BsonProperty(value="target_db") String targetDb, @BsonProperty(value="target_collection") String targetCollection, @BsonProperty(value="pipeline") List<BsonDocument> pipeline, @BsonProperty(value="result_set_schema") JsonSchema resultSetSchema, @BsonProperty(value="select_order") List<List<String>> selectOrder) {
        this.targetDb = targetDb;
        this.targetCollection = targetCollection;
        this.pipeline = pipeline;
        this.resultSetSchema = resultSetSchema != null ? MongoJsonSchema.toSimplifiedMongoJsonSchema(resultSetSchema) : null;
        this.selectOrder = selectOrder;
    }

    public String toString() {
        try {
            return BsonUtils.toString(CODEC, this, BsonUtils.JSON_WRITER_NO_INDENT_SETTINGS);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TranslateResult.java", TranslateResult.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.mongodb.jdbc.mongosql.TranslateResult", "", "", "", "java.lang.String"), 60);
    }
}

