/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.oidc;

import com.mongodb.MongoCredential;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import com.mongodb.jdbc.oidc.OidcAuthFlow;
import com.mongodb.jdbc.oidc.OidcTimeoutException;
import javax.security.auth.RefreshFailedException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class JdbcOidcCallback
implements MongoCredential.OidcCallback {
    private final OidcAuthFlow oidcAuthFlow;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public JdbcOidcCallback() {
        this.oidcAuthFlow = new OidcAuthFlow();
    }

    public JdbcOidcCallback(MongoLogger parentLogger) {
        this.oidcAuthFlow = new OidcAuthFlow(parentLogger);
    }

    public MongoCredential.OidcCallbackResult onRequest(MongoCredential.OidcCallbackContext callbackContext) {
        try {
            String refreshToken = callbackContext.getRefreshToken();
            if (refreshToken != null && !refreshToken.isEmpty()) {
                try {
                    return this.oidcAuthFlow.doRefresh(callbackContext);
                }
                catch (RefreshFailedException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                return this.oidcAuthFlow.doAuthCodeFlow(callbackContext);
            }
            catch (OidcTimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    static {
        JdbcOidcCallback.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JdbcOidcCallback.java", JdbcOidcCallback.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onRequest", "com.mongodb.jdbc.oidc.JdbcOidcCallback", "com.mongodb.MongoCredential$OidcCallbackContext", "callbackContext", "", "com.mongodb.MongoCredential$OidcCallbackResult"), 36);
    }
}

