/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.oidc.manualtests;

import com.mongodb.MongoCredential;
import com.mongodb.jdbc.oidc.JdbcOidcCallback;
import com.mongodb.jdbc.oidc.JdbcOidcCallbackContext;
import com.mongodb.jdbc.oidc.OidcTimeoutException;
import com.mongodb.jdbc.oidc.manualtests.TestOidcUtils;
import java.time.Duration;

public class TestOidcCallbackWithShortTimeout {
    public static void main(String[] args) {
        JdbcOidcCallback oidcCallback = new JdbcOidcCallback();
        Duration shortTimeout = Duration.ofSeconds(2L);
        JdbcOidcCallbackContext context = new JdbcOidcCallbackContext(shortTimeout, 1, null, TestOidcUtils.IDP_INFO, null);
        try {
            MongoCredential.OidcCallbackResult result = oidcCallback.onRequest(context);
            System.out.println("This should not print, timeout expected. Sign out of the IdP or clear the browser cache to trigger a timeout.");
            System.out.println(result);
        }
        catch (Exception e) {
            if (e.getCause() instanceof OidcTimeoutException) {
                System.err.println("Expected OidcTimeoutException occurred: " + e.getCause().getMessage());
            }
            System.err.println("Unexpected error: " + e.getMessage());
        }
    }
}

