/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.utils;

import com.mongodb.jdbc.MongoSerializationException;
import com.mongodb.jdbc.NoCheckStateJsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public class BsonUtils {
    public static final JsonWriterSettings JSON_WRITER_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).indent(true).build();
    public static final JsonWriterSettings JSON_WRITER_NO_INDENT_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).indent(false).build();

    /*
     * Loose catch block
     */
    public static byte[] serialize(BsonDocument doc) throws MongoSerializationException {
        if (doc == null) {
            throw new MongoSerializationException("Cannot serialize a null BsonDocument.");
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                byte[] byArray;
                BsonBinaryWriter writer;
                BasicOutputBuffer buffer;
                block19: {
                    block18: {
                        buffer = new BasicOutputBuffer();
                        writer = new BsonBinaryWriter((BsonOutput)buffer);
                        BsonDocumentCodec codec = new BsonDocumentCodec();
                        codec.encode((BsonWriter)writer, doc, EncoderContext.builder().build());
                        writer.flush();
                        byArray = buffer.toByteArray();
                        if (writer == null) break block18;
                        writer.close();
                    }
                    if (buffer == null) break block19;
                    buffer.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (buffer != null) {
                                buffer.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            throw new MongoSerializationException("Failed to serialize BSON.", e);
        }
    }

    public static BsonDocument deserialize(byte[] bytes) throws MongoSerializationException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(bytes));){
                BsonDocumentCodec codec = new BsonDocumentCodec();
                return codec.decode((BsonReader)reader, DecoderContext.builder().build());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            throw new MongoSerializationException("Failed to deserialize BSON.", e);
        }
    }

    /*
     * Loose catch block
     */
    public static <T> String toString(Codec<T> codec, T val, JsonWriterSettings settings) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                String string;
                NoCheckStateJsonWriter jsonWriter;
                StringWriter writer;
                block18: {
                    block17: {
                        writer = new StringWriter();
                        jsonWriter = new NoCheckStateJsonWriter(writer, settings);
                        codec.encode((BsonWriter)jsonWriter, val, EncoderContext.builder().build());
                        writer.flush();
                        string = writer.toString();
                        if (jsonWriter == null) break block17;
                        jsonWriter.close();
                    }
                    if (writer == null) break block18;
                    writer.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (jsonWriter != null) {
                                jsonWriter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (writer != null) {
                                writer.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String toString(Codec<T> codec, T val) {
        return BsonUtils.toString(codec, val, JSON_WRITER_SETTINGS);
    }

    public static <T> BsonDocument toBsonDocument(Codec<T> codec, T val) {
        BsonDocument doc = new BsonDocument();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BsonDocumentWriter writer = new BsonDocumentWriter(doc);){
            codec.encode((BsonWriter)writer, val, EncoderContext.builder().build());
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return doc;
    }
}

