/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.utils;

import com.mongodb.MongoException;
import com.mongodb.jdbc.MongoDriver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.ProviderNotFoundException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;

public class NativeLoader {
    private static final String NATIVE_FOLDER_PATH_PREFIX = "mongosql_native";
    private static File temporaryLibDir;
    private static Set<String> loadedLibs;
    private static final Pattern X86_64_ARCH_PATTERN;
    private static final Pattern ARM_ARCH_PATTERN;
    private static final String ARM = "arm";
    private static final String X86_64 = "x86_64";
    private static final String MACOS = "macos";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "win";

    static {
        loadedLibs = new HashSet<String>();
        X86_64_ARCH_PATTERN = Pattern.compile("^(x86_64|amd64|ia32e|em64t|x64|x86-64|8664|intel64)$");
        ARM_ARCH_PATTERN = Pattern.compile("^(aarch64|arm64)$");
    }

    private NativeLoader() {
    }

    private static String normalizeOS() throws MongoException {
        if (SystemUtils.IS_OS_LINUX) {
            return LINUX;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return WINDOWS;
        }
        if (SystemUtils.IS_OS_MAC) {
            return MACOS;
        }
        throw new MongoException("Unsupported OS : " + SystemUtils.OS_NAME);
    }

    private static String normalizeArch() throws MongoException {
        String arch = SystemUtils.OS_ARCH.toLowerCase();
        if (X86_64_ARCH_PATTERN.matcher(arch).matches()) {
            return X86_64;
        }
        if (ARM_ARCH_PATTERN.matcher(arch).matches()) {
            return ARM;
        }
        throw new MongoException("Unsupported architecture : " + arch);
    }

    public static String loadLibraryFromJar(String libraryName) throws IOException, IllegalArgumentException, FileNotFoundException {
        String libName = System.mapLibraryName(libraryName);
        if (loadedLibs.contains(libName)) {
            return libName;
        }
        String resourcePath = String.valueOf(NativeLoader.normalizeArch().toLowerCase()) + "/" + NativeLoader.normalizeOS().toLowerCase() + "/" + libName;
        URL resource = MongoDriver.class.getProtectionDomain().getClassLoader().getResource(resourcePath);
        if (resource != null) {
            if (temporaryLibDir == null) {
                temporaryLibDir = NativeLoader.createTempDirectory();
                temporaryLibDir.deleteOnExit();
            }
            File libFile = new File(temporaryLibDir, libName);
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (InputStream is = resource.openStream();){
                    Files.copy(is, libFile.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                libFile.delete();
                throw e;
            }
            catch (NullPointerException nullPointerException) {
                libFile.delete();
                throw new FileNotFoundException("Resource " + resourcePath + " was not found inside JAR.");
            }
            try {
                System.load(libFile.getAbsolutePath());
            }
            finally {
                if (NativeLoader.isPosixCompliant()) {
                    libFile.delete();
                } else {
                    libFile.deleteOnExit();
                }
            }
            return libFile.getAbsolutePath();
        }
        throw new FileNotFoundException("Resource " + resourcePath + " was not found inside JAR.");
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static File createTempDirectory() throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, NATIVE_FOLDER_PATH_PREFIX + System.nanoTime());
        if (!generatedDir.mkdir() && !Files.exists(generatedDir.toPath(), new LinkOption[0])) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }
}

