/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.utils;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bson.BsonDocument;

public class X509Authentication {
    private static final BouncyCastleProvider BC_PROVIDER;
    private final MongoLogger logger;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        X509Authentication.ajc$preClinit();
        BC_PROVIDER = new BouncyCastleProvider();
    }

    public X509Authentication(MongoLogger logger) {
        MongoLogger mongoLogger = logger;
        X509Authentication x509Authentication = this;
        if (LoggingAspect.hasAspect(this)) {
            X509Authentication.logger_aroundBody1$advice(this, x509Authentication, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            x509Authentication.logger = mongoLogger;
        }
    }

    public void configureX509Authentication(MongoClientSettings.Builder settingsBuilder, String pemPath, String tlsCaFile, char[] passphrase) throws Exception {
        try {
            PEMParser pemParser = null;
            char[] privateKeyPassphrase = null;
            if (pemPath != null && !pemPath.trim().isEmpty()) {
                File file = new File(pemPath);
                this.logger.log(Level.FINE, "Using client certificate for X509 authentication: " + pemPath);
                try {
                    pemParser = new PEMParser((Reader)new FileReader(file));
                }
                catch (IOException e) {
                    throw new MongoException("Failed to read PEM file: " + e.getMessage(), (Throwable)e);
                }
                privateKeyPassphrase = passphrase;
            } else {
                if (passphrase == null || passphrase.length == 0) {
                    throw new MongoException("No PEM path provided and passphrase is empty");
                }
                String passphraseAsPemContent = new String(passphrase);
                PemAuthenticationInput pemAuthenticationInput = this.parsePemAuthenticationInput(passphraseAsPemContent);
                if (pemAuthenticationInput != null) {
                    this.logger.log(Level.FINE, "Using X.509 credentials from JSON in passphrase field");
                    pemParser = new PEMParser((Reader)new StringReader(this.formatPemString(pemAuthenticationInput.pem)));
                    privateKeyPassphrase = pemAuthenticationInput.passphrase != null ? pemAuthenticationInput.passphrase.toCharArray() : null;
                } else {
                    this.logger.log(Level.FINE, "Using raw PEM content from passphrase field (unencrypted)");
                    pemParser = new PEMParser((Reader)new StringReader(this.formatPemString(passphraseAsPemContent)));
                    privateKeyPassphrase = null;
                }
            }
            try {
                try {
                    SSLContext sslContext = this.createSSLContext(pemParser, privateKeyPassphrase, tlsCaFile);
                    settingsBuilder.applyToSslSettings(sslSettings -> {
                        sslSettings.enabled(true);
                        sslSettings.context(sslContext);
                    });
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "SSL setup failed: " + e.getMessage());
                    throw e;
                }
            }
            finally {
                if (pemParser != null) {
                    try {
                        pemParser.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "Error closing PEM parser: " + e.getMessage());
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    String formatPemString(String pem) {
        try {
            if (pem == null) {
                return null;
            }
            pem = pem.replace("\\\\n", "\n").replace("\\n", "\n").replace("\\r", "\n");
            pem = pem.replace("-----BEGIN", "\n-----BEGIN");
            pem = pem.replace("-----END", "\n-----END");
            pem = pem.replace(" PRIVATE KEY-----", " PRIVATE KEY-----\n");
            pem = pem.replace(" CERTIFICATE-----", " CERTIFICATE-----\n");
            pem = pem.replace("Proc-Type:", "\nProc-Type:");
            pem = pem.replaceAll("DEK-Info:\\s+[A-Z0-9\\-]+,[A-F0-9]+\\s*", "\n$0\n");
            if (!(pem = pem.replaceAll("[ \\t]*\n[ \\t]*", "\n").replaceAll("\n+", "\n").trim()).endsWith("\n")) {
                pem = String.valueOf(pem) + "\n";
            }
            return pem;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    private SSLContext createSSLContext(PEMParser pemParser, char[] passphrase, String tlsCaFile) throws Exception {
        try {
            PrivateKey privateKey = null;
            X509Certificate cert = null;
            try {
                Object pemObj = null;
                while (pemParser != null && (pemObj = pemParser.readObject()) != null && (cert == null || privateKey == null)) {
                    JcePKCSPBEInputDecryptorProviderBuilder decryptorBuilder;
                    this.logger.log(Level.FINE, "Processing PEM object of type: " + pemObj.getClass().getName());
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)BC_PROVIDER);
                    if (pemObj instanceof PrivateKeyInfo) {
                        this.logger.log(Level.FINE, "Found encrypted Private key (PKCS#8)");
                        if (privateKey == null) {
                            PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemObj;
                            privateKey = converter.getPrivateKey(privateKeyInfo);
                            this.logger.log(Level.FINE, "Successfully loaded unencrypted Private Key (PKCS#8). Algorithm: " + privateKey.getAlgorithm());
                            continue;
                        }
                        this.logger.log(Level.WARNING, "Already found a private key. This one will be ignored.");
                        continue;
                    }
                    if (pemObj instanceof PEMKeyPair) {
                        this.logger.log(Level.FINE, "Found encrypted Private key (PKCS#1)");
                        if (privateKey == null) {
                            PEMKeyPair pemKeyPair = (PEMKeyPair)pemObj;
                            privateKey = converter.getKeyPair(pemKeyPair).getPrivate();
                            this.logger.log(Level.FINE, "Successfully loaded unencrypted Private Key (PKCS#1). Algorithm: " + privateKey.getAlgorithm());
                            continue;
                        }
                        this.logger.log(Level.WARNING, "Already found a private key. This one will be ignored.");
                        continue;
                    }
                    if (pemObj instanceof PKCS8EncryptedPrivateKeyInfo) {
                        this.logger.log(Level.FINE, "Found encrypted Private key (PKCS#8)");
                        if (privateKey == null) {
                            PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObj;
                            try {
                                decryptorBuilder = new JcePKCSPBEInputDecryptorProviderBuilder();
                                PrivateKeyInfo decryptedInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptorBuilder.setProvider((Provider)BC_PROVIDER).build(passphrase));
                                this.logger.log(Level.FINE, "Successfully decrypted Private Key (PKCS#8)");
                                privateKey = converter.getPrivateKey(decryptedInfo);
                                this.logger.log(Level.FINE, "Successfully loaded Private Key (PKCS#8). Algorithm: " + privateKey.getAlgorithm());
                                continue;
                            }
                            catch (Exception e) {
                                throw new GeneralSecurityException("Incorrect password or decryption error for PKCS#8 key: " + e.getMessage(), e);
                            }
                        }
                        this.logger.log(Level.WARNING, "Already found a private key. This one will be ignored.");
                        continue;
                    }
                    if (pemObj instanceof PEMEncryptedKeyPair) {
                        this.logger.log(Level.FINE, "Private key is encrypted (PKCS#1)");
                        if (privateKey == null) {
                            PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)pemObj;
                            try {
                                decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                                PEMKeyPair decryptedKeyPair = encryptedKeyPair.decryptKeyPair(decryptorBuilder.setProvider((Provider)BC_PROVIDER).build(passphrase));
                                this.logger.log(Level.FINE, "Successfully decrypted Private Key (PKCS#1)");
                                privateKey = converter.getKeyPair(decryptedKeyPair).getPrivate();
                                this.logger.log(Level.FINE, "Successfully loaded Private Key (PKCS#1). Algorithm: " + privateKey.getAlgorithm());
                                continue;
                            }
                            catch (PEMException e) {
                                throw new GeneralSecurityException("Incorrect password or decryption error for PKCS#1 key: " + e.getMessage(), e);
                            }
                            catch (Exception e) {
                                throw new MongoException("An unexpected error occurred during PKCS#1 key decryption: " + e.getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
                            }
                        }
                        this.logger.log(Level.WARNING, "Already found a private key. This one will be ignored.");
                        continue;
                    }
                    if (pemObj instanceof X509CertificateHolder) {
                        this.logger.log(Level.FINE, "Found X.509 Certificate.");
                        if (cert == null) {
                            X509CertificateHolder certHolder = (X509CertificateHolder)pemObj;
                            this.logger.log(Level.FINE, "Successfully loaded X.509 Certificate.");
                            this.logger.log(Level.FINER, "  Subject: " + certHolder.getSubject());
                            this.logger.log(Level.FINER, "  Issuer: " + certHolder.getIssuer());
                            this.logger.log(Level.FINER, "  Serial Number: " + certHolder.getSerialNumber());
                            this.logger.log(Level.FINER, "  Validity information: " + certHolder.getNotAfter());
                            cert = new JcaX509CertificateConverter().setProvider((Provider)BC_PROVIDER).getCertificate(certHolder);
                            continue;
                        }
                        this.logger.log(Level.WARNING, "Already found an X509 certificate. This one will be ignored.");
                        continue;
                    }
                    this.logger.log(Level.FINE, "Found PEM object type: " + pemObj.getClass().getName() + ". This PEM object type is not used for X509 authentication and will be ignored.");
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error reading file or PEM parsing issue: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "An unexpected error occurred during PEM object processing: " + e.getClass().getSimpleName() + " - " + e.getMessage());
                throw e;
            }
            StringBuilder missingComponents = new StringBuilder();
            if (privateKey == null) {
                missingComponents.append("Private key not found (encrypted or unencrypted)");
            }
            if (cert == null) {
                if (missingComponents.length() > 0) {
                    missingComponents.append(" and ");
                }
                missingComponents.append("X.509 certificate not found");
            }
            if (missingComponents.length() > 0) {
                missingComponents.append(" in the PEM file");
                throw new MongoException(missingComponents.toString());
            }
            return this.createSSLContextFromKeyAndCert(privateKey, cert, tlsCaFile);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    private SSLContext createSSLContextFromKeyAndCert(PrivateKey privateKey, Certificate cert, String tlsCaFile) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", (Provider)BC_PROVIDER);
            keyStore.load(null, null);
            keyStore.setKeyEntry("mongodb-client-cert", privateKey, null, new Certificate[]{cert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (tlsCaFile != null && !tlsCaFile.trim().isEmpty()) {
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(null, null);
                if (this.loadCACertificates(tlsCaFile, trustStore) == 0) {
                    throw new MongoException("No X509 certificate found in CA file: " + tlsCaFile);
                }
                tmf.init(trustStore);
            } else {
                tmf.init((KeyStore)null);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int loadCACertificates(String tlsCaFile, KeyStore trustStore) throws Exception {
        try {
            if (tlsCaFile == null || tlsCaFile.trim().isEmpty()) {
                return 0;
            }
            int certCount = 0;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileReader fr = new FileReader(tlsCaFile);
                    try {
                        try (PEMParser pemParser = new PEMParser((Reader)fr);){
                            Object obj;
                            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider((Provider)BC_PROVIDER);
                            while ((obj = pemParser.readObject()) != null) {
                                if (!(obj instanceof X509CertificateHolder)) continue;
                                X509Certificate caCert = converter.getCertificate((X509CertificateHolder)obj);
                                trustStore.setCertificateEntry("ca" + certCount, caCert);
                                ++certCount;
                            }
                        }
                        if (fr == null) return certCount;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fr == null) throw throwable;
                        fr.close();
                        throw throwable;
                    }
                    fr.close();
                    return certCount;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new MongoException("Failed to load CA certificate from: " + tlsCaFile, (Throwable)e);
            }
        }
        catch (Exception exception) {
            if (!LoggingAspect.hasAspect(this)) throw exception;
            LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            throw exception;
        }
    }

    private PemAuthenticationInput parsePemAuthenticationInput(String input) {
        try {
            BsonDocument doc;
            block9: {
                block8: {
                    try {
                        doc = BsonDocument.parse((String)input);
                        if (doc != null) break block8;
                        this.logger.log(Level.FINE, "Failed to parse JSON: input was null or empty");
                        return null;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.FINE, "Failed to parse JSON input for X.509 authentication: " + e.getClass().getSimpleName());
                        return null;
                    }
                }
                if (doc.containsKey((Object)"pem")) break block9;
                this.logger.log(Level.FINE, "Missing required 'pem' field in JSON input");
                return null;
            }
            String pem = doc.getString((Object)"pem").getValue();
            String passphrase = null;
            if (doc.containsKey((Object)"passphrase")) {
                passphrase = doc.getString((Object)"passphrase").getValue();
            }
            return new PemAuthenticationInput(pem, passphrase);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(X509Authentication ajc$this, X509Authentication target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("X509Authentication.java", X509Authentication.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configureX509Authentication", "com.mongodb.jdbc.utils.X509Authentication", "com.mongodb.MongoClientSettings$Builder:java.lang.String:java.lang.String:[C", "settingsBuilder:pemPath:tlsCaFile:passphrase", "java.lang.Exception", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "formatPemString", "com.mongodb.jdbc.utils.X509Authentication", "java.lang.String", "pem", "", "java.lang.String"), 144);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createSSLContext", "com.mongodb.jdbc.utils.X509Authentication", "org.bouncycastle.openssl.PEMParser:[C:java.lang.String", "pemParser:passphrase:tlsCaFile", "java.lang.Exception", "javax.net.ssl.SSLContext"), 171);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createSSLContextFromKeyAndCert", "com.mongodb.jdbc.utils.X509Authentication", "java.security.PrivateKey:java.security.cert.Certificate:java.lang.String", "privateKey:cert:tlsCaFile", "java.lang.Exception", "javax.net.ssl.SSLContext"), 366);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadCACertificates", "com.mongodb.jdbc.utils.X509Authentication", "java.lang.String:java.security.KeyStore", "tlsCaFile:trustStore", "java.lang.Exception", "int"), 400);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "parsePemAuthenticationInput", "com.mongodb.jdbc.utils.X509Authentication", "java.lang.String", "input", "", "com.mongodb.jdbc.utils.X509Authentication$PemAuthenticationInput"), 426);
    }

    private static class PemAuthenticationInput {
        final String pem;
        final String passphrase;

        PemAuthenticationInput(String pem, String passphrase) {
            if (pem == null || pem.trim().isEmpty()) {
                throw new IllegalArgumentException("PEM content is required");
            }
            this.pem = pem.trim();
            this.passphrase = passphrase;
        }
    }
}

