/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.values.Value;

public interface BoltConnection {
    public <T> CompletionStage<T> onLoop(Supplier<T> var1);

    public CompletionStage<BoltConnection> route(DatabaseName var1, String var2, Set<String> var3);

    public CompletionStage<BoltConnection> beginTransaction(DatabaseName var1, AccessMode var2, String var3, Set<String> var4, TransactionType var5, Duration var6, Map<String, Value> var7, String var8, NotificationConfig var9);

    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName var1, AccessMode var2, String var3, Set<String> var4, String var5, Map<String, Value> var6, Duration var7, Map<String, Value> var8, NotificationConfig var9);

    public CompletionStage<BoltConnection> run(String var1, Map<String, Value> var2);

    public CompletionStage<BoltConnection> pull(long var1, long var3);

    public CompletionStage<BoltConnection> discard(long var1, long var3);

    public CompletionStage<BoltConnection> commit();

    public CompletionStage<BoltConnection> rollback();

    public CompletionStage<BoltConnection> reset();

    public CompletionStage<BoltConnection> logoff();

    public CompletionStage<BoltConnection> logon(AuthToken var1);

    public CompletionStage<BoltConnection> telemetry(TelemetryApi var1);

    public CompletionStage<BoltConnection> clear();

    public CompletionStage<Void> flush(ResponseHandler var1);

    public CompletionStage<Void> forceClose(String var1);

    public CompletionStage<Void> close();

    public CompletionStage<Void> setReadTimeout(Duration var1);

    public BoltConnectionState state();

    public CompletionStage<AuthInfo> authInfo();

    public String serverAgent();

    public BoltServerAddress serverAddress();

    public BoltProtocolVersion protocolVersion();

    public boolean telemetrySupported();

    public boolean serverSideRoutingEnabled();

    public Optional<Duration> defaultReadTimeout();
}

