/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.embedding.Embedding;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.EmbeddingException;
import org.noear.solon.ai.embedding.EmbeddingOptions;
import org.noear.solon.ai.embedding.EmbeddingResponse;
import org.noear.solon.ai.embedding.dialect.AbstractEmbeddingDialect;

public class DashscopeEmbeddingDialect
extends AbstractEmbeddingDialect {
    private static DashscopeEmbeddingDialect instance = new DashscopeEmbeddingDialect();

    public static DashscopeEmbeddingDialect getInstance() {
        return instance;
    }

    public boolean matched(EmbeddingConfig config) {
        return "dashscope".equals(config.getProvider());
    }

    public String buildRequestJson(EmbeddingConfig config, EmbeddingOptions options, List<String> input) {
        return new ONode().build(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("input").getOrNew("texts").build(n1 -> {
                for (String m1 : input) {
                    n1.add((Object)m1);
                }
            });
            n.getOrNew("parameters").build(n1 -> {
                for (Map.Entry kv : options.options().entrySet()) {
                    n1.set((String)kv.getKey(), kv.getValue());
                }
            });
        }).toJson();
    }

    public EmbeddingResponse parseResponseJson(EmbeddingConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            return new EmbeddingResponse(model, new EmbeddingException(oResp.get("code").getString() + ": " + oResp.get("message").getString()), null, null);
        }
        ArrayList<Embedding> data = new ArrayList<Embedding>();
        for (ONode n1 : oResp.get("output").get("embeddings").ary()) {
            int index = 0;
            index = n1.contains("text_index") ? n1.get("text_index").getInt() : n1.get("index").getInt();
            data.add(new Embedding(index, (float[])n1.get("embedding").toObject(float[].class)));
        }
        AiUsage usage = null;
        if (oResp.contains("usage")) {
            ONode oUsage = oResp.get("usage");
            int total_tokens = oUsage.get("total_tokens").getInt();
            usage = new AiUsage((long)total_tokens, 0L, (long)total_tokens);
        }
        return new EmbeddingResponse(model, null, data, usage);
    }
}

