/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.Generated;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class McpStatelessServerFeatures {

    public static class SyncCompletionSpecification {
        McpSchema.CompleteReference referenceKey;
        BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler;

        @Generated
        public McpSchema.CompleteReference getReferenceKey() {
            return this.referenceKey;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> getCompletionHandler() {
            return this.completionHandler;
        }

        @Generated
        public void setReferenceKey(McpSchema.CompleteReference referenceKey) {
            this.referenceKey = referenceKey;
        }

        @Generated
        public void setCompletionHandler(BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler) {
            this.completionHandler = completionHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncCompletionSpecification)) {
                return false;
            }
            SyncCompletionSpecification other = (SyncCompletionSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.CompleteReference this$referenceKey = this.getReferenceKey();
            McpSchema.CompleteReference other$referenceKey = other.getReferenceKey();
            if (this$referenceKey == null ? other$referenceKey != null : !this$referenceKey.equals(other$referenceKey)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> this$completionHandler = this.getCompletionHandler();
            BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> other$completionHandler = other.getCompletionHandler();
            return !(this$completionHandler == null ? other$completionHandler != null : !this$completionHandler.equals(other$completionHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SyncCompletionSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.CompleteReference $referenceKey = this.getReferenceKey();
            result = result * 59 + ($referenceKey == null ? 43 : $referenceKey.hashCode());
            BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> $completionHandler = this.getCompletionHandler();
            result = result * 59 + ($completionHandler == null ? 43 : $completionHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.SyncCompletionSpecification(referenceKey=" + this.getReferenceKey() + ", completionHandler=" + this.getCompletionHandler() + ")";
        }

        @Generated
        public SyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpTransportContext, McpSchema.CompleteRequest, McpSchema.CompleteResult> completionHandler) {
            this.referenceKey = referenceKey;
            this.completionHandler = completionHandler;
        }

        @Generated
        public SyncCompletionSpecification() {
        }
    }

    public static class SyncPromptSpecification {
        McpSchema.Prompt prompt;
        BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler;

        @Generated
        public McpSchema.Prompt getPrompt() {
            return this.prompt;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> getPromptHandler() {
            return this.promptHandler;
        }

        @Generated
        public void setPrompt(McpSchema.Prompt prompt) {
            this.prompt = prompt;
        }

        @Generated
        public void setPromptHandler(BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
            this.promptHandler = promptHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncPromptSpecification)) {
                return false;
            }
            SyncPromptSpecification other = (SyncPromptSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Prompt this$prompt = this.getPrompt();
            McpSchema.Prompt other$prompt = other.getPrompt();
            if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> this$promptHandler = this.getPromptHandler();
            BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> other$promptHandler = other.getPromptHandler();
            return !(this$promptHandler == null ? other$promptHandler != null : !this$promptHandler.equals(other$promptHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SyncPromptSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Prompt $prompt = this.getPrompt();
            result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
            BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> $promptHandler = this.getPromptHandler();
            result = result * 59 + ($promptHandler == null ? 43 : $promptHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.SyncPromptSpecification(prompt=" + this.getPrompt() + ", promptHandler=" + this.getPromptHandler() + ")";
        }

        @Generated
        public SyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpTransportContext, McpSchema.GetPromptRequest, McpSchema.GetPromptResult> promptHandler) {
            this.prompt = prompt;
            this.promptHandler = promptHandler;
        }

        @Generated
        public SyncPromptSpecification() {
        }
    }

    public static class SyncResourceSpecification {
        McpSchema.Resource resource;
        BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler;

        @Generated
        public McpSchema.Resource getResource() {
            return this.resource;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> getReadHandler() {
            return this.readHandler;
        }

        @Generated
        public void setResource(McpSchema.Resource resource) {
            this.resource = resource;
        }

        @Generated
        public void setReadHandler(BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
            this.readHandler = readHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncResourceSpecification)) {
                return false;
            }
            SyncResourceSpecification other = (SyncResourceSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Resource this$resource = this.getResource();
            McpSchema.Resource other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> this$readHandler = this.getReadHandler();
            BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> other$readHandler = other.getReadHandler();
            return !(this$readHandler == null ? other$readHandler != null : !this$readHandler.equals(other$readHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SyncResourceSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Resource $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
            BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> $readHandler = this.getReadHandler();
            result = result * 59 + ($readHandler == null ? 43 : $readHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.SyncResourceSpecification(resource=" + this.getResource() + ", readHandler=" + this.getReadHandler() + ")";
        }

        @Generated
        public SyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, McpSchema.ReadResourceResult> readHandler) {
            this.resource = resource;
            this.readHandler = readHandler;
        }

        @Generated
        public SyncResourceSpecification() {
        }
    }

    public static class SyncToolSpecification {
        McpSchema.Tool tool;
        BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public McpSchema.Tool getTool() {
            return this.tool;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> getCallHandler() {
            return this.callHandler;
        }

        @Generated
        public void setTool(McpSchema.Tool tool) {
            this.tool = tool;
        }

        @Generated
        public void setCallHandler(BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
            this.callHandler = callHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncToolSpecification)) {
                return false;
            }
            SyncToolSpecification other = (SyncToolSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Tool this$tool = this.getTool();
            McpSchema.Tool other$tool = other.getTool();
            if (this$tool == null ? other$tool != null : !((Object)this$tool).equals(other$tool)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> this$callHandler = this.getCallHandler();
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> other$callHandler = other.getCallHandler();
            return !(this$callHandler == null ? other$callHandler != null : !this$callHandler.equals(other$callHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SyncToolSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Tool $tool = this.getTool();
            result = result * 59 + ($tool == null ? 43 : ((Object)$tool).hashCode());
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> $callHandler = this.getCallHandler();
            result = result * 59 + ($callHandler == null ? 43 : $callHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.SyncToolSpecification(tool=" + this.getTool() + ", callHandler=" + this.getCallHandler() + ")";
        }

        @Generated
        public SyncToolSpecification(McpSchema.Tool tool, BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
            this.tool = tool;
            this.callHandler = callHandler;
        }

        @Generated
        public SyncToolSpecification() {
        }

        public static class Builder {
            private McpSchema.Tool tool;
            private BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler;

            public Builder tool(McpSchema.Tool tool) {
                this.tool = tool;
                return this;
            }

            public Builder callHandler(BiFunction<McpTransportContext, McpSchema.CallToolRequest, McpSchema.CallToolResult> callHandler) {
                this.callHandler = callHandler;
                return this;
            }

            public SyncToolSpecification build() {
                Assert.notNull(this.tool, "Tool must not be null");
                Assert.notNull(this.callHandler, "CallTool function must not be null");
                return new SyncToolSpecification(this.tool, this.callHandler);
            }
        }
    }

    public static class AsyncCompletionSpecification {
        McpSchema.CompleteReference referenceKey;
        BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> completionHandler;

        static AsyncCompletionSpecification fromSync(SyncCompletionSpecification completion, boolean immediateExecution) {
            if (completion == null) {
                return null;
            }
            return new AsyncCompletionSpecification(completion.getReferenceKey(), (ctx, req) -> {
                Mono completionResult = Mono.fromCallable(() -> completion.getCompletionHandler().apply((McpTransportContext)ctx, (McpSchema.CompleteRequest)req));
                return immediateExecution ? completionResult : completionResult.subscribeOn(Schedulers.boundedElastic());
            });
        }

        @Generated
        public McpSchema.CompleteReference getReferenceKey() {
            return this.referenceKey;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> getCompletionHandler() {
            return this.completionHandler;
        }

        @Generated
        public void setReferenceKey(McpSchema.CompleteReference referenceKey) {
            this.referenceKey = referenceKey;
        }

        @Generated
        public void setCompletionHandler(BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> completionHandler) {
            this.completionHandler = completionHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncCompletionSpecification)) {
                return false;
            }
            AsyncCompletionSpecification other = (AsyncCompletionSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.CompleteReference this$referenceKey = this.getReferenceKey();
            McpSchema.CompleteReference other$referenceKey = other.getReferenceKey();
            if (this$referenceKey == null ? other$referenceKey != null : !this$referenceKey.equals(other$referenceKey)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> this$completionHandler = this.getCompletionHandler();
            BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> other$completionHandler = other.getCompletionHandler();
            return !(this$completionHandler == null ? other$completionHandler != null : !this$completionHandler.equals(other$completionHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncCompletionSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.CompleteReference $referenceKey = this.getReferenceKey();
            result = result * 59 + ($referenceKey == null ? 43 : $referenceKey.hashCode());
            BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> $completionHandler = this.getCompletionHandler();
            result = result * 59 + ($completionHandler == null ? 43 : $completionHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.AsyncCompletionSpecification(referenceKey=" + this.getReferenceKey() + ", completionHandler=" + this.getCompletionHandler() + ")";
        }

        @Generated
        public AsyncCompletionSpecification(McpSchema.CompleteReference referenceKey, BiFunction<McpTransportContext, McpSchema.CompleteRequest, Mono<McpSchema.CompleteResult>> completionHandler) {
            this.referenceKey = referenceKey;
            this.completionHandler = completionHandler;
        }

        @Generated
        public AsyncCompletionSpecification() {
        }
    }

    public static class AsyncPromptSpecification {
        McpSchema.Prompt prompt;
        BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler;

        static AsyncPromptSpecification fromSync(SyncPromptSpecification prompt, boolean immediateExecution) {
            if (prompt == null) {
                return null;
            }
            return new AsyncPromptSpecification(prompt.getPrompt(), (ctx, req) -> {
                Mono promptResult = Mono.fromCallable(() -> prompt.getPromptHandler().apply((McpTransportContext)ctx, (McpSchema.GetPromptRequest)req));
                return immediateExecution ? promptResult : promptResult.subscribeOn(Schedulers.boundedElastic());
            });
        }

        @Generated
        public McpSchema.Prompt getPrompt() {
            return this.prompt;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> getPromptHandler() {
            return this.promptHandler;
        }

        @Generated
        public void setPrompt(McpSchema.Prompt prompt) {
            this.prompt = prompt;
        }

        @Generated
        public void setPromptHandler(BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
            this.promptHandler = promptHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncPromptSpecification)) {
                return false;
            }
            AsyncPromptSpecification other = (AsyncPromptSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Prompt this$prompt = this.getPrompt();
            McpSchema.Prompt other$prompt = other.getPrompt();
            if (this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> this$promptHandler = this.getPromptHandler();
            BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> other$promptHandler = other.getPromptHandler();
            return !(this$promptHandler == null ? other$promptHandler != null : !this$promptHandler.equals(other$promptHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncPromptSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Prompt $prompt = this.getPrompt();
            result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
            BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> $promptHandler = this.getPromptHandler();
            result = result * 59 + ($promptHandler == null ? 43 : $promptHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.AsyncPromptSpecification(prompt=" + this.getPrompt() + ", promptHandler=" + this.getPromptHandler() + ")";
        }

        @Generated
        public AsyncPromptSpecification(McpSchema.Prompt prompt, BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> promptHandler) {
            this.prompt = prompt;
            this.promptHandler = promptHandler;
        }

        @Generated
        public AsyncPromptSpecification() {
        }
    }

    public static class AsyncResourceSpecification {
        McpSchema.Resource resource;
        BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler;

        static AsyncResourceSpecification fromSync(SyncResourceSpecification resource, boolean immediateExecution) {
            if (resource == null) {
                return null;
            }
            return new AsyncResourceSpecification(resource.getResource(), (ctx, req) -> {
                Mono resourceResult = Mono.fromCallable(() -> resource.getReadHandler().apply((McpTransportContext)ctx, (McpSchema.ReadResourceRequest)req));
                return immediateExecution ? resourceResult : resourceResult.subscribeOn(Schedulers.boundedElastic());
            });
        }

        @Generated
        public McpSchema.Resource getResource() {
            return this.resource;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> getReadHandler() {
            return this.readHandler;
        }

        @Generated
        public void setResource(McpSchema.Resource resource) {
            this.resource = resource;
        }

        @Generated
        public void setReadHandler(BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
            this.readHandler = readHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncResourceSpecification)) {
                return false;
            }
            AsyncResourceSpecification other = (AsyncResourceSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Resource this$resource = this.getResource();
            McpSchema.Resource other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> this$readHandler = this.getReadHandler();
            BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> other$readHandler = other.getReadHandler();
            return !(this$readHandler == null ? other$readHandler != null : !this$readHandler.equals(other$readHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncResourceSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Resource $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
            BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> $readHandler = this.getReadHandler();
            result = result * 59 + ($readHandler == null ? 43 : $readHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.AsyncResourceSpecification(resource=" + this.getResource() + ", readHandler=" + this.getReadHandler() + ")";
        }

        @Generated
        public AsyncResourceSpecification(McpSchema.Resource resource, BiFunction<McpTransportContext, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> readHandler) {
            this.resource = resource;
            this.readHandler = readHandler;
        }

        @Generated
        public AsyncResourceSpecification() {
        }
    }

    public static class AsyncToolSpecification {
        McpSchema.Tool tool;
        BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler;

        static AsyncToolSpecification fromSync(SyncToolSpecification syncToolSpec) {
            return AsyncToolSpecification.fromSync(syncToolSpec, false);
        }

        static AsyncToolSpecification fromSync(SyncToolSpecification syncToolSpec, boolean immediate) {
            if (syncToolSpec == null) {
                return null;
            }
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler = (ctx, req) -> {
                Mono toolResult = Mono.fromCallable(() -> syncToolSpec.getCallHandler().apply((McpTransportContext)ctx, (McpSchema.CallToolRequest)req));
                return immediate ? toolResult : toolResult.subscribeOn(Schedulers.boundedElastic());
            };
            return new AsyncToolSpecification(syncToolSpec.getTool(), callHandler);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public McpSchema.Tool getTool() {
            return this.tool;
        }

        @Generated
        public BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> getCallHandler() {
            return this.callHandler;
        }

        @Generated
        public void setTool(McpSchema.Tool tool) {
            this.tool = tool;
        }

        @Generated
        public void setCallHandler(BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
            this.callHandler = callHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncToolSpecification)) {
                return false;
            }
            AsyncToolSpecification other = (AsyncToolSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Tool this$tool = this.getTool();
            McpSchema.Tool other$tool = other.getTool();
            if (this$tool == null ? other$tool != null : !((Object)this$tool).equals(other$tool)) {
                return false;
            }
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> this$callHandler = this.getCallHandler();
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> other$callHandler = other.getCallHandler();
            return !(this$callHandler == null ? other$callHandler != null : !this$callHandler.equals(other$callHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncToolSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Tool $tool = this.getTool();
            result = result * 59 + ($tool == null ? 43 : ((Object)$tool).hashCode());
            BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> $callHandler = this.getCallHandler();
            result = result * 59 + ($callHandler == null ? 43 : $callHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.AsyncToolSpecification(tool=" + this.getTool() + ", callHandler=" + this.getCallHandler() + ")";
        }

        @Generated
        public AsyncToolSpecification(McpSchema.Tool tool, BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
            this.tool = tool;
            this.callHandler = callHandler;
        }

        @Generated
        public AsyncToolSpecification() {
        }

        public static class Builder {
            private McpSchema.Tool tool;
            private BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler;

            public Builder tool(McpSchema.Tool tool) {
                this.tool = tool;
                return this;
            }

            public Builder callHandler(BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> callHandler) {
                this.callHandler = callHandler;
                return this;
            }

            public AsyncToolSpecification build() {
                Assert.notNull(this.tool, "Tool must not be null");
                Assert.notNull(this.callHandler, "Call handler function must not be null");
                return new AsyncToolSpecification(this.tool, this.callHandler);
            }
        }
    }

    public static class Sync {
        McpSchema.Implementation serverInfo;
        McpSchema.ServerCapabilities serverCapabilities;
        List<SyncToolSpecification> tools;
        Map<String, SyncResourceSpecification> resources;
        List<McpSchema.ResourceTemplate> resourceTemplates;
        Map<String, SyncPromptSpecification> prompts;
        Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions;
        String instructions;

        public Sync(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<SyncToolSpecification> tools, Map<String, SyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, SyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.completions = completions != null ? completions : new HashMap();
            this.instructions = instructions;
        }

        @Generated
        public McpSchema.Implementation getServerInfo() {
            return this.serverInfo;
        }

        @Generated
        public McpSchema.ServerCapabilities getServerCapabilities() {
            return this.serverCapabilities;
        }

        @Generated
        public List<SyncToolSpecification> getTools() {
            return this.tools;
        }

        @Generated
        public Map<String, SyncResourceSpecification> getResources() {
            return this.resources;
        }

        @Generated
        public List<McpSchema.ResourceTemplate> getResourceTemplates() {
            return this.resourceTemplates;
        }

        @Generated
        public Map<String, SyncPromptSpecification> getPrompts() {
            return this.prompts;
        }

        @Generated
        public Map<McpSchema.CompleteReference, SyncCompletionSpecification> getCompletions() {
            return this.completions;
        }

        @Generated
        public String getInstructions() {
            return this.instructions;
        }

        @Generated
        public void setServerInfo(McpSchema.Implementation serverInfo) {
            this.serverInfo = serverInfo;
        }

        @Generated
        public void setServerCapabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
        }

        @Generated
        public void setTools(List<SyncToolSpecification> tools) {
            this.tools = tools;
        }

        @Generated
        public void setResources(Map<String, SyncResourceSpecification> resources) {
            this.resources = resources;
        }

        @Generated
        public void setResourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates = resourceTemplates;
        }

        @Generated
        public void setPrompts(Map<String, SyncPromptSpecification> prompts) {
            this.prompts = prompts;
        }

        @Generated
        public void setCompletions(Map<McpSchema.CompleteReference, SyncCompletionSpecification> completions) {
            this.completions = completions;
        }

        @Generated
        public void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sync)) {
                return false;
            }
            Sync other = (Sync)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Implementation this$serverInfo = this.getServerInfo();
            McpSchema.Implementation other$serverInfo = other.getServerInfo();
            if (this$serverInfo == null ? other$serverInfo != null : !((Object)this$serverInfo).equals(other$serverInfo)) {
                return false;
            }
            McpSchema.ServerCapabilities this$serverCapabilities = this.getServerCapabilities();
            McpSchema.ServerCapabilities other$serverCapabilities = other.getServerCapabilities();
            if (this$serverCapabilities == null ? other$serverCapabilities != null : !((Object)this$serverCapabilities).equals(other$serverCapabilities)) {
                return false;
            }
            List<SyncToolSpecification> this$tools = this.getTools();
            List<SyncToolSpecification> other$tools = other.getTools();
            if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
                return false;
            }
            Map<String, SyncResourceSpecification> this$resources = this.getResources();
            Map<String, SyncResourceSpecification> other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            List<McpSchema.ResourceTemplate> this$resourceTemplates = this.getResourceTemplates();
            List<McpSchema.ResourceTemplate> other$resourceTemplates = other.getResourceTemplates();
            if (this$resourceTemplates == null ? other$resourceTemplates != null : !((Object)this$resourceTemplates).equals(other$resourceTemplates)) {
                return false;
            }
            Map<String, SyncPromptSpecification> this$prompts = this.getPrompts();
            Map<String, SyncPromptSpecification> other$prompts = other.getPrompts();
            if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
                return false;
            }
            Map<McpSchema.CompleteReference, SyncCompletionSpecification> this$completions = this.getCompletions();
            Map<McpSchema.CompleteReference, SyncCompletionSpecification> other$completions = other.getCompletions();
            if (this$completions == null ? other$completions != null : !((Object)this$completions).equals(other$completions)) {
                return false;
            }
            String this$instructions = this.getInstructions();
            String other$instructions = other.getInstructions();
            return !(this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sync;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Implementation $serverInfo = this.getServerInfo();
            result = result * 59 + ($serverInfo == null ? 43 : ((Object)$serverInfo).hashCode());
            McpSchema.ServerCapabilities $serverCapabilities = this.getServerCapabilities();
            result = result * 59 + ($serverCapabilities == null ? 43 : ((Object)$serverCapabilities).hashCode());
            List<SyncToolSpecification> $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            Map<String, SyncResourceSpecification> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            List<McpSchema.ResourceTemplate> $resourceTemplates = this.getResourceTemplates();
            result = result * 59 + ($resourceTemplates == null ? 43 : ((Object)$resourceTemplates).hashCode());
            Map<String, SyncPromptSpecification> $prompts = this.getPrompts();
            result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
            Map<McpSchema.CompleteReference, SyncCompletionSpecification> $completions = this.getCompletions();
            result = result * 59 + ($completions == null ? 43 : ((Object)$completions).hashCode());
            String $instructions = this.getInstructions();
            result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.Sync(serverInfo=" + this.getServerInfo() + ", serverCapabilities=" + this.getServerCapabilities() + ", tools=" + this.getTools() + ", resources=" + this.getResources() + ", resourceTemplates=" + this.getResourceTemplates() + ", prompts=" + this.getPrompts() + ", completions=" + this.getCompletions() + ", instructions=" + this.getInstructions() + ")";
        }

        @Generated
        public Sync() {
        }
    }

    public static class Async {
        McpSchema.Implementation serverInfo;
        McpSchema.ServerCapabilities serverCapabilities;
        List<AsyncToolSpecification> tools;
        Map<String, AsyncResourceSpecification> resources;
        List<McpSchema.ResourceTemplate> resourceTemplates;
        Map<String, AsyncPromptSpecification> prompts;
        Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions;
        String instructions;

        public Async(McpSchema.Implementation serverInfo, McpSchema.ServerCapabilities serverCapabilities, List<AsyncToolSpecification> tools, Map<String, AsyncResourceSpecification> resources, List<McpSchema.ResourceTemplate> resourceTemplates, Map<String, AsyncPromptSpecification> prompts, Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions, String instructions) {
            Assert.notNull(serverInfo, "Server info must not be null");
            this.serverInfo = serverInfo;
            this.serverCapabilities = serverCapabilities != null ? serverCapabilities : new McpSchema.ServerCapabilities(null, null, new McpSchema.ServerCapabilities.LoggingCapabilities(), !Utils.isEmpty(prompts) ? new McpSchema.ServerCapabilities.PromptCapabilities(false) : null, !Utils.isEmpty(resources) ? new McpSchema.ServerCapabilities.ResourceCapabilities(false, false) : null, !Utils.isEmpty(tools) ? new McpSchema.ServerCapabilities.ToolCapabilities(false) : null);
            this.tools = tools != null ? tools : new ArrayList();
            this.resources = resources != null ? resources : new HashMap();
            this.resourceTemplates = resourceTemplates != null ? resourceTemplates : new ArrayList();
            this.prompts = prompts != null ? prompts : new HashMap();
            this.completions = completions != null ? completions : new HashMap();
            this.instructions = instructions;
        }

        public static Async fromSync(Sync syncSpec, boolean immediateExecution) {
            ArrayList<AsyncToolSpecification> tools = new ArrayList<AsyncToolSpecification>();
            for (SyncToolSpecification tool : syncSpec.getTools()) {
                tools.add(AsyncToolSpecification.fromSync(tool, immediateExecution));
            }
            HashMap<String, AsyncResourceSpecification> resources = new HashMap<String, AsyncResourceSpecification>();
            syncSpec.getResources().forEach((key, resource) -> resources.put((String)key, AsyncResourceSpecification.fromSync(resource, immediateExecution)));
            HashMap<String, AsyncPromptSpecification> prompts = new HashMap<String, AsyncPromptSpecification>();
            syncSpec.getPrompts().forEach((key, prompt) -> prompts.put((String)key, AsyncPromptSpecification.fromSync(prompt, immediateExecution)));
            HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification> completions = new HashMap<McpSchema.CompleteReference, AsyncCompletionSpecification>();
            syncSpec.getCompletions().forEach((key, completion) -> completions.put((McpSchema.CompleteReference)key, AsyncCompletionSpecification.fromSync(completion, immediateExecution)));
            return new Async(syncSpec.getServerInfo(), syncSpec.getServerCapabilities(), tools, resources, syncSpec.getResourceTemplates(), prompts, completions, syncSpec.getInstructions());
        }

        @Generated
        public McpSchema.Implementation getServerInfo() {
            return this.serverInfo;
        }

        @Generated
        public McpSchema.ServerCapabilities getServerCapabilities() {
            return this.serverCapabilities;
        }

        @Generated
        public List<AsyncToolSpecification> getTools() {
            return this.tools;
        }

        @Generated
        public Map<String, AsyncResourceSpecification> getResources() {
            return this.resources;
        }

        @Generated
        public List<McpSchema.ResourceTemplate> getResourceTemplates() {
            return this.resourceTemplates;
        }

        @Generated
        public Map<String, AsyncPromptSpecification> getPrompts() {
            return this.prompts;
        }

        @Generated
        public Map<McpSchema.CompleteReference, AsyncCompletionSpecification> getCompletions() {
            return this.completions;
        }

        @Generated
        public String getInstructions() {
            return this.instructions;
        }

        @Generated
        public void setServerInfo(McpSchema.Implementation serverInfo) {
            this.serverInfo = serverInfo;
        }

        @Generated
        public void setServerCapabilities(McpSchema.ServerCapabilities serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
        }

        @Generated
        public void setTools(List<AsyncToolSpecification> tools) {
            this.tools = tools;
        }

        @Generated
        public void setResources(Map<String, AsyncResourceSpecification> resources) {
            this.resources = resources;
        }

        @Generated
        public void setResourceTemplates(List<McpSchema.ResourceTemplate> resourceTemplates) {
            this.resourceTemplates = resourceTemplates;
        }

        @Generated
        public void setPrompts(Map<String, AsyncPromptSpecification> prompts) {
            this.prompts = prompts;
        }

        @Generated
        public void setCompletions(Map<McpSchema.CompleteReference, AsyncCompletionSpecification> completions) {
            this.completions = completions;
        }

        @Generated
        public void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Async)) {
                return false;
            }
            Async other = (Async)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Implementation this$serverInfo = this.getServerInfo();
            McpSchema.Implementation other$serverInfo = other.getServerInfo();
            if (this$serverInfo == null ? other$serverInfo != null : !((Object)this$serverInfo).equals(other$serverInfo)) {
                return false;
            }
            McpSchema.ServerCapabilities this$serverCapabilities = this.getServerCapabilities();
            McpSchema.ServerCapabilities other$serverCapabilities = other.getServerCapabilities();
            if (this$serverCapabilities == null ? other$serverCapabilities != null : !((Object)this$serverCapabilities).equals(other$serverCapabilities)) {
                return false;
            }
            List<AsyncToolSpecification> this$tools = this.getTools();
            List<AsyncToolSpecification> other$tools = other.getTools();
            if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
                return false;
            }
            Map<String, AsyncResourceSpecification> this$resources = this.getResources();
            Map<String, AsyncResourceSpecification> other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            List<McpSchema.ResourceTemplate> this$resourceTemplates = this.getResourceTemplates();
            List<McpSchema.ResourceTemplate> other$resourceTemplates = other.getResourceTemplates();
            if (this$resourceTemplates == null ? other$resourceTemplates != null : !((Object)this$resourceTemplates).equals(other$resourceTemplates)) {
                return false;
            }
            Map<String, AsyncPromptSpecification> this$prompts = this.getPrompts();
            Map<String, AsyncPromptSpecification> other$prompts = other.getPrompts();
            if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
                return false;
            }
            Map<McpSchema.CompleteReference, AsyncCompletionSpecification> this$completions = this.getCompletions();
            Map<McpSchema.CompleteReference, AsyncCompletionSpecification> other$completions = other.getCompletions();
            if (this$completions == null ? other$completions != null : !((Object)this$completions).equals(other$completions)) {
                return false;
            }
            String this$instructions = this.getInstructions();
            String other$instructions = other.getInstructions();
            return !(this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Async;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Implementation $serverInfo = this.getServerInfo();
            result = result * 59 + ($serverInfo == null ? 43 : ((Object)$serverInfo).hashCode());
            McpSchema.ServerCapabilities $serverCapabilities = this.getServerCapabilities();
            result = result * 59 + ($serverCapabilities == null ? 43 : ((Object)$serverCapabilities).hashCode());
            List<AsyncToolSpecification> $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            Map<String, AsyncResourceSpecification> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            List<McpSchema.ResourceTemplate> $resourceTemplates = this.getResourceTemplates();
            result = result * 59 + ($resourceTemplates == null ? 43 : ((Object)$resourceTemplates).hashCode());
            Map<String, AsyncPromptSpecification> $prompts = this.getPrompts();
            result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
            Map<McpSchema.CompleteReference, AsyncCompletionSpecification> $completions = this.getCompletions();
            result = result * 59 + ($completions == null ? 43 : ((Object)$completions).hashCode());
            String $instructions = this.getInstructions();
            result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpStatelessServerFeatures.Async(serverInfo=" + this.getServerInfo() + ", serverCapabilities=" + this.getServerCapabilities() + ", tools=" + this.getTools() + ", resources=" + this.getResources() + ", resourceTemplates=" + this.getResourceTemplates() + ", prompts=" + this.getPrompts() + ", completions=" + this.getCompletions() + ", instructions=" + this.getInstructions() + ")";
        }

        @Generated
        public Async() {
        }
    }
}

