/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.context;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.PropertyHolder;
import org.noear.solon.expression.snel.ReflectionUtil;

public class StandardContext
implements Function<String, Object> {
    private final Object target;
    private final boolean isMap;
    private final Properties properties;
    private Object lastValue;

    public StandardContext(Object target) {
        this(target, null);
    }

    public StandardContext(Object target, Properties properties) {
        this.target = target;
        this.isMap = target instanceof Map;
        this.properties = properties == null && target instanceof Properties ? (Properties)target : properties;
    }

    public Properties properties() {
        return this.properties;
    }

    @Override
    public Object apply(String name) {
        if (this.target == null) {
            return null;
        }
        if ("root".equals(name)) {
            return this.target;
        }
        if ("this".equals(name)) {
            if (this.lastValue == null) {
                return this.target;
            }
            return this.lastValue;
        }
        if (this.isMap) {
            this.lastValue = ((Map)this.target).get(name);
        } else {
            PropertyHolder tmp = ReflectionUtil.getProperty(this.target.getClass(), name);
            try {
                this.lastValue = tmp.getValue(this.target);
            }
            catch (Throwable e) {
                throw new EvaluationException("Failed to access property: " + name, e);
            }
        }
        return this.lastValue;
    }
}

