/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameter;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springdoc.core.DelegatingMethodParameter;
import org.springdoc.core.ReturnTypeParser;
import org.springframework.core.MethodParameter;

class MethodParameterPojoExtractor {
    private static final List<Predicate<Class<?>>> SIMPLE_TYPE_PREDICATES = new ArrayList();
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet();

    private MethodParameterPojoExtractor() {
    }

    static Stream<MethodParameter> extractFrom(Class<?> clazz) {
        return MethodParameterPojoExtractor.extractFrom(clazz, "");
    }

    private static Stream<MethodParameter> extractFrom(Class<?> clazz, String fieldNamePrefix) {
        return MethodParameterPojoExtractor.allFieldsOf(clazz).stream().filter(field -> !field.getType().equals(clazz)).flatMap(f -> MethodParameterPojoExtractor.fromGetterOfField(clazz, f, fieldNamePrefix)).filter(Objects::nonNull);
    }

    private static Stream<MethodParameter> fromGetterOfField(Class<?> paramClass, Field field, String fieldNamePrefix) {
        if (MethodParameterPojoExtractor.isSimpleType(field.getType())) {
            return MethodParameterPojoExtractor.fromSimpleClass(paramClass, field, fieldNamePrefix);
        }
        if (field.getGenericType() instanceof TypeVariable) {
            return MethodParameterPojoExtractor.extractTypeParameter(paramClass, (TypeVariable)field.getGenericType(), field, fieldNamePrefix);
        }
        return MethodParameterPojoExtractor.extractFrom(field.getType(), fieldNamePrefix + field.getName() + ".");
    }

    private static Stream<MethodParameter> extractTypeParameter(Class<?> owningClass, TypeVariable<?> genericType, Field field, String fieldNamePrefix) {
        Type resolvedType = ReturnTypeParser.resolveType(genericType, owningClass);
        if (resolvedType instanceof Class && MethodParameterPojoExtractor.isSimpleType((Class)resolvedType)) {
            return MethodParameterPojoExtractor.fromSimpleClass(owningClass, field, fieldNamePrefix);
        }
        return Stream.empty();
    }

    private static Stream<MethodParameter> fromSimpleClass(Class<?> paramClass, Field field, String fieldNamePrefix) {
        Annotation[] fieldAnnotations = field.getDeclaredAnnotations();
        try {
            Parameter parameter = field.getAnnotation(Parameter.class);
            boolean isNotRequired = parameter == null || !parameter.required();
            Annotation[] finalFieldAnnotations = fieldAnnotations;
            return Stream.of(Introspector.getBeanInfo(paramClass).getPropertyDescriptors()).filter(d -> d.getName().equals(field.getName())).map(PropertyDescriptor::getReadMethod).filter(Objects::nonNull).map(method -> new MethodParameter(method, -1)).map(methodParameter -> DelegatingMethodParameter.changeContainingClass(methodParameter, paramClass)).map(param -> new DelegatingMethodParameter((MethodParameter)param, fieldNamePrefix + field.getName(), finalFieldAnnotations, true, isNotRequired));
        }
        catch (IntrospectionException e) {
            return Stream.of(new MethodParameter[0]);
        }
    }

    private static List<Field> allFieldsOf(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }

    static boolean isSimpleType(Class<?> clazz) {
        return SIMPLE_TYPE_PREDICATES.stream().anyMatch(p -> p.test(clazz)) || SIMPLE_TYPES.stream().anyMatch(c -> c.isAssignableFrom(clazz));
    }

    private static boolean isSwaggerPrimitiveType(Class<?> clazz) {
        PrimitiveType primitiveType = PrimitiveType.fromType(clazz);
        return primitiveType != null;
    }

    static void addSimpleTypePredicate(Predicate<Class<?>> predicate) {
        SIMPLE_TYPE_PREDICATES.add(predicate);
    }

    static void addSimpleTypes(Class<?> ... classes) {
        SIMPLE_TYPES.addAll(Arrays.asList(classes));
    }

    static void removeSimpleTypes(Class<?> ... classes) {
        SIMPLE_TYPES.removeAll(Arrays.asList(classes));
    }

    static {
        SIMPLE_TYPES.add(CharSequence.class);
        SIMPLE_TYPES.add(Optional.class);
        SIMPLE_TYPES.add(OptionalInt.class);
        SIMPLE_TYPES.add(OptionalLong.class);
        SIMPLE_TYPES.add(OptionalDouble.class);
        SIMPLE_TYPES.add(AtomicLong.class);
        SIMPLE_TYPES.add(AtomicInteger.class);
        SIMPLE_TYPES.add(Map.class);
        SIMPLE_TYPES.add(Iterable.class);
        SIMPLE_TYPES.add(Duration.class);
        SIMPLE_TYPES.add(LocalTime.class);
        SIMPLE_TYPE_PREDICATES.add(Class::isPrimitive);
        SIMPLE_TYPE_PREDICATES.add(Class::isEnum);
        SIMPLE_TYPE_PREDICATES.add(Class::isArray);
        SIMPLE_TYPE_PREDICATES.add(MethodParameterPojoExtractor::isSwaggerPrimitiveType);
    }
}

