/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.DefaultToolDefinition;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.execution.ToolExecutionException;
import org.springframework.util.StringUtils;

public class SyncMcpToolCallback
implements ToolCallback {
    private static final Logger logger = LoggerFactory.getLogger(SyncMcpToolCallback.class);
    private final McpSyncClient mcpClient;
    private final McpSchema.Tool tool;

    public SyncMcpToolCallback(McpSyncClient mcpClient, McpSchema.Tool tool) {
        this.mcpClient = mcpClient;
        this.tool = tool;
    }

    public ToolDefinition getToolDefinition() {
        return DefaultToolDefinition.builder().name(McpToolUtils.prefixedToolName(this.mcpClient.getClientInfo().name(), this.tool.name())).description(this.tool.description()).inputSchema(ModelOptionsUtils.toJsonString((Object)this.tool.inputSchema())).build();
    }

    public String call(String toolCallInput) {
        McpSchema.CallToolResult response;
        if (!StringUtils.hasText((String)toolCallInput)) {
            logger.warn("Tool call arguments are null or empty for MCP tool: {}. Using empty JSON object as default.", (Object)this.tool.name());
            toolCallInput = "{}";
        }
        Map arguments = ModelOptionsUtils.jsonToMap((String)toolCallInput);
        try {
            response = this.mcpClient.callTool(new McpSchema.CallToolRequest(this.tool.name(), arguments));
        }
        catch (Exception ex) {
            logger.error("Exception while tool calling: ", (Throwable)ex);
            throw new ToolExecutionException(this.getToolDefinition(), (Throwable)ex);
        }
        if (response.isError() != null && response.isError().booleanValue()) {
            logger.error("Error calling tool: {}", (Object)response.content());
            throw new ToolExecutionException(this.getToolDefinition(), (Throwable)new IllegalStateException("Error calling tool: " + String.valueOf(response.content())));
        }
        return ModelOptionsUtils.toJsonString((Object)response.content());
    }

    public String call(String toolArguments, ToolContext toolContext) {
        return this.call(toolArguments);
    }
}

