/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestHeaderSizeGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private static String ERROR = "Request Header/s size is larger than permissible limit. Request Header/s size is %s where permissible limit is %s";

    public RequestHeaderSizeGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                ServerHttpRequest request = exchange.getRequest();
                HttpHeaders headers = request.getHeaders();
                Long headerSizeInBytes = 0L;
                for (Map.Entry headerEntry : headers.entrySet()) {
                    List values = (List)headerEntry.getValue();
                    for (String value : values) {
                        headerSizeInBytes = headerSizeInBytes + Long.valueOf(value.getBytes().length);
                    }
                }
                if (headerSizeInBytes > config.getMaxSize().toBytes()) {
                    exchange.getResponse().setStatusCode(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                    exchange.getResponse().getHeaders().add("errorMessage", RequestHeaderSizeGatewayFilterFactory.getErrorMessage(headerSizeInBytes, config.getMaxSize()));
                    return exchange.getResponse().setComplete();
                }
                return chain.filter(exchange);
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RequestHeaderSizeGatewayFilterFactory.this).append("max", (Object)config.getMaxSize()).toString();
            }
        };
    }

    private static String getErrorMessage(Long currentRequestSize, DataSize maxSize) {
        return String.format(ERROR, DataSize.of((long)currentRequestSize, (DataUnit)DataUnit.BYTES), maxSize);
    }

    public static class Config {
        private DataSize maxSize = DataSize.ofBytes((long)16000L);

        public DataSize getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(DataSize maxSize) {
            this.maxSize = maxSize;
        }
    }
}

