/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactivePartTreeCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.ReactiveStringBasedCouchbaseQuery;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.SimpleReactiveCouchbaseRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ReactiveCouchbaseRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private final ReactiveRepositoryOperationsMapping couchbaseOperationsMapping;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;

    public ReactiveCouchbaseRepositoryFactory(ReactiveRepositoryOperationsMapping couchbaseOperationsMapping) {
        Assert.notNull((Object)couchbaseOperationsMapping, (String)"couchbaseOperationsMapping");
        this.couchbaseOperationsMapping = couchbaseOperationsMapping;
        this.crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
        this.mappingContext = this.couchbaseOperationsMapping.getMappingContext();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    public <T, ID> CouchbaseEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingCouchbaseEntityInformation(entity);
    }

    protected final Object getTargetRepository(RepositoryInformation metadata) {
        ReactiveCouchbaseOperations couchbaseOperations = this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        SimpleReactiveCouchbaseRepository repository = (SimpleReactiveCouchbaseRepository)this.getTargetRepositoryViaReflection(metadata, new Object[]{entityInformation, couchbaseOperations, metadata.getRepositoryInterface()});
        repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        return repository;
    }

    protected final Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleReactiveCouchbaseRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider contextProvider) {
        return Optional.of(new CouchbaseQueryLookupStrategy(contextProvider));
    }

    private class CouchbaseQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        public CouchbaseQueryLookupStrategy(QueryMethodEvaluationContextProvider evaluationContextProvider) {
            this.evaluationContextProvider = evaluationContextProvider;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ReactiveCouchbaseOperations couchbaseOperations = ReactiveCouchbaseRepositoryFactory.this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
            ReactiveCouchbaseQueryMethod queryMethod = new ReactiveCouchbaseQueryMethod(method, metadata, factory, ReactiveCouchbaseRepositoryFactory.this.mappingContext);
            if (queryMethod.hasN1qlAnnotation()) {
                return new ReactiveStringBasedCouchbaseQuery(queryMethod, couchbaseOperations, new SpelExpressionParser(), this.evaluationContextProvider, namedQueries);
            }
            return new ReactivePartTreeCouchbaseQuery(queryMethod, couchbaseOperations, new SpelExpressionParser(), this.evaluationContextProvider);
        }
    }
}

