/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import java.util.Collection;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableUpsertByIdOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveUpsertByIdOperationSupport;
import org.springframework.util.Assert;

public class ExecutableUpsertByIdOperationSupport
implements ExecutableUpsertByIdOperation {
    private final CouchbaseTemplate template;

    public ExecutableUpsertByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableUpsertByIdOperation.ExecutableUpsertById<T> upsertById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableUpsertByIdSupport<T>(this.template, domainType, null, null, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null);
    }

    static class ExecutableUpsertByIdSupport<T>
    implements ExecutableUpsertByIdOperation.ExecutableUpsertById<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final UpsertOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveUpsertByIdOperationSupport.ReactiveUpsertByIdSupport<T> reactiveSupport;

        ExecutableUpsertByIdSupport(CouchbaseTemplate template, Class<T> domainType, String scope, String collection, UpsertOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.reactiveSupport = new ReactiveUpsertByIdOperationSupport.ReactiveUpsertByIdSupport<T>(template.reactive(), domainType, scope, collection, options, persistTo, replicateTo, durabilityLevel, expiry, new NonReactiveSupportWrapper(template.support()));
        }

        @Override
        public T one(T object) {
            return (T)this.reactiveSupport.one(object).block();
        }

        @Override
        public Collection<? extends T> all(Collection<? extends T> objects) {
            return (Collection)this.reactiveSupport.all(objects).collectList().block();
        }

        @Override
        public ExecutableUpsertByIdOperation.TerminatingUpsertById<T> withOptions(UpsertOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableUpsertByIdOperation.UpsertByIdInCollection<T> inScope(String scope) {
            return new ExecutableUpsertByIdSupport<T>(this.template, this.domainType, scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableUpsertByIdOperation.UpsertByIdWithOptions<T> inCollection(String collection) {
            return new ExecutableUpsertByIdSupport<T>(this.template, this.domainType, this.scope, collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableUpsertByIdOperation.UpsertByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableUpsertByIdOperation.UpsertByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry);
        }

        @Override
        public ExecutableUpsertByIdOperation.UpsertByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ExecutableUpsertByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry);
        }
    }
}

