/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.sql.SQLType;
import org.springframework.data.relational.core.dialect.ArrayColumns;

public interface JdbcArrayColumns
extends ArrayColumns {
    default public Class<?> getArrayType(Class<?> userType) {
        Class<?> componentType = userType;
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    default public String getArrayTypeName(SQLType jdbcType) {
        return jdbcType.getName();
    }

    public static enum DefaultSupport implements JdbcArrayColumns
    {
        INSTANCE;


        public boolean isSupported() {
            return true;
        }

        @Override
        public String getArrayTypeName(SQLType jdbcType) {
            return jdbcType.getName();
        }
    }

    public static enum Unsupported implements JdbcArrayColumns
    {
        INSTANCE;


        public boolean isSupported() {
            return false;
        }

        @Override
        public String getArrayTypeName(SQLType jdbcType) {
            throw new UnsupportedOperationException("Array types not supported");
        }
    }
}

