/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class JpaQueryTransformerSupport {
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile(".*((?![._])[\\p{Punct}|\\s])");
    private static final String UNSAFE_PROPERTY_REFERENCE = "Sort expression '%s' must only contain property references or aliases used in the select clause; If you really want to use something other than that for sorting, please use JpaSort.unsafe(\u2026)";
    private Set<String> projectionAliases = new HashSet<String>();

    JpaQueryTransformerSupport() {
    }

    void registerAlias(String token) {
        this.projectionAliases.add(token);
    }

    List<JpaQueryParsingToken> generateOrderByArguments(String primaryFromAlias, Sort sort) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        sort.forEach(order -> {
            this.checkSortExpression((Sort.Order)order);
            if (order.isIgnoreCase()) {
                tokens.add(JpaQueryParsingToken.TOKEN_LOWER_FUNC);
            }
            tokens.add(new JpaQueryParsingToken(() -> this.generateOrderByArgument(primaryFromAlias, (Sort.Order)order)));
            if (order.isIgnoreCase()) {
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
            }
            tokens.add(order.isDescending() ? JpaQueryParsingToken.TOKEN_DESC : JpaQueryParsingToken.TOKEN_ASC);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    /*
     * WARNING - void declaration
     */
    private void checkSortExpression(Sort.Order order) {
        Sort.Order order2 = order;
        if (order2 instanceof JpaSort.JpaOrder) {
            void jpaOrder;
            JpaSort.JpaOrder jpaOrder2 = (JpaSort.JpaOrder)order2;
            JpaSort.JpaOrder cfr_ignored_0 = (JpaSort.JpaOrder)order2;
            if (jpaOrder.isUnsafe()) {
                return;
            }
        }
        if (PUNCTUATION_PATTERN.matcher(order.getProperty()).find()) {
            throw new InvalidDataAccessApiUsageException(String.format(UNSAFE_PROPERTY_REFERENCE, order));
        }
    }

    private String generateOrderByArgument(@Nullable String primaryFromAlias, Sort.Order order) {
        if (this.shouldPrefixWithAlias(order, primaryFromAlias)) {
            return primaryFromAlias + "." + order.getProperty();
        }
        return order.getProperty();
    }

    private boolean shouldPrefixWithAlias(Sort.Order order, String primaryFromAlias) {
        if (ObjectUtils.isEmpty((Object)primaryFromAlias)) {
            return false;
        }
        if (order.getProperty().contains("(")) {
            return false;
        }
        if (order.getProperty().startsWith(primaryFromAlias + ".")) {
            return false;
        }
        if (this.projectionAliases.contains(order.getProperty())) {
            return false;
        }
        return !this.projectionAliases.stream().anyMatch(alias -> order.getProperty().startsWith(alias + "."));
    }
}

