/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.util.json.EvaluationContextExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

public class ParameterBindingContext {
    private final ValueProvider valueProvider;
    private final ValueExpressionEvaluator expressionEvaluator;

    @Deprecated(since="4.4.0")
    public ParameterBindingContext(ValueProvider valueProvider, SpelExpressionParser expressionParser, EvaluationContext evaluationContext) {
        this(valueProvider, (ExpressionParser)expressionParser, () -> evaluationContext);
    }

    @Deprecated(since="4.4.0")
    public ParameterBindingContext(ValueProvider valueProvider, SpELExpressionEvaluator expressionEvaluator) {
        this(valueProvider, (ValueExpressionEvaluator)expressionEvaluator);
    }

    public ParameterBindingContext(ValueProvider valueProvider, ExpressionParser expressionParser, final Supplier<EvaluationContext> evaluationContext) {
        this(valueProvider, new EvaluationContextExpressionEvaluator(valueProvider, ParameterBindingContext.unwrap(expressionParser)){

            @Override
            public EvaluationContext getEvaluationContext(String expressionString) {
                return (EvaluationContext)evaluationContext.get();
            }
        });
    }

    private static ExpressionParser unwrap(final ExpressionParser expressionParser) {
        return new ExpressionParser(){

            public Expression parseExpression(String expressionString) throws ParseException {
                return expressionParser.parseExpression(ParameterBindingContext.unwrap(expressionString));
            }

            public Expression parseExpression(String expressionString, ParserContext context) throws ParseException {
                return expressionParser.parseExpression(ParameterBindingContext.unwrap(expressionString), context);
            }
        };
    }

    private static String unwrap(String expressionString) {
        return expressionString.startsWith("#{") && expressionString.endsWith("}") ? expressionString.substring(2, expressionString.length() - 1).trim() : expressionString;
    }

    public ParameterBindingContext(ValueProvider valueProvider, ValueExpressionEvaluator expressionEvaluator) {
        this.valueProvider = valueProvider;
        this.expressionEvaluator = expressionEvaluator;
    }

    public static ParameterBindingContext forExpressions(ValueProvider valueProvider, ExpressionParser expressionParser, final Function<ExpressionDependencies, EvaluationContext> contextFunction) {
        return new ParameterBindingContext(valueProvider, new EvaluationContextExpressionEvaluator(valueProvider, expressionParser){

            @Override
            public EvaluationContext getEvaluationContext(String expressionString) {
                Expression expression = this.getParsedExpression(expressionString);
                ExpressionDependencies dependencies = ExpressionDependencies.discover((Expression)expression);
                return (EvaluationContext)contextFunction.apply(dependencies);
            }
        });
    }

    public static ParameterBindingContext forExpressions(ValueProvider valueProvider, ValueExpressionEvaluator expressionEvaluator) {
        return new ParameterBindingContext(valueProvider, expressionEvaluator);
    }

    @Nullable
    public Object bindableValueForIndex(int index) {
        return this.valueProvider.getBindableValue(index);
    }

    @Nullable
    public Object evaluateExpression(String expressionString) {
        return this.expressionEvaluator.evaluate(expressionString);
    }

    @Nullable
    public Object evaluateExpression(String expressionString, Map<String, Object> variables) {
        ValueExpressionEvaluator valueExpressionEvaluator = this.expressionEvaluator;
        if (valueExpressionEvaluator instanceof EvaluationContextExpressionEvaluator) {
            EvaluationContextExpressionEvaluator expressionEvaluator = (EvaluationContextExpressionEvaluator)valueExpressionEvaluator;
            return expressionEvaluator.evaluateExpression(expressionString, variables);
        }
        return this.expressionEvaluator.evaluate(expressionString);
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }
}

