/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.PropertyValueTransformer;
import org.neo4j.ogm.cypher.function.FilterFunction;

final class NativeIdFilterFunction
implements FilterFunction<Object> {
    protected static final String PARAMETER_NAME = "idProperty";
    private final ComparisonOperator operator;
    private final Object value;
    private Filter filter;

    NativeIdFilterFunction(ComparisonOperator operator, Object value) {
        this.operator = operator;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String expression(String nodeIdentifier, String filteredProperty, UnaryOperator<String> createUniqueParameterName) {
        switch (this.operator) {
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case IN: {
                return String.format("id(%s) %s $`%s` ", nodeIdentifier, this.operator.getValue(), createUniqueParameterName.apply(PARAMETER_NAME));
            }
        }
        throw new IllegalArgumentException("Unsupported comparision operator for an ID attribute.");
    }

    public Map<String, Object> parameters(UnaryOperator<String> createUniqueParameterName, PropertyValueTransformer valueTransformer) {
        Map<String, Object> map = Collections.emptyMap();
        if (EnumSet.of(ComparisonOperator.EQUALS, new ComparisonOperator[]{ComparisonOperator.GREATER_THAN, ComparisonOperator.GREATER_THAN_EQUAL, ComparisonOperator.LESS_THAN, ComparisonOperator.LESS_THAN_EQUAL, ComparisonOperator.IN}).contains(this.operator)) {
            map = Collections.singletonMap(createUniqueParameterName.apply(PARAMETER_NAME), valueTransformer.transformPropertyValue(this.value));
        }
        return map;
    }

    public Map<String, Object> parameters() {
        throw new UnsupportedOperationException("This method has been kept here for backward compatiblity and should never be called.");
    }

    public String expression(String s) {
        throw new UnsupportedOperationException("This method has been kept here for backward compatiblity and should never be called.");
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

