/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.session.Session;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.util.PagingAndSortingUtils;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleNeo4jRepository<T, ID extends Serializable>
implements Neo4jRepository<T, ID> {
    private static final int DEFAULT_QUERY_DEPTH = 1;
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null!";
    private final Class<T> clazz;
    private final Session session;

    public SimpleNeo4jRepository(Class<T> domainClass, Session session) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull((Object)session, (String)"Session must not be null!");
        this.clazz = domainClass;
        this.session = session;
    }

    @Transactional
    public <S extends T> S save(S entity) {
        this.session.save(entity);
        return entity;
    }

    @Transactional
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        this.session.save(entities);
        return entities;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        return Optional.ofNullable(this.session.load(this.clazz, id));
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public long count() {
        return this.session.countEntitiesOfType(this.clazz);
    }

    @Transactional
    public void deleteById(ID id) {
        this.findById(id).ifPresent(arg_0 -> ((Session)this.session).delete(arg_0));
    }

    @Transactional
    public void delete(T t) {
        this.session.delete(t);
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> ts) {
        for (T t : ts) {
            this.session.delete(t);
        }
    }

    @Transactional
    public void deleteAll() {
        this.session.deleteAll(this.clazz);
    }

    @Override
    @Transactional
    public <S extends T> S save(S s, int depth) {
        this.session.save(s, depth);
        return s;
    }

    @Override
    @Transactional
    public <S extends T> Iterable<S> save(Iterable<S> ses, int depth) {
        this.session.save(ses, depth);
        return ses;
    }

    @Override
    public Optional<T> findById(ID id, int depth) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        return Optional.ofNullable(this.session.load(this.clazz, id, depth));
    }

    @Override
    public Iterable<T> findAll() {
        return this.findAll(1);
    }

    @Override
    public Iterable<T> findAll(int depth) {
        return this.session.loadAll(this.clazz, depth);
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> longs) {
        return this.findAllById(longs, 1);
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> ids, int depth) {
        return this.session.loadAll(this.clazz, (Collection)ids, depth);
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        return this.findAll(sort, 1);
    }

    @Override
    public Iterable<T> findAll(Sort sort, int depth) {
        return this.session.loadAll(this.clazz, PagingAndSortingUtils.convert(sort), depth);
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> ids, Sort sort) {
        return this.findAllById(ids, sort, 1);
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> ids, Sort sort, int depth) {
        return this.session.loadAll(this.clazz, (Collection)ids, PagingAndSortingUtils.convert(sort), depth);
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return this.findAll(pageable, 1);
    }

    @Override
    public Page<T> findAll(Pageable pageable, int depth) {
        Pagination pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize());
        Collection data = this.session.loadAll(this.clazz, PagingAndSortingUtils.convert(pageable.getSort()), pagination, depth);
        return PageableExecutionUtils.getPage(new ArrayList(data), (Pageable)pageable, () -> this.session.countEntitiesOfType(this.clazz));
    }
}

