/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.lang.Nullable;

abstract class FluentQuerySupport<R> {
    protected final Class<R> resultType;
    protected final Sort sort;
    @Nullable
    protected final Set<String> properties;

    FluentQuerySupport(Class<R> resultType, Sort sort, @Nullable Collection<String> properties) {
        this.resultType = resultType;
        this.sort = sort;
        this.properties = properties != null ? new HashSet<String>(properties) : null;
    }

    final Predicate<PropertyFilter.RelaxedPropertyPath> createIncludedFieldsPredicate() {
        if (this.properties == null) {
            return path -> true;
        }
        return path -> this.properties.contains(path.toDotPath());
    }

    final Collection<String> mergeProperties(Collection<String> additionalProperties) {
        HashSet<String> newProperties = new HashSet<String>();
        if (this.properties != null) {
            newProperties.addAll(this.properties);
        }
        newProperties.addAll(additionalProperties);
        return Collections.unmodifiableCollection(newProperties);
    }
}

