/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.reactive.RxQueryRunner;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.NamedParameters;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.ReactiveDatabaseSelectionProvider;
import org.springframework.data.neo4j.core.ReactiveNeo4jClient;
import org.springframework.data.neo4j.core.ReactiveUserSelectionProvider;
import org.springframework.data.neo4j.core.ResultSummaries;
import org.springframework.data.neo4j.core.SingleValueMappingFunction;
import org.springframework.data.neo4j.core.UserSelection;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jTransactionManager;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class DefaultReactiveNeo4jClient
implements ReactiveNeo4jClient {
    private final Driver driver;
    private final TypeSystem typeSystem;
    @Nullable
    private final ReactiveDatabaseSelectionProvider databaseSelectionProvider;
    @Nullable
    private final ReactiveUserSelectionProvider userSelectionProvider;
    private final ConversionService conversionService;
    private final Neo4jPersistenceExceptionTranslator persistenceExceptionTranslator = new Neo4jPersistenceExceptionTranslator();
    private final Set<Bookmark> bookmarks = new HashSet<Bookmark>();
    private final ReentrantReadWriteLock bookmarksLock = new ReentrantReadWriteLock();

    DefaultReactiveNeo4jClient(ReactiveNeo4jClient.Builder builder) {
        this.driver = builder.driver;
        this.typeSystem = this.driver.defaultTypeSystem();
        this.databaseSelectionProvider = builder.databaseSelectionProvider;
        this.userSelectionProvider = builder.impersonatedUserProvider;
        this.conversionService = new DefaultConversionService();
        new Neo4jConversions().registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public Mono<RxQueryRunner> getQueryRunner(Mono<DatabaseSelection> databaseSelection, Mono<UserSelection> userSelection) {
        return databaseSelection.zipWith(userSelection).flatMap(targetDatabaseAndUser -> ReactiveNeo4jTransactionManager.retrieveReactiveTransaction(this.driver, (DatabaseSelection)targetDatabaseAndUser.getT1(), (UserSelection)targetDatabaseAndUser.getT2()).map(RxQueryRunner.class::cast).zipWith(Mono.just(Collections.emptySet())).switchIfEmpty(Mono.fromSupplier(() -> {
            ReentrantReadWriteLock.ReadLock lock = this.bookmarksLock.readLock();
            try {
                lock.lock();
                HashSet<Bookmark> lastBookmarks = new HashSet<Bookmark>(this.bookmarks);
                Tuple2 tuple2 = Tuples.of((Object)this.driver.rxSession(Neo4jTransactionUtils.sessionConfig(false, lastBookmarks, (DatabaseSelection)targetDatabaseAndUser.getT1(), (UserSelection)targetDatabaseAndUser.getT2())), lastBookmarks);
                return tuple2;
            }
            finally {
                lock.unlock();
            }
        }))).map(t -> new DelegatingQueryRunner((RxQueryRunner)t.getT1(), (Collection)t.getT2(), (usedBookmarks, newBookmark) -> {
            ReentrantReadWriteLock.WriteLock lock = this.bookmarksLock.writeLock();
            try {
                lock.lock();
                this.bookmarks.removeAll((Collection<?>)usedBookmarks);
                this.bookmarks.add((Bookmark)newBookmark);
            }
            finally {
                lock.unlock();
            }
        }));
    }

    <T> Mono<T> doInQueryRunnerForMono(Mono<DatabaseSelection> databaseSelection, Mono<UserSelection> userSelection, Function<RxQueryRunner, Mono<T>> func) {
        return Mono.usingWhen(this.getQueryRunner(databaseSelection, userSelection), func, runner -> ((DelegatingQueryRunner)runner).close());
    }

    <T> Flux<T> doInStatementRunnerForFlux(Mono<DatabaseSelection> databaseSelection, Mono<UserSelection> userSelection, Function<RxQueryRunner, Flux<T>> func) {
        return Flux.usingWhen(this.getQueryRunner(databaseSelection, userSelection), func, runner -> ((DelegatingQueryRunner)runner).close());
    }

    @Override
    public ReactiveNeo4jClient.UnboundRunnableSpec query(String cypher) {
        return this.query(() -> cypher);
    }

    @Override
    public ReactiveNeo4jClient.UnboundRunnableSpec query(Supplier<String> cypherSupplier) {
        return new DefaultRunnableSpec(cypherSupplier);
    }

    @Override
    public <T> ReactiveNeo4jClient.OngoingDelegation<T> delegateTo(Function<RxQueryRunner, Mono<T>> callback) {
        return new DefaultRunnableDelegation<T>(callback);
    }

    @Override
    @Nullable
    public ReactiveDatabaseSelectionProvider getDatabaseSelectionProvider() {
        return this.databaseSelectionProvider;
    }

    private Mono<DatabaseSelection> resolveTargetDatabaseName(@Nullable String parameterTargetDatabase) {
        String value = Neo4jClient.verifyDatabaseName(parameterTargetDatabase);
        if (value != null) {
            return Mono.just((Object)DatabaseSelection.byName(value));
        }
        if (this.databaseSelectionProvider != null) {
            return this.databaseSelectionProvider.getDatabaseSelection();
        }
        return ReactiveDatabaseSelectionProvider.getDefaultSelectionProvider().getDatabaseSelection();
    }

    private Mono<UserSelection> resolveUser(@Nullable String userName) {
        if (StringUtils.hasText((String)userName)) {
            return Mono.just((Object)UserSelection.impersonate(userName));
        }
        if (this.userSelectionProvider != null) {
            return this.userSelectionProvider.getUserSelection();
        }
        return ReactiveUserSelectionProvider.getDefaultSelectionProvider().getUserSelection();
    }

    private RuntimeException potentiallyConvertRuntimeException(RuntimeException ex) {
        DataAccessException resolved = this.persistenceExceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    class DefaultRunnableDelegation<T>
    implements ReactiveNeo4jClient.RunnableDelegation<T>,
    ReactiveNeo4jClient.OngoingDelegation<T> {
        private final Function<RxQueryRunner, Mono<T>> callback;
        private Mono<DatabaseSelection> databaseSelection;
        private Mono<UserSelection> userSelection;

        DefaultRunnableDelegation(Function<RxQueryRunner, Mono<T>> callback) {
            this.callback = callback;
            this.databaseSelection = DefaultReactiveNeo4jClient.this.resolveTargetDatabaseName(null);
            this.userSelection = DefaultReactiveNeo4jClient.this.resolveUser(null);
        }

        @Override
        public ReactiveNeo4jClient.RunnableDelegation<T> in(@Nullable String targetDatabase) {
            this.databaseSelection = DefaultReactiveNeo4jClient.this.resolveTargetDatabaseName(targetDatabase);
            return this;
        }

        @Override
        public Mono<T> run() {
            return DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(this.databaseSelection, this.userSelection, this.callback);
        }
    }

    class DefaultRecordFetchSpec<T>
    implements ReactiveNeo4jClient.RecordFetchSpec<T>,
    ReactiveNeo4jClient.MappingSpec<T> {
        private final Mono<DatabaseSelection> databaseSelection;
        private final Mono<UserSelection> userSelection;
        private final Supplier<String> cypherSupplier;
        private final NamedParameters parameters;
        private BiFunction<TypeSystem, Record, T> mappingFunction;

        DefaultRecordFetchSpec(Mono<DatabaseSelection> databaseSelection, Mono<UserSelection> userSelection, Supplier<String> cypherSupplier, @Nullable NamedParameters parameters, BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.databaseSelection = databaseSelection;
            this.userSelection = userSelection;
            this.cypherSupplier = cypherSupplier;
            this.parameters = parameters;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public ReactiveNeo4jClient.RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.mappingFunction = mappingFunction;
            return this;
        }

        Mono<Tuple2<String, Map<String, Object>>> prepareStatement() {
            if (ReactiveNeo4jClient.cypherLog.isDebugEnabled()) {
                String cypher = this.cypherSupplier.get();
                ReactiveNeo4jClient.cypherLog.debug(() -> String.format("Executing:%s%s", System.lineSeparator(), cypher));
                if (ReactiveNeo4jClient.cypherLog.isTraceEnabled() && !this.parameters.isEmpty()) {
                    ReactiveNeo4jClient.cypherLog.trace(() -> String.format("with parameters:%s%s", System.lineSeparator(), this.parameters));
                }
            }
            return Mono.fromSupplier(this.cypherSupplier).zipWith(Mono.just(this.parameters.get()));
        }

        Flux<T> executeWith(Tuple2<String, Map<String, Object>> t, RxQueryRunner runner) {
            return Flux.usingWhen((Publisher)Flux.just((Object)runner.run((String)t.getT1(), (Map)t.getT2())), result -> Flux.from((Publisher)result.records()).mapNotNull(r -> this.mappingFunction.apply(DefaultReactiveNeo4jClient.this.typeSystem, (Record)r)), result -> Flux.from((Publisher)result.consume()).doOnNext(ResultSummaries::process));
        }

        @Override
        public Mono<T> one() {
            return DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(this.databaseSelection, this.userSelection, runner -> this.prepareStatement().flatMapMany(t -> this.executeWith((Tuple2<String, Map<String, Object>>)t, (RxQueryRunner)runner)).singleOrEmpty()).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }

        @Override
        public Mono<T> first() {
            return DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(this.databaseSelection, this.userSelection, runner -> this.prepareStatement().flatMapMany(t -> this.executeWith((Tuple2<String, Map<String, Object>>)t, (RxQueryRunner)runner)).next()).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }

        @Override
        public Flux<T> all() {
            return DefaultReactiveNeo4jClient.this.doInStatementRunnerForFlux(this.databaseSelection, this.userSelection, runner -> this.prepareStatement().flatMapMany(t -> this.executeWith((Tuple2<String, Map<String, Object>>)t, (RxQueryRunner)runner))).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }

        Mono<ResultSummary> run() {
            return DefaultReactiveNeo4jClient.this.doInQueryRunnerForMono(this.databaseSelection, this.userSelection, runner -> this.prepareStatement().flatMap(t -> {
                RxResult rxResult = runner.run((String)t.getT1(), (Map)t.getT2());
                return Flux.from((Publisher)rxResult.records()).then(Mono.from((Publisher)rxResult.consume()).map(ResultSummaries::process));
            })).onErrorMap(RuntimeException.class, x$0 -> DefaultReactiveNeo4jClient.this.potentiallyConvertRuntimeException(x$0));
        }
    }

    class DefaultRunnableSpec
    implements ReactiveNeo4jClient.UnboundRunnableSpec,
    ReactiveNeo4jClient.RunnableSpecBoundToDatabaseAndUser {
        private final Supplier<String> cypherSupplier;
        private Mono<DatabaseSelection> databaseSelection;
        private Mono<UserSelection> userSelection;
        private final NamedParameters parameters = new NamedParameters();

        DefaultRunnableSpec(Supplier<String> cypherSupplier) {
            this.databaseSelection = DefaultReactiveNeo4jClient.this.resolveTargetDatabaseName(null);
            this.userSelection = DefaultReactiveNeo4jClient.this.resolveUser(null);
            this.cypherSupplier = cypherSupplier;
        }

        @Override
        public ReactiveNeo4jClient.RunnableSpecBoundToDatabase in(String targetDatabase) {
            this.databaseSelection = DefaultReactiveNeo4jClient.this.resolveTargetDatabaseName(targetDatabase);
            return new DefaultRunnableSpecBoundToDatabase();
        }

        @Override
        public ReactiveNeo4jClient.RunnableSpecBoundToUser asUser(String asUser) {
            this.userSelection = DefaultReactiveNeo4jClient.this.resolveUser(asUser);
            return new DefaultRunnableSpecBoundToUser();
        }

        @Override
        public <T> Neo4jClient.OngoingBindSpec<T, ReactiveNeo4jClient.RunnableSpec> bind(T value) {
            return new DefaultOngoingBindSpec<T>(value);
        }

        @Override
        public ReactiveNeo4jClient.RunnableSpec bindAll(Map<String, Object> newParameters) {
            this.parameters.addAll(newParameters);
            return this;
        }

        public <R> ReactiveNeo4jClient.MappingSpec<R> fetchAs(Class<R> targetClass) {
            return new DefaultRecordFetchSpec(this.databaseSelection, this.userSelection, this.cypherSupplier, this.parameters, new SingleValueMappingFunction<R>(DefaultReactiveNeo4jClient.this.conversionService, targetClass));
        }

        @Override
        public ReactiveNeo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
            return new DefaultRecordFetchSpec<Map<String, Object>>(this.databaseSelection, this.userSelection, this.cypherSupplier, this.parameters, (t, r) -> r.asMap());
        }

        @Override
        public Mono<ResultSummary> run() {
            return new DefaultRecordFetchSpec(this.databaseSelection, this.userSelection, this.cypherSupplier, this.parameters, null).run();
        }

        class DefaultRunnableSpecBoundToUser
        implements ReactiveNeo4jClient.RunnableSpecBoundToUser {
            DefaultRunnableSpecBoundToUser() {
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpecBoundToDatabaseAndUser in(String aDatabase) {
                DefaultRunnableSpec.this.databaseSelection = DefaultReactiveNeo4jClient.this.resolveTargetDatabaseName(aDatabase);
                return DefaultRunnableSpec.this;
            }

            @Override
            public <T> ReactiveNeo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
                return DefaultRunnableSpec.this.fetchAs(targetClass);
            }

            @Override
            public ReactiveNeo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
                return DefaultRunnableSpec.this.fetch();
            }

            @Override
            public Mono<ResultSummary> run() {
                return DefaultRunnableSpec.this.run();
            }

            @Override
            public <T> Neo4jClient.OngoingBindSpec<T, ReactiveNeo4jClient.RunnableSpec> bind(T value) {
                return DefaultRunnableSpec.this.bind(value);
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpec bindAll(Map<String, Object> newParameters) {
                return DefaultRunnableSpec.this.bindAll((Map)newParameters);
            }
        }

        class DefaultRunnableSpecBoundToDatabase
        implements ReactiveNeo4jClient.RunnableSpecBoundToDatabase {
            DefaultRunnableSpecBoundToDatabase() {
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpecBoundToDatabaseAndUser asUser(String aUser) {
                DefaultRunnableSpec.this.userSelection = DefaultReactiveNeo4jClient.this.resolveUser(aUser);
                return DefaultRunnableSpec.this;
            }

            @Override
            public <T> ReactiveNeo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
                return DefaultRunnableSpec.this.fetchAs(targetClass);
            }

            @Override
            public ReactiveNeo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
                return DefaultRunnableSpec.this.fetch();
            }

            @Override
            public Mono<ResultSummary> run() {
                return DefaultRunnableSpec.this.run();
            }

            @Override
            public <T> Neo4jClient.OngoingBindSpec<T, ReactiveNeo4jClient.RunnableSpec> bind(T value) {
                return DefaultRunnableSpec.this.bind(value);
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpec bindAll(Map<String, Object> newParameters) {
                return DefaultRunnableSpec.this.bindAll((Map)newParameters);
            }
        }

        class DefaultOngoingBindSpec<T>
        implements Neo4jClient.OngoingBindSpec<T, ReactiveNeo4jClient.RunnableSpec> {
            @Nullable
            private final T value;

            DefaultOngoingBindSpec(T value) {
                this.value = value;
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpec to(String name) {
                DefaultRunnableSpec.this.parameters.add(name, this.value);
                return DefaultRunnableSpec.this;
            }

            @Override
            public ReactiveNeo4jClient.RunnableSpec with(Function<T, Map<String, Object>> binder) {
                Assert.notNull(binder, (String)"Binder is required.");
                return DefaultRunnableSpec.this.bindAll((Map)binder.apply(this.value));
            }
        }
    }

    private static class DelegatingQueryRunner
    implements RxQueryRunner {
        private final RxQueryRunner delegate;
        private final Collection<Bookmark> usedBookmarks;
        private final BiConsumer<Collection<Bookmark>, Bookmark> newBookmarkConsumer;

        private DelegatingQueryRunner(RxQueryRunner delegate, Collection<Bookmark> lastBookmarks, BiConsumer<Collection<Bookmark>, Bookmark> newBookmarkConsumer) {
            this.delegate = delegate;
            this.usedBookmarks = lastBookmarks;
            this.newBookmarkConsumer = newBookmarkConsumer;
        }

        Mono<Void> close() {
            if (this.delegate instanceof RxSession) {
                RxSession session = (RxSession)this.delegate;
                return Mono.fromDirect((Publisher)session.close()).then().doOnSuccess(signal -> this.newBookmarkConsumer.accept(this.usedBookmarks, session.lastBookmark()));
            }
            return Mono.empty();
        }

        public RxResult run(String query, Value parameters) {
            return this.delegate.run(query, parameters);
        }

        public RxResult run(String query, Map<String, Object> parameters) {
            return this.delegate.run(query, parameters);
        }

        public RxResult run(String query, Record parameters) {
            return this.delegate.run(query, parameters);
        }

        public RxResult run(String query) {
            return this.delegate.run(query);
        }

        public RxResult run(Query query) {
            return this.delegate.run(query);
        }
    }
}

