/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.1.2")
public final class EntityFromDtoInstantiatingConverter<T>
implements Converter<Object, T> {
    private final Class<?> targetEntityType;
    private final Neo4jMappingContext context;
    private final Map<Class<?>, EntityFromDtoInstantiatingConverter<?>> converterCache = new ConcurrentHashMap();

    public EntityFromDtoInstantiatingConverter(Class<T> entityType, Neo4jMappingContext context) {
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Assert.notNull((Object)context, (String)"MappingContext must not be null!");
        this.targetEntityType = entityType;
        this.context = context;
    }

    public T convert(Object dtoInstance) {
        if (dtoInstance == null) {
            return null;
        }
        PersistentEntity sourceEntity = (PersistentEntity)this.context.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(dtoInstance.getClass())).get();
        PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(dtoInstance);
        MutablePersistentEntity targetEntity = this.context.getPersistentEntity(this.targetEntityType);
        InstanceCreatorMetadata creator = targetEntity.getInstanceCreatorMetadata();
        Object entity = this.context.getInstantiatorFor((PersistentEntity<?, ?>)targetEntity).createInstance((PersistentEntity)targetEntity, new ParameterValueProvider((PersistentEntity)targetEntity, sourceEntity, sourceAccessor){
            final /* synthetic */ PersistentEntity val$targetEntity;
            final /* synthetic */ PersistentEntity val$sourceEntity;
            final /* synthetic */ PersistentPropertyAccessor val$sourceAccessor;
            {
                this.val$targetEntity = persistentEntity;
                this.val$sourceEntity = persistentEntity2;
                this.val$sourceAccessor = persistentPropertyAccessor;
            }

            public Object getParameterValue(Parameter parameter) {
                PersistentProperty targetProperty = this.val$targetEntity.getPersistentProperty(parameter.getName());
                if (targetProperty == null) {
                    throw new MappingException("Cannot map constructor parameter " + parameter.getName() + " to a property of class " + EntityFromDtoInstantiatingConverter.this.targetEntityType);
                }
                return EntityFromDtoInstantiatingConverter.this.getPropertyValueFor(targetProperty, this.val$sourceEntity, this.val$sourceAccessor);
            }
        });
        PersistentPropertyAccessor dtoAccessor = targetEntity.getPropertyAccessor(entity);
        targetEntity.doWithAll(property -> {
            if (creator.isCreatorParameter(property)) {
                return;
            }
            Object propertyValue = this.getPropertyValueFor(property, sourceEntity, sourceAccessor);
            dtoAccessor.setProperty(property, propertyValue);
        });
        return (T)entity;
    }

    @Nullable
    Object getPropertyValueFor(PersistentProperty<?> targetProperty, PersistentEntity<?, ?> sourceEntity, PersistentPropertyAccessor<?> sourceAccessor) {
        String targetPropertyName = targetProperty.getName();
        Class targetPropertyType = targetProperty.getType();
        PersistentProperty sourceProperty = sourceEntity.getPersistentProperty(targetPropertyName);
        Object propertyValue = null;
        if (sourceProperty != null) {
            propertyValue = sourceAccessor.getProperty(sourceProperty);
        }
        if (propertyValue == null && targetPropertyType.isPrimitive()) {
            return ReflectionUtils.getPrimitiveDefault((Class)targetPropertyType);
        }
        if (targetProperty.isAssociation() && !targetProperty.isAnnotationPresent(TargetNode.class) && targetProperty.isCollectionLike()) {
            EntityFromDtoInstantiatingConverter nestedConverter = this.converterCache.computeIfAbsent(targetProperty.getComponentType(), t -> new EntityFromDtoInstantiatingConverter<T>(t, this.context));
            Collection source = (Collection)propertyValue;
            if (source == null) {
                return CollectionFactory.createCollection((Class)targetPropertyType, (int)0);
            }
            Collection target = CollectionFactory.createApproximateCollection((Object)source, (int)source.size());
            source.stream().map(nestedConverter::convert).forEach(target::add);
            return target;
        }
        if (propertyValue != null && !targetPropertyType.isInstance(propertyValue)) {
            Neo4jConversionService conversionService = this.context.getConversionService();
            if (conversionService.isSimpleType(targetPropertyType)) {
                return conversionService.convert(propertyValue, targetPropertyType);
            }
            EntityFromDtoInstantiatingConverter nestedConverter = this.converterCache.computeIfAbsent(targetProperty.getType(), t -> new EntityFromDtoInstantiatingConverter<T>(t, this.context));
            return nestedConverter.convert(propertyValue);
        }
        return propertyValue;
    }
}

