/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Driver;
import org.springframework.data.neo4j.config.Builtin;
import org.springframework.data.neo4j.config.Neo4jCdiExtension;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@API(status=API.Status.INTERNAL, since="6.0")
@ApplicationScoped
class Neo4jCdiConfigurationSupport {
    Neo4jCdiConfigurationSupport() {
    }

    private <T> T resolve(Instance<T> instance) {
        if (!instance.isAmbiguous()) {
            return (T)instance.get();
        }
        Instance defaultInstance = instance.select(new Annotation[]{Neo4jCdiExtension.DEFAULT_BEAN});
        return (T)defaultInstance.get();
    }

    @Produces
    @Builtin
    @Singleton
    public Neo4jConversions neo4jConversions() {
        return new Neo4jConversions();
    }

    @Produces
    @Builtin
    @Singleton
    public DatabaseSelectionProvider databaseSelectionProvider() {
        return DatabaseSelectionProvider.getDefaultSelectionProvider();
    }

    @Produces
    @Builtin
    @Singleton
    public Configuration cypherDslConfiguration() {
        return Configuration.defaultConfig();
    }

    @Produces
    @Builtin
    @Singleton
    public Neo4jOperations neo4jOperations(@Any Instance<Neo4jClient> neo4jClient, @Any Instance<Neo4jMappingContext> mappingContext, @Any Instance<Configuration> cypherDslConfiguration) {
        Neo4jTemplate neo4jTemplate = new Neo4jTemplate(this.resolve(neo4jClient), this.resolve(mappingContext));
        neo4jTemplate.setCypherRenderer(Renderer.getRenderer((Configuration)this.resolve(cypherDslConfiguration)));
        return neo4jTemplate;
    }

    @Produces
    @Singleton
    public Neo4jClient neo4jClient(Driver driver) {
        return Neo4jClient.create(driver);
    }

    @Produces
    @Singleton
    public Neo4jMappingContext neo4jMappingContext(Driver driver, @Any Instance<Neo4jConversions> neo4JConversions) {
        return Neo4jMappingContext.builder().withNeo4jConversions(this.resolve(neo4JConversions)).withTypeSystem(driver.defaultTypeSystem()).build();
    }

    @Produces
    @Singleton
    public PlatformTransactionManager transactionManager(Driver driver, @Any Instance<DatabaseSelectionProvider> databaseNameProvider) {
        return new Neo4jTransactionManager(driver, this.resolve(databaseNameProvider));
    }
}

