/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.neo4j.core.ReactiveFluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.2")
final class ReactiveFluentQueryByPredicate<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.ReactiveFluentQuery<R> {
    private final Predicate predicate;
    private final Neo4jPersistentEntity<S> metaData;
    private final ReactiveFluentFindOperation findOperation;
    private final Function<Predicate, Mono<Long>> countOperation;
    private final Function<Predicate, Mono<Boolean>> existsOperation;
    private final Neo4jMappingContext mappingContext;

    ReactiveFluentQueryByPredicate(Predicate predicate, Neo4jMappingContext mappingContext, Neo4jPersistentEntity<S> metaData, Class<R> resultType, ReactiveFluentFindOperation findOperation, Function<Predicate, Mono<Long>> countOperation, Function<Predicate, Mono<Boolean>> existsOperation) {
        this(predicate, mappingContext, metaData, resultType, findOperation, countOperation, existsOperation, Sort.unsorted(), null, null);
    }

    ReactiveFluentQueryByPredicate(Predicate predicate, Neo4jMappingContext mappingContext, Neo4jPersistentEntity<S> metaData, Class<R> resultType, ReactiveFluentFindOperation findOperation, Function<Predicate, Mono<Long>> countOperation, Function<Predicate, Mono<Boolean>> existsOperation, Sort sort, @Nullable Integer limit, @Nullable Collection<String> properties) {
        super(resultType, sort, limit, properties);
        this.predicate = predicate;
        this.mappingContext = mappingContext;
        this.metaData = metaData;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.ReactiveFluentQuery<R> sortBy(Sort sort) {
        return new ReactiveFluentQueryByPredicate<S, R>(this.predicate, this.mappingContext, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.limit, this.properties);
    }

    public FluentQuery.ReactiveFluentQuery<R> limit(int limit) {
        return new ReactiveFluentQueryByPredicate<S, R>(this.predicate, this.mappingContext, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort, limit, this.properties);
    }

    public <NR> FluentQuery.ReactiveFluentQuery<NR> as(Class<NR> resultType) {
        return new ReactiveFluentQueryByPredicate<S, NR>(this.predicate, this.mappingContext, this.metaData, resultType, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.ReactiveFluentQuery<R> project(Collection<String> properties) {
        return new ReactiveFluentQueryByPredicate<S, R>(this.predicate, this.mappingContext, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.limit, this.mergeProperties(this.extractAllPaths(properties)));
    }

    public Mono<R> one() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forConditionAndSort(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), this.sort, this.limit, this.createIncludedFieldsPredicate())).one();
    }

    public Mono<R> first() {
        return this.all().take(1L).singleOrEmpty();
    }

    public Flux<R> all() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forConditionAndSort(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), this.sort, this.limit, this.createIncludedFieldsPredicate())).all();
    }

    public Mono<Page<R>> page(Pageable pageable) {
        Flux results = this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forConditionAndPageable(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), pageable, this.createIncludedFieldsPredicate())).all();
        return results.collectList().zipWith(this.countOperation.apply(this.predicate)).map(tuple -> {
            Page page = PageableExecutionUtils.getPage((List)((List)tuple.getT1()), (Pageable)pageable, () -> (Long)tuple.getT2());
            return page;
        });
    }

    public Mono<Window<R>> scroll(ScrollPosition scrollPosition) {
        Condition condition;
        Condition condition2 = Cypher.adapt((Object)this.predicate).asCondition();
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            condition = CypherAdapterUtils.combineKeysetIntoCondition(this.metaData, keysetScrollPosition, this.sort, this.mappingContext.getConversionService());
        } else {
            condition = null;
        }
        QueryFragmentsAndParameters queryFragmentsAndParameters = QueryFragmentsAndParameters.forConditionWithScrollPosition(this.metaData, condition2, condition, scrollPosition, this.sort, this.limit == null ? 1 : this.limit + 1, this.createIncludedFieldsPredicate());
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(queryFragmentsAndParameters).all().collectList().map(rawResult -> this.scroll(scrollPosition, rawResult, this.metaData));
    }

    public Mono<Long> count() {
        return this.countOperation.apply(this.predicate);
    }

    public Mono<Boolean> exists() {
        return this.existsOperation.apply(this.predicate);
    }
}

